/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.commands;

import com.dlsc.emirates.generated.flights.ROW;
import com.dlsc.emirates.model.AircraftGanttChartNode;
import com.dlsc.emirates.model.FlightTimelineObject;
import com.dlsc.emirates.model.ModelFactory;
import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.ILayer;
import java.util.Calendar;
import javax.swing.tree.TreePath;

public class CreateFlightCommand
extends AbstractCommand {
    private AircraftGanttChartNode acNode;
    private ILayer layer;
    private FlightTimelineObject flight;
    private long timeAtClickLocation;
    private TreePath treePath;
    private ModelFactory modelFactory;
    private String serviceType = "Z";

    public CreateFlightCommand(ModelFactory modelFactory, TreePath treePath, long timeAtClickLocation) {
        super("Create Flight");
        this.modelFactory = modelFactory;
        this.treePath = treePath;
        this.timeAtClickLocation = timeAtClickLocation;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        DefaultGanttChartModel<AircraftGanttChartNode, FlightTimelineObject> model = this.modelFactory.getFleetModel();
        this.acNode.removeTimelineObject(this.layer, this.flight);
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        Calendar s2 = Calendar.getInstance();
        s2.setTimeInMillis(this.timeAtClickLocation);
        Calendar e2 = Calendar.getInstance();
        e2.setTimeInMillis(this.timeAtClickLocation);
        TimeGranularity.SIX_HOURS.increment(e2);
        TimeSpan span = new TimeSpan(s2, e2);
        Object node = this.treePath.getLastPathComponent();
        if (node instanceof AircraftGanttChartNode) {
            this.acNode = (AircraftGanttChartNode)node;
            this.layer = this.modelFactory.getLayerMap().get(this.serviceType);
            ROW original = (ROW)this.acNode.getTypedUserObject();
            ROW row = new ROW();
            row.setACTIVITYID(original.getACTIVITYID());
            row.setFLIGHTID(original.getFLIGHTID());
            row.setACTYPE(original.getACTYPE());
            row.setARRIVALDATE(original.getARRIVALDATE());
            row.setDEPARTURESTATION(original.getDEPARTURESTATION());
            row.setDEPDATETIME(original.getDEPDATETIME());
            row.setFLIGHTDATE(original.getFLIGHTDATE());
            row.setFLIGHTNO(original.getFLIGHTNO());
            row.setORIGINDATE(original.getORIGINDATE());
            row.setResource(original.getResource());
            row.setARRIVALSTATION(original.getARRIVALSTATION());
            row.setAIRLINECODE(original.getAIRLINECODE());
            row.setFLTTYPE(original.getFLTTYPE());
            row.setSERVICETYPE(this.serviceType);
            this.flight = new FlightTimelineObject(row);
            this.flight.setTimeSpan(span);
            this.acNode.addTimelineObject(this.layer, this.flight);
            this.acNode.calculateLines();
        }
    }
}

