/*
 * Decompiled with CFR 0.152.
 */
package com.sun.animation.transitions;

import com.sun.animation.effects.ComponentEffect;
import com.sun.animation.effects.ComponentState;
import com.sun.animation.effects.CompositeEffect;
import com.sun.animation.effects.EffectsManager;
import com.sun.animation.effects.FadeIn;
import com.sun.animation.effects.FadeOut;
import com.sun.animation.effects.Move;
import com.sun.animation.effects.Scale;
import com.sun.animation.effects.Unchanging;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

class AnimationState {
    private JComponent component;
    private ComponentState start;
    private ComponentState end;
    private ComponentEffect effect;

    AnimationState(JComponent component, boolean isStart) {
        this.component = component;
        ComponentState compState = new ComponentState(component);
        if (isStart) {
            this.start = compState;
        } else {
            this.end = compState;
        }
    }

    void setStart(ComponentState compState) {
        this.start = compState;
    }

    void setEnd(ComponentState compState) {
        this.end = compState;
    }

    ComponentState getStart() {
        return this.start;
    }

    ComponentState getEnd() {
        return this.end;
    }

    Component getComponent() {
        return this.component;
    }

    void init() {
        if (this.start == null) {
            this.effect = new FadeIn(this.end);
        } else if (this.end == null) {
            this.effect = new FadeOut(this.start);
        } else {
            this.effect = EffectsManager.getEffect(this.component, EffectsManager.TransitionType.CHANGING);
            if (this.effect == null) {
                boolean move = false;
                boolean scale = false;
                if (this.start.getX() != this.end.getX() || this.start.getY() != this.end.getY()) {
                    move = true;
                }
                if (this.start.getWidth() != this.end.getWidth() || this.start.getHeight() != this.end.getHeight()) {
                    scale = true;
                }
                if (move) {
                    if (scale) {
                        Move moveEffect = new Move(this.start, this.end);
                        Scale scaleEffect = new Scale(this.start, this.end);
                        this.effect = new CompositeEffect(moveEffect);
                        ((CompositeEffect)this.effect).addEffect(scaleEffect);
                    } else {
                        this.effect = new Move(this.start, this.end);
                    }
                } else {
                    this.effect = scale ? new Scale(this.start, this.end) : new Unchanging(this.start, this.end);
                }
            } else {
                this.effect.setStart(this.start);
                this.effect.setEnd(this.end);
            }
        }
    }

    void paint(Graphics g2, float fraction) {
        if (this.effect != null) {
            Graphics2D g2d = (Graphics2D)g2.create();
            this.effect.setup(g2d, fraction);
            this.effect.paint(g2d);
            g2d.dispose();
        }
    }
}

