/*
 * Decompiled with CFR 0.152.
 */
package com.sun.animation.transitions;

import com.sun.animation.effects.CompositeEffect;
import com.sun.animation.effects.EffectsManager;
import com.sun.animation.effects.Move;
import com.sun.animation.effects.Rotate;
import com.sun.animation.transitions.ScreenTransition;
import com.sun.animation.transitions.TransitionTarget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class AnimatingGUI
extends JComponent
implements ActionListener,
TransitionTarget {
    JLabel label = new JLabel("Label");
    JButton button1 = new JButton("1");
    JButton button2 = new JButton("2");
    JButton button3 = new JButton("3");
    JButton button4 = new JButton("4");
    JTextField textField = new JTextField("<sample text>");
    JTable table = new JTable(25, 7);
    JScrollPane scroller = new JScrollPane(this.table);
    JComponent transitionContainer = new JPanel(null);
    ScreenTransition transitionPanel = new ScreenTransition(this.transitionContainer, this);
    JButton containedButton = new JButton("blah");
    JPanel buttonContainer = new JPanel();
    JPanel buttonPanel = null;
    JComponent thumbnail = new JPanel();
    static final int FRAME_W = 300;
    static final int FRAME_H = 300;
    int currentScreen = 1;
    Image gradientImage;
    int prevW = -1;
    int prevH = -1;

    public AnimatingGUI() {
        this.transitionContainer.setOpaque(false);
        this.buttonContainer.add(this.containedButton);
        this.buttonContainer.setBorder(new BevelBorder(1));
        Move moveEffect = new Move(null, null);
        Rotate rotateEffect = new Rotate(null, null, 360, 15, 10);
        CompositeEffect compositeEffect = new CompositeEffect(moveEffect);
        compositeEffect.addEffect(rotateEffect);
        EffectsManager.setEffect(this.label, compositeEffect, EffectsManager.TransitionType.CHANGING);
        this.setLayout(new BorderLayout());
        this.setupButtons();
        this.add((Component)this.transitionContainer, "Center");
        this.setupFirstScreen();
        this.button1.addActionListener(this);
        this.button2.addActionListener(this);
        this.button3.addActionListener(this);
        this.button4.addActionListener(this);
    }

    public void setupButtons() {
        this.buttonPanel = new JPanel();
        this.add((Component)this.buttonPanel, "North");
        this.buttonPanel.add(this.button1);
        this.buttonPanel.add(this.button2);
        this.buttonPanel.add(this.button3);
        this.buttonPanel.add(this.button4);
    }

    public void setupFirstScreen() {
        this.transitionContainer.add(this.label);
        this.label.setBounds(50, 100, 60, 20);
        this.transitionContainer.add(this.textField);
        this.textField.setBounds(this.label.getX() + this.label.getWidth() + 10, this.label.getY() - 5, 100, 30);
        this.transitionContainer.add(this.thumbnail);
        this.thumbnail.setBounds(0, 150, 50, 60);
    }

    public void setupSecondScreen() {
        this.transitionContainer.add(this.label);
        this.label.setBounds(10, 50, 60, 20);
        this.transitionContainer.add(this.textField);
        this.textField.setBounds(this.label.getX() + this.label.getWidth() + 5, this.label.getY() - 5, 100, 30);
        this.transitionContainer.add(this.scroller);
        int y2 = this.label.getY() + this.label.getHeight() + 50;
        this.scroller.setBounds(0, y2, this.getWidth(), this.getHeight() - y2);
        this.transitionContainer.add(this.thumbnail);
        this.thumbnail.setBounds(50, 0, 25, 30);
    }

    public void setupThirdScreen() {
        this.transitionContainer.add(this.buttonContainer);
        this.buttonContainer.setBounds(100, 100, 100, 100);
        this.transitionContainer.add(this.label);
        this.label.setBounds(70, 30, 60, 20);
        this.transitionContainer.add(this.textField);
        this.textField.setBounds(this.label.getX() + this.label.getWidth() + 5, this.label.getY() - 5, 100, 30);
    }

    public void setupFourthScreen() {
        this.transitionContainer.add(this.label);
        this.label.setBounds(10, 50, 60, 20);
        this.transitionContainer.add(this.textField);
        this.textField.setBounds(this.label.getX() + this.label.getWidth() + 5, this.label.getY() - 5, 100, 30);
        this.transitionContainer.add(this.scroller);
        int y2 = this.label.getY() + this.label.getHeight() + 50;
        this.scroller.setBounds(50, y2, this.getWidth() - 100, this.getHeight() - y2 - 50);
        this.transitionContainer.add(this.thumbnail);
        this.thumbnail.setBounds(50, 0, 25, 30);
    }

    @Override
    public void resetCurrentScreen() {
        this.transitionContainer.removeAll();
    }

    @Override
    public void transitionComplete() {
    }

    @Override
    public void setupNextScreen() {
        switch (this.currentScreen) {
            case 1: {
                this.setupFirstScreen();
                break;
            }
            case 2: {
                this.setupSecondScreen();
                break;
            }
            case 3: {
                this.setupThirdScreen();
                break;
            }
            case 4: {
                this.setupFourthScreen();
                break;
            }
            default: {
                System.out.println("unknown screen" + this.currentScreen);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object actionSource = ae.getSource();
        if (actionSource.equals(this.button1)) {
            this.currentScreen = 1;
        } else if (actionSource.equals(this.button2)) {
            this.currentScreen = 2;
        } else if (actionSource.equals(this.button3)) {
            this.currentScreen = 3;
        } else if (actionSource.equals(this.button4)) {
            this.currentScreen = 4;
        } else {
            System.out.println("unknown action event: " + ae);
            return;
        }
        this.transitionPanel.startTransition(1000);
    }

    @Override
    public void paintComponent(Graphics g2) {
        if (this.gradientImage == null || this.prevW != this.getWidth() || this.prevH != this.getHeight()) {
            this.gradientImage = this.createImage(this.getWidth(), this.getHeight());
            Graphics2D g2d = (Graphics2D)this.gradientImage.getGraphics();
            GradientPaint bgGradient = new GradientPaint(0.0f, 0.0f, Color.lightGray, 0.0f, this.getHeight(), Color.blue);
            g2d.setPaint(bgGradient);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.dispose();
            this.prevW = this.getWidth();
            this.prevH = this.getHeight();
        }
        g2.drawImage(this.gradientImage, 0, 0, null);
    }

    private static void createAndShowGUI() {
        JFrame f2 = new JFrame();
        f2.setDefaultCloseOperation(3);
        f2.setSize(300, 300);
        AnimatingGUI component = new AnimatingGUI();
        f2.add(component);
        f2.setVisible(true);
    }

    public static void main(String[] args) {
        Runnable doCreateAndShowGUI = new Runnable(){

            @Override
            public void run() {
                AnimatingGUI.createAndShowGUI();
            }
        };
        SwingUtilities.invokeLater(doCreateAndShowGUI);
    }

    class GradientPanel
    extends JComponent {
        public GradientPanel() {
            this.setOpaque(false);
        }

        @Override
        public void paintComponent(Graphics g2) {
            if (AnimatingGUI.this.gradientImage == null || AnimatingGUI.this.prevW != this.getWidth() || AnimatingGUI.this.prevH != this.getHeight()) {
                AnimatingGUI.this.gradientImage = this.createImage(this.getWidth(), this.getHeight());
                Graphics2D g2d = (Graphics2D)AnimatingGUI.this.gradientImage.getGraphics();
                GradientPaint bgGradient = new GradientPaint(0.0f, 0.0f, Color.lightGray, 0.0f, this.getHeight(), Color.blue);
                g2d.setPaint(bgGradient);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2d.dispose();
                AnimatingGUI.this.prevW = this.getWidth();
                AnimatingGUI.this.prevH = this.getHeight();
            }
            g2.drawImage(AnimatingGUI.this.gradientImage, 0, 0, null);
        }
    }
}

