/*
 * Decompiled with CFR 0.152.
 */
package com.sun.animation.effects;

import com.sun.animation.effects.ComponentEffect;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

public class EffectsManager {
    private static final Map<Component, ComponentEffect> cachedChangingEffects = new HashMap<Component, ComponentEffect>();
    private static final Map<Component, ComponentEffect> cachedAppearingEffects = new HashMap<Component, ComponentEffect>();
    private static final Map<Component, ComponentEffect> cachedDisappearingEffects = new HashMap<Component, ComponentEffect>();

    public static void setEffect(Component component, ComponentEffect effect, TransitionType transitionType) {
        switch (transitionType) {
            case CHANGING: {
                cachedChangingEffects.put(component, effect);
                break;
            }
            case APPEARING: {
                cachedAppearingEffects.put(component, effect);
                break;
            }
            case DISAPPEARING: {
                cachedDisappearingEffects.put(component, effect);
                break;
            }
            default: {
                throw new InternalError("unknown TransitionType");
            }
        }
    }

    public static ComponentEffect getEffect(Component component, TransitionType transitionType) {
        switch (transitionType) {
            case CHANGING: {
                return cachedChangingEffects.get(component);
            }
            case APPEARING: {
                return cachedAppearingEffects.get(component);
            }
            case DISAPPEARING: {
                return cachedDisappearingEffects.get(component);
            }
        }
        throw new InternalError("unknown TransitionType");
    }

    private EffectsManager() {
    }

    public static enum TransitionType {
        CHANGING,
        APPEARING,
        DISAPPEARING;

    }
}

