/*
 * Decompiled with CFR 0.152.
 */
package com.sun.animation.effects;

import com.sun.animation.effects.ComponentState;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JComponent;

public abstract class ComponentEffect {
    protected ComponentState start;
    protected ComponentState end;
    protected boolean renderComponent = false;
    protected Image componentImage;
    protected int x;
    protected int y;
    protected int width;
    protected int height;

    protected JComponent getComponent() {
        if (this.start != null) {
            return this.start.getComponent();
        }
        if (this.end != null) {
            return this.end.getComponent();
        }
        return null;
    }

    void setRenderComponent(boolean renderComponent) {
        this.renderComponent = renderComponent;
    }

    boolean getRenderComponent() {
        return this.renderComponent;
    }

    public void setComponentStates(ComponentState start, ComponentState end) {
        this.start = start;
        this.end = end;
    }

    public void setStart(ComponentState start) {
        this.start = start;
    }

    public ComponentState getStart() {
        return this.start;
    }

    public void setEnd(ComponentState end) {
        this.end = end;
    }

    public ComponentState getEnd() {
        return this.end;
    }

    public Image getComponentImage() {
        return this.componentImage;
    }

    protected void setComponentImage(Image componentImage) {
        this.componentImage = componentImage;
    }

    private void createComponentImage() {
        if (this.start != null && this.end == null) {
            this.componentImage = this.start.getSnapshot();
        } else if (this.start == null && this.end != null) {
            this.componentImage = this.end.getSnapshot();
        } else if (this.start.getWidth() != this.end.getWidth() || this.start.getHeight() != this.end.getHeight()) {
            float widthFraction = (float)this.end.getWidth() / (float)this.start.getWidth();
            float heightFraction = (float)this.end.getHeight() / (float)this.start.getHeight();
            this.componentImage = Math.abs(widthFraction - 1.0f) > Math.abs(heightFraction - 1.0f) ? (widthFraction < 1.0f ? this.start.getSnapshot() : this.end.getSnapshot()) : (heightFraction < 1.0f ? this.start.getSnapshot() : this.end.getSnapshot());
        } else {
            this.componentImage = this.start.getSnapshot();
        }
    }

    public void setup(Graphics2D g2d, float fraction) {
        if (!this.renderComponent && this.componentImage == null) {
            this.createComponentImage();
        }
        if (this.renderComponent) {
            this.x = ComponentEffect.getPosition(this.start.getX(), this.end.getX(), fraction);
            this.y = ComponentEffect.getPosition(this.start.getY(), this.end.getY(), fraction);
            this.width = ComponentEffect.getPosition(this.start.getWidth(), this.end.getWidth(), fraction);
            this.height = ComponentEffect.getPosition(this.start.getHeight(), this.end.getHeight(), fraction);
        }
    }

    public void paint(Graphics2D g2d) {
        if (!this.renderComponent && this.componentImage != null) {
            g2d.drawImage(this.componentImage, 0, 0, null);
        } else {
            this.getComponent().setBounds(this.x, this.y, this.width, this.height);
            this.getComponent().validate();
            ComponentState.paintComponentSingleBuffered(this.getComponent(), g2d);
        }
    }

    private static int getPosition(int start, int end, float fraction) {
        return (int)(fraction * (float)(end - start)) + start;
    }
}

