/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.widgets;

import com.jtechdev.painter.MacWidgetsPainter;
import com.jtechdev.swingx.EPToggleButton;
import com.jtechdev.widgets.PopupMenuCustomizer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopdownButton {
    private final EPToggleButton fButton;
    private PopupMenuCustomizer fPopupMenuCustomizer;
    private JPopupMenu fPopupMenu = new JPopupMenu();

    public PopdownButton(Icon icon, PopupMenuCustomizer popupMenuCustomizer) {
        if (popupMenuCustomizer == null) {
            throw new IllegalArgumentException("The list of items to add tothe popup menu cannot be null.");
        }
        this.fButton = new EPToggleButton(icon);
        this.fButton.setPressedIcon(icon);
        this.fPopupMenuCustomizer = popupMenuCustomizer;
        this.init();
    }

    private void init() {
        this.fButton.addMouseListener(this.createToggleButtonMouseListener());
        this.fButton.addMouseMotionListener(this.createToggleButtonMouseMotionListener());
        this.fPopupMenu.addPopupMenuListener(this.createPopupMenuListener());
        JComboBox box = new JComboBox();
        Object preventHide = box.getClientProperty("doNotCancelPopup");
        this.fButton.putClientProperty("doNotCancelPopup", preventHide);
    }

    public void setBackgroundPainter(MacWidgetsPainter<AbstractButton> painter) {
        this.fButton.setBackgroundPainter(painter);
    }

    public JComponent getComponent() {
        return this.fButton;
    }

    public void setPressedIcon(Icon pressedIcon) {
        this.fButton.setPressedIcon(pressedIcon);
    }

    private void showPopupMenu() {
        this.fPopupMenu.pack();
        this.fPopupMenu.show(this.fButton, 0, this.fButton.getHeight());
    }

    private void hidePopupMenu() {
        this.fPopupMenu.setVisible(false);
        this.fButton.setSelected(false);
    }

    private MouseListener createToggleButtonMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (!PopdownButton.this.fButton.isSelected()) {
                    PopdownButton.this.hidePopupMenu();
                }
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                PopdownButton.this.showPopupMenu();
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                manager.processMouseEvent(e2);
            }
        };
    }

    private MouseMotionListener createToggleButtonMouseMotionListener() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                MenuSelectionManager.defaultManager().processMouseEvent(e2);
            }
        };
    }

    private PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
                PopdownButton.this.fPopupMenuCustomizer.customizePopup(PopdownButton.this.fPopupMenu);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
                PopdownButton.this.fButton.setSelected(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e2) {
            }
        };
    }
}

