/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.painter;

import com.jtechdev.painter.MacWidgetsPainter;
import java.awt.Component;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;

public class ButtonStatePainter<B extends AbstractButton>
implements MacWidgetsPainter<B> {
    private final MacWidgetsPainter<Component> fDefaultPainter;
    private final MacWidgetsPainter<Component> fRolloverPainter;
    private final MacWidgetsPainter<Component> fPressedPainter;
    private final MacWidgetsPainter<Component> fSelectedPainter;

    public ButtonStatePainter(MacWidgetsPainter<Component> defaultPainter) {
        this(defaultPainter, defaultPainter, defaultPainter, defaultPainter);
    }

    public ButtonStatePainter(MacWidgetsPainter<Component> defaultPainter, MacWidgetsPainter<Component> rolloverPainter, MacWidgetsPainter<Component> pressedPainter, MacWidgetsPainter<Component> selectedPainter) {
        this.fDefaultPainter = defaultPainter;
        this.fRolloverPainter = rolloverPainter;
        this.fPressedPainter = pressedPainter;
        this.fSelectedPainter = selectedPainter;
    }

    @Override
    public void paint(Graphics2D g2, B button, int width, int height) {
        if (((AbstractButton)button).getModel().isRollover()) {
            this.fRolloverPainter.paint(g2, (Component)button, width, height);
        } else if (((AbstractButton)button).getModel().isPressed()) {
            this.fPressedPainter.paint(g2, (Component)button, width, height);
        } else if (((AbstractButton)button).getModel().isSelected()) {
            this.fSelectedPainter.paint(g2, (Component)button, width, height);
        } else {
            this.fDefaultPainter.paint(g2, (Component)button, width, height);
        }
    }

    public static class DummyPainter
    implements MacWidgetsPainter<Component> {
        @Override
        public void paint(Graphics2D g2, Component component, int width, int height) {
        }
    }
}

