/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.macwidgets;

import com.jtechdev.macwidgets.ITunesRatingTableCellRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class RatingStarEditorPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private int lastX = Integer.MIN_VALUE;
    private int lastY = Integer.MIN_VALUE;
    private int xoffset = 5;
    private int yoffset = 2;

    public RatingStarEditorPanel() {
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        this.processCoordinates(e2);
        this.repaint();
    }

    private void recordCoordinates(MouseEvent e2) {
        this.lastX = e2.getX();
        this.lastY = e2.getY();
    }

    private boolean validateCoordinates(MouseEvent e2) {
        Point location = this.getLocation();
        Dimension size = this.getSize();
        if ((double)e2.getX() < location.getX() || (double)e2.getX() > location.getX() + size.getWidth()) {
            return false;
        }
        return !((double)e2.getY() < location.getY()) && !((double)e2.getY() > location.getY() + size.getHeight());
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.processCoordinates(e2);
        this.repaint();
    }

    private void processCoordinates(MouseEvent e2) {
        if (e2 != null && this.validateCoordinates(e2)) {
            this.recordCoordinates(e2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.processCoordinates(e2);
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    public int getLevel() {
        if (this.lastX == Integer.MIN_VALUE || this.lastY == Integer.MIN_VALUE) {
            return 0;
        }
        int min = (int)this.getLocation().getX();
        int max = min + (int)this.getSize().getWidth();
        return (int)Math.ceil((double)(this.lastX - min) / (double)(max - min) * 5.0);
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        Image star = new ImageIcon(ITunesRatingTableCellRenderer.class.getResource("/com/jtechdev/macwidgets/images/itunes_star_unselected.png")).getImage();
        int level = this.getLevel();
        g22.clearRect(0, 0, this.getWidth(), this.getHeight());
        for (int i2 = 0; i2 < level; ++i2) {
            g22.drawImage(star, i2 * star.getWidth(null) + this.xoffset, this.yoffset, null, null);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        this.processCoordinates(e2);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }
}

