/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.vecmath;

public class Tuple4f {
    public float x;
    public float y;
    public float z;
    public float w;

    public Tuple4f() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Tuple4f(float[] x2) {
        this.x = x2[0];
        this.y = x2[1];
        this.z = x2[2];
        this.w = x2[2];
    }

    public Tuple4f(float x2, float y2, float z2, float w2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.w = w2;
    }

    public Tuple4f(Tuple4f t2) {
        this.x = t2.x;
        this.y = t2.y;
        this.z = t2.z;
        this.w = t2.w;
    }

    public void absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        this.w = Math.abs(this.w);
    }

    public void absolute(Tuple4f t2) {
        this.x = Math.abs(t2.x);
        this.y = Math.abs(t2.y);
        this.z = Math.abs(t2.z);
        this.w = Math.abs(t2.w);
    }

    public void clamp(float min, float max) {
        if (this.x < min) {
            this.x = min;
        } else if (this.x > max) {
            this.x = max;
        }
        if (this.y < min) {
            this.y = min;
        } else if (this.y > max) {
            this.y = max;
        }
        if (this.z < min) {
            this.z = min;
        } else if (this.z > max) {
            this.z = max;
        }
        if (this.w < min) {
            this.w = min;
        } else if (this.w > max) {
            this.w = max;
        }
    }

    public void set(float x2, float y2, float z2, float w2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.w = w2;
    }

    public void set(float[] x2) {
        this.x = x2[0];
        this.y = x2[1];
        this.z = x2[2];
        this.w = x2[2];
    }

    public void set(Tuple4f t2) {
        this.x = t2.x;
        this.y = t2.y;
        this.z = t2.z;
        this.w = t2.w;
    }

    public void get(Tuple4f t2) {
        t2.x = this.x;
        t2.y = this.y;
        t2.z = this.z;
        t2.w = this.w;
    }

    public void get(float[] t2) {
        t2[0] = this.x;
        t2[1] = this.y;
        t2[2] = this.z;
        t2[3] = this.w;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
    }

    public void negate(Tuple4f t2) {
        this.x = -t2.x;
        this.y = -t2.y;
        this.z = -t2.z;
        this.w = -t2.w;
    }

    public void interpolate(Tuple4f t2, float alpha) {
        float a2 = 1.0f - alpha;
        this.x = a2 * this.x + alpha * t2.x;
        this.y = a2 * this.y + alpha * t2.y;
        this.z = a2 * this.z + alpha * t2.z;
        this.w = a2 * this.w + alpha * t2.w;
    }

    public void scale(float s2) {
        this.x *= s2;
        this.y *= s2;
        this.z *= s2;
        this.w *= s2;
    }

    public void add(Tuple4f t2) {
        this.x += t2.x;
        this.y += t2.y;
        this.z += t2.z;
        this.w += t2.w;
    }

    public void add(Tuple4f t1, Tuple4f t2) {
        this.x = t1.x + t2.x;
        this.y = t1.y + t2.y;
        this.z = t1.z + t2.z;
        this.w = t1.w + t2.w;
    }

    public void sub(Tuple4f t2) {
        this.x -= t2.x;
        this.y -= t2.y;
        this.z -= t2.z;
        this.w -= t2.w;
    }

    public void sub(Tuple4f t1, Tuple4f t2) {
        this.x = t1.x - t2.x;
        this.y = t1.y - t2.y;
        this.z = t1.z - t2.z;
        this.w = t1.w - t2.w;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + "]";
    }
}

