/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;

public class ReduceNoiseFilter
extends WholeImageFilter {
    private int smooth(int[] v2) {
        int minindex = 0;
        int maxindex = 0;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < 9; ++i2) {
            if (i2 == 4) continue;
            if (v2[i2] < min) {
                min = v2[i2];
                minindex = i2;
            }
            if (v2[i2] <= max) continue;
            max = v2[i2];
            maxindex = i2;
        }
        if (v2[4] < min) {
            return v2[minindex];
        }
        if (v2[4] > max) {
            return v2[maxindex];
        }
        return v2[4];
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int index = 0;
        int[] r2 = new int[9];
        int[] g2 = new int[9];
        int[] b2 = new int[9];
        int[] outPixels = new int[width * height];
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int k2 = 0;
                for (int dy = -1; dy <= 1; ++dy) {
                    int iy = y2 + dy;
                    if (0 > iy || iy >= height) continue;
                    int ioffset = iy * width;
                    for (int dx = -1; dx <= 1; ++dx) {
                        int ix = x2 + dx;
                        if (0 > ix || ix >= width) continue;
                        int rgb = inPixels[ioffset + ix];
                        r2[k2] = rgb >> 16 & 0xFF;
                        g2[k2] = rgb >> 8 & 0xFF;
                        b2[k2] = rgb & 0xFF;
                        ++k2;
                    }
                }
                while (k2 < 9) {
                    b2[k2] = 0;
                    g2[k2] = 0;
                    r2[k2] = 0;
                    ++k2;
                }
                outPixels[index] = inPixels[index] & 0xFF000000 | this.smooth(r2) << 16 | this.smooth(g2) << 8 | this.smooth(b2);
                ++index;
            }
        }
        return outPixels;
    }

    public String toString() {
        return "Blur/Smooth";
    }
}

