/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.PointFilter;
import java.util.Random;

public class NoiseFilter
extends PointFilter {
    public static final int GAUSSIAN = 0;
    public static final int UNIFORM = 1;
    private int amount = 25;
    private int distribution = 1;
    private boolean monochrome = false;
    private float density = 1.0f;
    private Random randomNumbers = new Random();

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setDistribution(int distribution) {
        this.distribution = distribution;
    }

    public int getDistribution() {
        return this.distribution;
    }

    public void setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
    }

    public boolean getMonochrome() {
        return this.monochrome;
    }

    public void setDensity(float density) {
        this.density = density;
    }

    public float getDensity() {
        return this.density;
    }

    private int random(int x2) {
        if ((x2 += (int)((this.distribution == 0 ? this.randomNumbers.nextGaussian() : (double)(2.0f * this.randomNumbers.nextFloat() - 1.0f)) * (double)this.amount)) < 0) {
            x2 = 0;
        } else if (x2 > 255) {
            x2 = 255;
        }
        return x2;
    }

    public int filterRGB(int x2, int y2, int rgb) {
        if (this.randomNumbers.nextFloat() <= this.density) {
            int a2 = rgb & 0xFF000000;
            int r2 = rgb >> 16 & 0xFF;
            int g2 = rgb >> 8 & 0xFF;
            int b2 = rgb & 0xFF;
            if (this.monochrome) {
                int n2 = (int)((this.distribution == 0 ? this.randomNumbers.nextGaussian() : (double)(2.0f * this.randomNumbers.nextFloat() - 1.0f)) * (double)this.amount);
                r2 = PixelUtils.clamp(r2 + n2);
                g2 = PixelUtils.clamp(g2 + n2);
                b2 = PixelUtils.clamp(b2 + n2);
            } else {
                r2 = this.random(r2);
                g2 = this.random(g2);
                b2 = this.random(b2);
            }
            return a2 | r2 << 16 | g2 << 8 | b2;
        }
        return rgb;
    }

    public String toString() {
        return "Stylize/Add Noise...";
    }
}

