/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PixelUtils;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class ImageCombiningFilter {
    public int filterRGB(int x2, int y2, int rgb1, int rgb2) {
        int a1 = rgb1 >> 24 & 0xFF;
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int a2 = rgb2 >> 24 & 0xFF;
        int r2 = rgb2 >> 16 & 0xFF;
        int g2 = rgb2 >> 8 & 0xFF;
        int b2 = rgb2 & 0xFF;
        int r3 = PixelUtils.clamp(r1 + r2);
        int g3 = PixelUtils.clamp(r1 + r2);
        int b3 = PixelUtils.clamp(r1 + r2);
        return a1 << 24 | r3 << 16 | g3 << 8 | b3;
    }

    public ImageProducer filter(Image image1, Image image2, int x2, int y2, int w2, int h2) {
        int[] pixels1 = new int[w2 * h2];
        int[] pixels2 = new int[w2 * h2];
        int[] pixels3 = new int[w2 * h2];
        PixelGrabber pg1 = new PixelGrabber(image1, x2, y2, w2, h2, pixels1, 0, w2);
        PixelGrabber pg2 = new PixelGrabber(image2, x2, y2, w2, h2, pixels2, 0, w2);
        try {
            pg1.grabPixels();
            pg2.grabPixels();
        }
        catch (InterruptedException e2) {
            System.err.println("interrupted waiting for pixels!");
            return null;
        }
        if ((pg1.status() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return null;
        }
        if ((pg2.status() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return null;
        }
        for (int j2 = 0; j2 < h2; ++j2) {
            for (int i2 = 0; i2 < w2; ++i2) {
                int k2 = j2 * w2 + i2;
                pixels3[k2] = this.filterRGB(x2 + i2, y2 + j2, pixels1[k2], pixels2[k2]);
            }
        }
        return new MemoryImageSource(w2, h2, pixels3, 0, w2);
    }
}

