/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public class FlipFilter
extends AbstractBufferedImageOp {
    public static final int FLIP_H = 1;
    public static final int FLIP_V = 2;
    public static final int FLIP_HV = 3;
    public static final int FLIP_90CW = 4;
    public static final int FLIP_90CCW = 5;
    public static final int FLIP_180 = 6;
    private int operation;
    private int width;
    private int height;
    private int newWidth;
    private int newHeight;

    public FlipFilter() {
        this(3);
    }

    public FlipFilter(int operation) {
        this.operation = operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public int getOperation() {
        return this.operation;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        int type = src.getType();
        WritableRaster srcRaster = src.getRaster();
        int[] inPixels = this.getRGB(src, 0, 0, width, height, null);
        int x2 = 0;
        int y2 = 0;
        int w2 = width;
        int h2 = height;
        int newX = 0;
        int newY = 0;
        int newW = w2;
        int newH = h2;
        switch (this.operation) {
            case 1: {
                newX = width - (x2 + w2);
                break;
            }
            case 2: {
                newY = height - (y2 + h2);
                break;
            }
            case 3: {
                newW = h2;
                newH = w2;
                newX = y2;
                newY = x2;
                break;
            }
            case 4: {
                newW = h2;
                newH = w2;
                newX = height - (y2 + h2);
                newY = x2;
                break;
            }
            case 5: {
                newW = h2;
                newH = w2;
                newX = y2;
                newY = width - (x2 + w2);
                break;
            }
            case 6: {
                newX = width - (x2 + w2);
                newY = height - (y2 + h2);
            }
        }
        int[] newPixels = new int[newW * newH];
        for (int row = 0; row < h2; ++row) {
            for (int col = 0; col < w2; ++col) {
                int index = row * width + col;
                int newRow = row;
                int newCol = col;
                switch (this.operation) {
                    case 1: {
                        newCol = w2 - col - 1;
                        break;
                    }
                    case 2: {
                        newRow = h2 - row - 1;
                        break;
                    }
                    case 3: {
                        newRow = col;
                        newCol = row;
                        break;
                    }
                    case 4: {
                        newRow = col;
                        newCol = h2 - row - 1;
                        break;
                    }
                    case 5: {
                        newRow = w2 - col - 1;
                        newCol = row;
                        break;
                    }
                    case 6: {
                        newRow = h2 - row - 1;
                        newCol = w2 - col - 1;
                    }
                }
                int newIndex = newRow * newW + newCol;
                newPixels[newIndex] = inPixels[index];
            }
        }
        if (dst == null) {
            ColorModel dstCM = src.getColorModel();
            dst = new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(newW, newH), dstCM.isAlphaPremultiplied(), null);
        }
        WritableRaster dstRaster = dst.getRaster();
        this.setRGB(dst, 0, 0, newW, newH, newPixels);
        return dst;
    }

    public String toString() {
        switch (this.operation) {
            case 1: {
                return "Flip Horizontal";
            }
            case 2: {
                return "Flip Vertical";
            }
            case 3: {
                return "Flip Diagonal";
            }
            case 4: {
                return "Rotate 90";
            }
            case 5: {
                return "Rotate -90";
            }
            case 6: {
                return "Rotate 180";
            }
        }
        return "Flip";
    }
}

