/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.ImageUtils;
import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.TransformFilter;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public class CurlFilter
extends TransformFilter {
    private float angle = 0.0f;
    private float transition = 0.0f;
    private float width;
    private float height;
    private float radius;

    public CurlFilter() {
        this.setEdgeAction(0);
    }

    public void setTransition(float transition) {
        this.transition = transition;
    }

    public float getTransition() {
        return this.transition;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadius() {
        return this.radius;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        this.width = src.getWidth();
        this.height = src.getHeight();
        int type = src.getType();
        this.originalSpace = new Rectangle(0, 0, width, height);
        this.transformedSpace = new Rectangle(0, 0, width, height);
        this.transformSpace(this.transformedSpace);
        if (dst == null) {
            ColorModel dstCM = src.getColorModel();
            dst = new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(this.transformedSpace.width, this.transformedSpace.height), dstCM.isAlphaPremultiplied(), null);
        }
        WritableRaster dstRaster = dst.getRaster();
        int[] inPixels = this.getRGB(src, 0, 0, width, height, null);
        if (this.interpolation == 0) {
            return this.filterPixelsNN(dst, width, height, inPixels, this.transformedSpace);
        }
        int srcWidth = width;
        int srcHeight = height;
        int srcWidth1 = width - 1;
        int srcHeight1 = height - 1;
        int outWidth = this.transformedSpace.width;
        int outHeight = this.transformedSpace.height;
        boolean index = false;
        int[] outPixels = new int[outWidth];
        int outX = this.transformedSpace.x;
        int outY = this.transformedSpace.y;
        float[] out = new float[4];
        for (int y2 = 0; y2 < outHeight; ++y2) {
            for (int x2 = 0; x2 < outWidth; ++x2) {
                int se;
                int sw;
                int ne;
                int nw;
                this.transformInverse(outX + x2, outY + y2, out);
                int srcX = (int)Math.floor(out[0]);
                int srcY = (int)Math.floor(out[1]);
                float xWeight = out[0] - (float)srcX;
                float yWeight = out[1] - (float)srcY;
                if (srcX >= 0 && srcX < srcWidth1 && srcY >= 0 && srcY < srcHeight1) {
                    int i2 = srcWidth * srcY + srcX;
                    nw = inPixels[i2];
                    ne = inPixels[i2 + 1];
                    sw = inPixels[i2 + srcWidth];
                    se = inPixels[i2 + srcWidth + 1];
                } else {
                    nw = this.getPixel(inPixels, srcX, srcY, srcWidth, srcHeight);
                    ne = this.getPixel(inPixels, srcX + 1, srcY, srcWidth, srcHeight);
                    sw = this.getPixel(inPixels, srcX, srcY + 1, srcWidth, srcHeight);
                    se = this.getPixel(inPixels, srcX + 1, srcY + 1, srcWidth, srcHeight);
                }
                int rgb = ImageMath.bilinearInterpolate(xWeight, yWeight, nw, ne, sw, se);
                int r2 = rgb >> 16 & 0xFF;
                int g2 = rgb >> 8 & 0xFF;
                int b2 = rgb & 0xFF;
                float shade = out[2];
                r2 = (int)((float)r2 * shade);
                g2 = (int)((float)g2 * shade);
                b2 = (int)((float)b2 * shade);
                rgb = rgb & 0xFF000000 | r2 << 16 | g2 << 8 | b2;
                outPixels[x2] = out[3] != 0.0f ? PixelUtils.combinePixels(rgb, inPixels[srcWidth * y2 + x2], 1) : rgb;
            }
            this.setRGB(dst, 0, y2, this.transformedSpace.width, 1, outPixels);
        }
        return dst;
    }

    private final int getPixel(int[] pixels, int x2, int y2, int width, int height) {
        if (x2 < 0 || x2 >= width || y2 < 0 || y2 >= height) {
            switch (this.edgeAction) {
                default: {
                    return 0;
                }
                case 2: {
                    return pixels[ImageMath.mod(y2, height) * width + ImageMath.mod(x2, width)];
                }
                case 1: 
            }
            return pixels[ImageMath.clamp(y2, 0, height - 1) * width + ImageMath.clamp(x2, 0, width - 1)];
        }
        return pixels[y2 * width + x2];
    }

    protected void transformInverse(int x2, int y2, float[] out) {
        boolean offpage;
        float t2 = this.transition;
        float px = x2;
        float py = y2;
        float s2 = (float)Math.sin(this.angle);
        float c2 = (float)Math.cos(this.angle);
        float tx = t2 * this.width;
        tx = t2 * (float)Math.sqrt(this.width * this.width + this.height * this.height);
        float xoffset = c2 < 0.0f ? this.width : 0.0f;
        float yoffset = s2 < 0.0f ? this.height : 0.0f;
        float qx = (px -= xoffset) * c2 + (py -= yoffset) * s2;
        float qy = -px * s2 + py * c2;
        boolean outside = qx < tx;
        boolean unfolded = qx > tx * 2.0f;
        boolean oncurl = !outside && !unfolded;
        qx = qx > tx * 2.0f ? qx : 2.0f * tx - qx;
        px = qx * c2 - qy * s2;
        py = qx * s2 + qy * c2;
        boolean bl = offpage = (px += xoffset) < 0.0f || (py += yoffset) < 0.0f || px >= this.width || py >= this.height;
        if (offpage && oncurl) {
            px = x2;
            py = y2;
        }
        float shade = !offpage && oncurl ? 1.9f * (1.0f - (float)Math.cos(Math.exp((qx - tx) / this.radius))) : 0.0f;
        out[2] = 1.0f - shade;
        if (outside) {
            out[1] = -1.0f;
            out[0] = -1.0f;
        } else {
            out[0] = px;
            out[1] = py;
        }
        out[3] = !offpage && oncurl ? 1.0f : 0.0f;
    }

    public String toString() {
        return "Distort/Curl...";
    }

    static class Sampler {
        private int edgeAction;
        private int width;
        private int height;
        private int[] inPixels;

        public Sampler(BufferedImage image) {
            int width = image.getWidth();
            int height = image.getHeight();
            int type = image.getType();
            this.inPixels = ImageUtils.getRGB(image, 0, 0, width, height, null);
        }

        public int sample(float x2, float y2) {
            int se;
            int sw;
            int ne;
            int nw;
            int srcX = (int)Math.floor(x2);
            int srcY = (int)Math.floor(y2);
            float xWeight = x2 - (float)srcX;
            float yWeight = y2 - (float)srcY;
            if (srcX >= 0 && srcX < this.width - 1 && srcY >= 0 && srcY < this.height - 1) {
                int i2 = this.width * srcY + srcX;
                nw = this.inPixels[i2];
                ne = this.inPixels[i2 + 1];
                sw = this.inPixels[i2 + this.width];
                se = this.inPixels[i2 + this.width + 1];
            } else {
                nw = this.getPixel(this.inPixels, srcX, srcY, this.width, this.height);
                ne = this.getPixel(this.inPixels, srcX + 1, srcY, this.width, this.height);
                sw = this.getPixel(this.inPixels, srcX, srcY + 1, this.width, this.height);
                se = this.getPixel(this.inPixels, srcX + 1, srcY + 1, this.width, this.height);
            }
            return ImageMath.bilinearInterpolate(xWeight, yWeight, nw, ne, sw, se);
        }

        private final int getPixel(int[] pixels, int x2, int y2, int width, int height) {
            if (x2 < 0 || x2 >= width || y2 < 0 || y2 >= height) {
                switch (this.edgeAction) {
                    default: {
                        return 0;
                    }
                    case 2: {
                        return pixels[ImageMath.mod(y2, height) * width + ImageMath.mod(x2, width)];
                    }
                    case 1: 
                }
                return pixels[ImageMath.clamp(y2, 0, height - 1) * width + ImageMath.clamp(x2, 0, width - 1)];
            }
            return pixels[y2 * width + x2];
        }
    }
}

