/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.SimpleGranularity;
import com.dlsc.flexgantt.swing.timeline.AbstractTimelineControlPanel;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.SimpleGranularityDatelineModel;
import com.dlsc.flexgantt.swing.timeline.SimpleGranularityListCellRenderer;
import com.dlsc.flexgantt.swing.timeline.TimeGranularityListCellRenderer;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class SimpleGranularityTimelineControlPanel
extends AbstractTimelineControlPanel<SimpleGranularity> {
    private static final Logger LOGGER = Logger.getLogger(SimpleGranularityTimelineControlPanel.class.getName());

    public SimpleGranularityTimelineControlPanel(Timeline timeline, boolean showGranularity) {
        super(timeline, showGranularity);
        this.getGranularityBox().setRenderer(new TimeGranularityListCellRenderer());
        this.getGranularityBox().setRenderer(new SimpleGranularityListCellRenderer());
        this.updateControlPanel();
    }

    public SimpleGranularityTimelineControlPanel(Timeline timeline) {
        this(timeline, true);
    }

    @Override
    public void updateControlPanel() {
        Dateline dateline = this.getTimeline().getDateline();
        IDatelineModel model = dateline.getModel();
        if (model instanceof SimpleGranularityDatelineModel) {
            SimpleGranularityDatelineModel sgModel = (SimpleGranularityDatelineModel)dateline.getModel();
            this.setGranularity(sgModel.getGranularity());
            this.setTimeSpan(this.getTimeline().getDateline().getTimeSpan());
        }
    }

    @Override
    protected void setTimeSpan(ITimeSpan span) {
        this.getStartTimeModel().setValue(span.getStartTime());
        this.getEndTimeModel().setValue(span.getEndTime());
    }

    @Override
    public ITimeSpan getTimeSpan() {
        Long from = (Long)this.getStartTimeModel().getValue();
        Long to = (Long)this.getEndTimeModel().getValue();
        return new TimeSpan(from, to);
    }

    @Override
    public boolean isValidSettings() {
        Long from = (Long)this.getStartTimeModel().getValue();
        Long to = (Long)this.getEndTimeModel().getValue();
        return from <= to;
    }

    @Override
    protected SpinnerModel createStartTimeModel() {
        return new SpinnerNumberModel((Number)0L, Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE), (Number)1L);
    }

    @Override
    protected SpinnerModel createEndTimeModel() {
        return new SpinnerNumberModel((Number)0L, Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE), (Number)1L);
    }

    @Override
    protected ComboBoxModel createGranularityModel() {
        return new DefaultComboBoxModel<SimpleGranularity>(SimpleGranularity.values());
    }

    @Override
    public void applySettings() {
        SimpleGranularity sg = (SimpleGranularity)this.getGranularityBox().getSelectedItem();
        SimpleGranularityDatelineModel model = (SimpleGranularityDatelineModel)this.getTimeline().getDateline().getModel();
        try {
            model.setTimeSpan(this.getTimeSpan());
            model.setGranularity(sg);
        }
        catch (DatelineModelException ex) {
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Messages.getString("SimpleGranularityTimelineControlPanel.UNABLE_TO_FULFILL_REQUEST"), Messages.getString("SimpleGranularityTimelineControlPanel.ERROR_DIALOG_TITLE"), 0);
            LOGGER.throwing("TimeGranularityTimelineControlpanel", "actionPerformed", ex);
        }
    }

    public static void openDialog(Component comp, Timeline timeline) {
        if (comp == null) {
            throw new IllegalArgumentException("parent component can not be NULL");
        }
        if (timeline == null) {
            throw new IllegalArgumentException("timeline can not be NULL");
        }
        SimpleGranularityTimelineControlPanel panel = new SimpleGranularityTimelineControlPanel(timeline);
        panel.setBorder(new EmptyBorder(20, 20, 20, 20));
        JDialog dialog = null;
        Window window = SwingUtilities.getWindowAncestor(comp);
        if (window instanceof Frame) {
            dialog = new JDialog((Frame)window, Messages.getString("SimpleGranularityTimelineControlPanel.DIALOG_TITLE"), true);
        } else if (window instanceof Dialog) {
            dialog = new JDialog((Dialog)window, Messages.getString("SimpleGranularityTimelineControlPanel.DIALOG_TITLE"), true);
        }
        if (dialog != null) {
            dialog.add("Center", panel);
            dialog.pack();
            dialog.setResizable(false);
            dialog.setLocationRelativeTo(comp);
            dialog.setVisible(true);
        }
    }
}

