/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class MinorDateFormat
extends SimpleDateFormat {
    private TimeGranularity granularity;
    private String[] tinyDays;
    private String[] tinyMonths;
    private DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();

    public MinorDateFormat(String pattern, TimeGranularity granularity) {
        super(pattern);
        int i2;
        if (granularity == null) {
            throw new IllegalArgumentException("granularity can not be NULL");
        }
        this.granularity = granularity;
        this.tinyMonths = this.dateFormatSymbols.getShortMonths();
        for (i2 = 0; i2 < this.tinyMonths.length; ++i2) {
            if (this.tinyMonths[i2].length() <= 0) continue;
            this.tinyMonths[i2] = this.tinyMonths[i2].substring(0, 1);
        }
        this.tinyDays = this.dateFormatSymbols.getShortWeekdays();
        for (i2 = 0; i2 < this.tinyDays.length; ++i2) {
            if (this.tinyDays[i2].length() <= 0) continue;
            this.tinyDays[i2] = this.tinyDays[i2].substring(0, 1);
        }
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        if (date == null) {
            throw new IllegalArgumentException("date can not be NULL");
        }
        Calendar c2 = Calendar.getInstance(this.getTimeZone());
        c2.setTime(date);
        switch (this.granularity) {
            case MONTH_TINY: {
                return toAppendTo.append(this.tinyMonths[c2.get(2)]);
            }
            case DAY_TINY: {
                return toAppendTo.append(this.tinyDays[c2.get(7)]);
            }
        }
        return super.format(date, toAppendTo, pos);
    }
}

