/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.print;

import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IDatelineModelListener;
import com.dlsc.flexgantt.swing.print.IPrintManager;
import com.dlsc.flexgantt.swing.print.PreviewPaperPanel;
import com.dlsc.flexgantt.swing.print.PrintContext;
import com.dlsc.flexgantt.swing.print.PrintGanttChart;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class PreviewDialog
extends JDialog
implements IDatelineModelListener,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(PreviewDialog.class.getName());
    private int gap = 10;
    private boolean canceled;
    private boolean showMargins = true;
    private List<PreviewPaperPanel> paperPanelList;
    private PrintGanttChart printGanttChart;
    private JScrollPane scrollPane;
    private BusyGlassPane busyPane = new BusyGlassPane();
    private int horizontalPages = 1;
    private int verticalPages = 1;
    private double scale = 0.5;
    private boolean fillPage;
    private boolean autoFitPages = true;
    private IPrintManager printManager;
    private JButton okButton;
    private JButton cancelButton;

    public PreviewDialog(Frame owner, IPrintManager printManager) {
        super(owner, PreviewDialog.createTitle(printManager), true);
        this.initDialog(printManager);
    }

    public PreviewDialog(Dialog owner, IPrintManager printManager) {
        super(owner, PreviewDialog.createTitle(printManager), true);
        this.initDialog(printManager);
    }

    private static String createTitle(IPrintManager manager) {
        return Messages.getString("PreviewDialog.TITLE") + " (" + manager.getPrinterJob().getPrintService().getName() + ")";
    }

    public PrintGanttChart getPrintGanttChart() {
        return this.printGanttChart;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    private void initDialog(IPrintManager printManager) {
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.getRootPane().putClientProperty("apple.awt.documentModalSheet", Boolean.TRUE);
        this.printManager = printManager;
        this.printGanttChart = printManager.getPrintGanttChart();
        this.printGanttChart.getDatelineModel().addDatelineModelListener(this);
        this.printGanttChart.getDateline().addPropertyChangeListener(this);
        this.scrollPane = this.createScrollPane();
        this.setGlassPane(this.busyPane);
        this.setLayout(new BorderLayout());
        JPanel buttonPanel = this.createButtonPanel();
        JPanel sidePanel = this.createSidePanel();
        this.add((Component)sidePanel, "West");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)buttonPanel, "South");
        this.pack();
        this.zoomFit();
        this.center();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                PreviewDialog.this.canceled = true;
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                if (PreviewDialog.this.isAutoFitPages()) {
                    PreviewDialog.this.zoomFit();
                }
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        ActionListener escListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreviewDialog.this.cancelButton.doClick();
            }
        };
        this.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private JScrollPane createScrollPane() {
        JPanel content = this.createContent();
        JScrollPane scroll = new JScrollPane(content);
        scroll.setAutoscrolls(true);
        scroll.setViewportBorder(BorderFactory.createEmptyBorder());
        scroll.setBorder(BorderFactory.createEmptyBorder());
        scroll.getViewport().setScrollMode(1);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        scroll.getVerticalScrollBar().setBlockIncrement(100);
        scroll.getHorizontalScrollBar().setUnitIncrement(10);
        scroll.getHorizontalScrollBar().setBlockIncrement(100);
        return scroll;
    }

    private JPanel createContent() {
        JPanel panel = new JPanel();
        GridLayout layout = new GridLayout(this.verticalPages, this.horizontalPages);
        layout.setHgap(0);
        layout.setVgap(0);
        panel.setLayout(layout);
        this.paperPanelList = new ArrayList<PreviewPaperPanel>();
        int page = 0;
        for (int row = 0; row < this.verticalPages; ++row) {
            for (int col = 0; col < this.horizontalPages; ++col) {
                PaperPanelContainer ppc = new PaperPanelContainer(page + 1);
                GridBagLayout gbl = new GridBagLayout();
                ppc.setLayout(gbl);
                ppc.setBackground(Color.GRAY);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.anchor = 10;
                gbc.fill = 0;
                gbc.insets = new Insets(this.gap, this.gap, this.gap, this.gap);
                PreviewPaperPanel previewPaperPanel = new PreviewPaperPanel(this, page);
                this.paperPanelList.add(previewPaperPanel);
                ppc.add((Component)previewPaperPanel, gbc);
                panel.add(ppc);
                ++page;
            }
        }
        JPanel content = new JPanel();
        content.setBackground(Color.GRAY);
        GridBagLayout gbl = new GridBagLayout();
        content.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 10;
        content.add((Component)panel, gbc);
        return content;
    }

    private void invalidatePages() {
        for (PreviewPaperPanel p2 : this.paperPanelList) {
            p2.invalidate();
        }
    }

    private JPanel createPagesPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(this.createTitledBorder(Messages.getString("PreviewDialog.PAGES_TITLE")));
        panel.setLayout(new GridBagLayout());
        JLabel widthPageLabel = new JLabel(Messages.getString("PreviewDialog.PAGES_WIDE"));
        JLabel heightPageLabel = new JLabel(Messages.getString("PreviewDialog.PAGES_HIGH"));
        Integer[] pages = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        final JComboBox<Integer> widthField = new JComboBox<Integer>(pages);
        final JComboBox<Integer> heightField = new JComboBox<Integer>(pages);
        widthField.setSelectedItem(this.horizontalPages);
        heightField.setSelectedItem(this.verticalPages);
        widthField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Integer width = (Integer)widthField.getSelectedItem();
                PreviewDialog.this.setHorizontalPages(width);
            }
        });
        heightField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Integer height = (Integer)heightField.getSelectedItem();
                PreviewDialog.this.setVerticalPages(height);
            }
        });
        final JCheckBox margins = new JCheckBox(Messages.getString("PreviewDialog.SHOW_MARGINS"), this.showMargins);
        margins.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreviewDialog.this.setShowMargins(margins.isSelected());
                PreviewDialog.this.scrollPane.repaint();
            }
        });
        final JCheckBox fill = new JCheckBox(Messages.getString("PreviewDialog.FILL_PAGE"), this.fillPage);
        fill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreviewDialog.this.setFillPage(fill.isSelected());
                PreviewDialog.this.scrollPane.repaint();
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.fill = 1;
        panel.add(widthField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.fill = 1;
        panel.add((Component)widthPageLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.fill = 1;
        panel.add(heightField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.fill = 1;
        panel.add((Component)heightPageLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        panel.add((Component)margins, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        panel.add((Component)fill, gbc);
        return panel;
    }

    private JPanel createNavigationPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(this.createTitledBorder(Messages.getString("PreviewDialog.NAVIGATE_TITLE")));
        final JButton zoomIn = new JButton(Messages.getString("PreviewDialog.ZOOM_IN"));
        zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreviewDialog.this.zoomIn();
            }
        });
        final JButton zoomOut = new JButton(Messages.getString("PreviewDialog.ZOOM_OUT"));
        zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreviewDialog.this.zoomOut();
            }
        });
        final JButton fit = new JButton(Messages.getString("PreviewDialog.FIT_PAGES_BUTTON"));
        fit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreviewDialog.this.zoomFit();
            }
        });
        final JCheckBox autoFit = new JCheckBox(Messages.getString("PreviewDialog.AUTO_FIT_CHECKBOX_LABEL"), this.autoFitPages);
        autoFit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                zoomIn.setEnabled(!autoFit.isSelected());
                zoomOut.setEnabled(!autoFit.isSelected());
                fit.setEnabled(!autoFit.isSelected());
                PreviewDialog.this.setAutoFitPages(autoFit.isSelected());
                if (autoFit.isSelected()) {
                    PreviewDialog.this.zoomFit();
                }
            }
        });
        zoomIn.setEnabled(!this.autoFitPages);
        zoomOut.setEnabled(!this.autoFitPages);
        fit.setEnabled(!this.autoFitPages);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 11;
        panel.add((Component)zoomIn, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 11;
        panel.add((Component)zoomOut, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 11;
        panel.add((Component)fit, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 11;
        panel.add((Component)autoFit, gbc);
        return panel;
    }

    private JPanel createSidePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.setLayout(new GridBagLayout());
        JPanel pagesPanel = this.createPagesPanel();
        JPanel navigationPanel = this.createNavigationPanel();
        JPanel timelinePanel = this.createTimelinePanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.gridwidth = 2;
        panel.add((Component)timelinePanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        panel.add((Component)navigationPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 1;
        panel.add((Component)pagesPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.gridwidth = 2;
        gbc.weighty = 1.0;
        panel.add((Component)new JPanel(), gbc);
        return panel;
    }

    private JPanel createTimelinePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("Center", this.printManager.createTimelineControl(this.printGanttChart.getTimeline()));
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        if (System.getProperty("os.name").startsWith("Mac")) {
            panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        } else {
            panel.setBorder(new EmptyBorder(10, 5, 10, 5));
        }
        panel.setLayout(new GridBagLayout());
        JButton printerSetupButton = new JButton(Messages.getString("PreviewDialog.PRINTER_SETUP_BUTTON"));
        printerSetupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PrinterJob printerJob = PreviewDialog.this.printManager.getPrinterJob();
                if (printerJob.printDialog()) {
                    PreviewDialog.this.setTitle(PreviewDialog.createTitle(PreviewDialog.this.printManager));
                    PageFormat pf2 = printerJob.defaultPage(PreviewDialog.this.printManager.getPageFormat());
                    PreviewDialog.this.printManager.setPageFormat(pf2);
                    PreviewDialog.this.invalidatePages();
                    PreviewDialog.this.zoomFit();
                    PreviewDialog.this.scrollPane.invalidate();
                    PreviewDialog.this.scrollPane.validate();
                    PreviewDialog.this.scrollPane.repaint();
                }
            }
        });
        JButton pagesSetupButton = new JButton(Messages.getString("PreviewDialog.PAGE_SETUP_BUTTON"));
        pagesSetupButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    PreviewDialog.this.busyPane.setVisible(true);
                    PrinterJob printerJob = PreviewDialog.this.printManager.getPrinterJob();
                    PageFormat pf = printerJob.pageDialog(PreviewDialog.this.printManager.getPageFormat());
                    if (pf != null) {
                        PreviewDialog.this.printManager.setPageFormat(pf);
                        PreviewDialog.this.invalidatePages();
                        PreviewDialog.this.zoomFit();
                        PreviewDialog.this.scrollPane.invalidate();
                        PreviewDialog.this.scrollPane.validate();
                        PreviewDialog.this.scrollPane.repaint();
                    }
                }
                finally {
                    PreviewDialog.this.busyPane.setVisible(false);
                }
            }
        });
        this.okButton = new JButton(Messages.getString("PreviewDialog.OK_BUTTON"));
        this.cancelButton = new JButton(Messages.getString("PreviewDialog.CANCEL_BUTTON"));
        panel.add(this.cancelButton);
        panel.add(this.okButton);
        panel.add(new JLabel("   "));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreviewDialog.this.canceled = false;
                PreviewDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreviewDialog.this.canceled = true;
                PreviewDialog.this.setVisible(false);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 0, 0, 5);
        panel.add((Component)printerSetupButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        panel.add((Component)pagesSetupButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        panel.add((Component)this.okButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.cancelButton, gbc);
        return panel;
    }

    public void center() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - this.getWidth()) / 2, (dim.height - this.getHeight()) / 2);
    }

    public void zoomIn() {
        this.setScale(this.scale * 1.5);
    }

    public void zoomOut() {
        this.setScale(this.scale / 1.5);
    }

    public void zoomFit() {
        PreviewPaperPanel pp = this.paperPanelList.get(0);
        Dimension ds = pp.getPreferredSize(1.0);
        int widthRequired = this.horizontalPages * ds.width;
        int heightRequired = this.verticalPages * ds.height;
        int widthAvailable = this.scrollPane.getVisibleRect().width - this.horizontalPages * 2 * this.gap - 20;
        int heightAvailable = this.scrollPane.getVisibleRect().height - this.verticalPages * 2 * this.gap - 20;
        double sfWidth = (double)widthAvailable / (double)widthRequired;
        double sfHeight = (double)heightAvailable / (double)heightRequired;
        double sf = Math.min(sfWidth, sfHeight);
        this.setScale(sf);
    }

    public boolean isShowMargins() {
        return this.showMargins;
    }

    public void setShowMargins(boolean show) {
        this.showMargins = show;
    }

    public boolean isCancelled() {
        return this.canceled;
    }

    public int getHorizontalPages() {
        return this.horizontalPages;
    }

    public void setHorizontalPages(int pages) {
        this.horizontalPages = pages;
        this.scrollPane.setViewportView(this.createContent());
        if (this.autoFitPages) {
            this.zoomFit();
        }
    }

    public int getVerticalPages() {
        return this.verticalPages;
    }

    public void setVerticalPages(int pages) {
        this.verticalPages = pages;
        this.scrollPane.setViewportView(this.createContent());
        if (this.autoFitPages) {
            this.zoomFit();
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double s2) {
        if (s2 <= 0.0) {
            throw new IllegalArgumentException("scale factor can not be smaller or equal to 0");
        }
        LOGGER.fine("scale = " + s2);
        try {
            this.busyPane.setVisible(true);
            this.scale = s2;
            this.invalidatePages();
            this.validate();
        }
        finally {
            this.busyPane.setVisible(false);
        }
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
        this.invalidatePages();
        this.validate();
    }

    public boolean isFillPage() {
        return this.fillPage;
    }

    public void setFillPage(boolean fill) {
        this.fillPage = fill;
    }

    public boolean isAutoFitPages() {
        return this.autoFitPages;
    }

    public void setAutoFitPages(boolean fit) {
        this.autoFitPages = fit;
    }

    public IPrintManager getPrintManager() {
        return this.printManager;
    }

    @Override
    public void datelineModelWillChange(DatelineModelEvent evt) {
    }

    @Override
    public void datelineModelChanged(DatelineModelEvent evt) {
        if (evt.getId().equals((Object)DatelineModelEvent.ID.TIME_SPAN_CHANGED)) {
            PrintContext ctx = this.printManager.getPrintContext();
            ctx.setTimeSpan(this.printGanttChart.getDatelineModel().getTimeSpan());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.printGanttChart.getDateline()) && evt.getPropertyName().equals("datelineModel")) {
            IDatelineModel oldModel = (IDatelineModel)evt.getOldValue();
            IDatelineModel newModel = (IDatelineModel)evt.getNewValue();
            oldModel.removeDatelineModelListener(this);
            newModel.addDatelineModelListener(this);
        }
    }

    protected Border createTitledBorder(String title) {
        Border b2 = UIManager.getBorder("TitledBorder.aquaVariant");
        if (b2 == null) {
            TitledBorder border = new TitledBorder(title);
            return border;
        }
        TitledBorder border = new TitledBorder(b2, title);
        return border;
    }

    private class PaperPanelContainer
    extends JPanel {
        private Font font = new Font("courier", 0, 8);
        private int page;

        protected PaperPanelContainer(int page) {
            this.setFont(this.font);
            this.page = page;
        }

        @Override
        protected void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            g2.setColor(Color.BLACK);
            int count = this.getComponentCount();
            for (int i2 = 0; i2 < count; ++i2) {
                Component comp = this.getComponent(i2);
                Rectangle bounds = comp.getBounds();
                g2.fillRect(bounds.x + 2, bounds.y + 2, bounds.width, bounds.height);
                String str = Integer.toString(this.page);
                FontMetrics fm = g2.getFontMetrics();
                int ascent = fm.getAscent();
                int length = fm.stringWidth(str);
                g2.drawString(str, bounds.x + bounds.width - length, bounds.y + bounds.height + ascent + 2);
            }
        }
    }

    private class BusyGlassPane
    extends JPanel {
        protected BusyGlassPane() {
            this.setOpaque(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.setVisible(false);
        }
    }
}

