/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.timeline;

import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.IEditTimelineObjectPolicy;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectRenderer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JPanel;

public class DefaultTimelineObjectRenderer
extends JPanel
implements ITimelineObjectRenderer {
    private int barHeight = 12;
    private int diamondSize = 5;
    private final Insets insets = new Insets(0, 0, 0, 0);
    private boolean selected;
    private boolean focus;
    private boolean event;
    private boolean parent;
    private Object node;
    private Object timelineObject;
    private IGanttChartModel model;
    private TimelineObjectLayer timelineObjectLayer;
    private boolean highlighted;
    private Color resizeHandleColor = new Color(76, 87, 109);
    private Color activityLineColor = new Color(69, 94, 138);
    private Color activityFillColor1 = new Color(203, 218, 245);
    private Color activityFillColor2 = new Color(153, 183, 236);
    private Color eventLineColor = new Color(69, 94, 138);
    private Color eventFillColor1 = new Color(203, 218, 245);
    private Color eventFillColor2 = new Color(153, 183, 236);
    private Color parentLineColor = new Color(255, 205, 155).darker();
    private Color parentFillColor1 = new Color(255, 235, 215);
    private Color parentFillColor2 = new Color(255, 205, 155);
    private Color focusLineColor = new Color(69, 94, 138);
    private Color focusFillColor1 = new Color(203, 218, 245);
    private Color focusFillColor2 = new Color(153, 183, 236);
    private final Color pastLineColor = Color.GRAY;
    private Color pastFillColor1 = Color.WHITE;
    private Color pastFillColor2 = Color.LIGHT_GRAY;
    private Color selectionLineColor = new Color(215, 148, 148).darker();
    private Color selectionFillColor1 = new Color(250, 235, 235);
    private Color selectionFillColor2 = new Color(235, 180, 180);
    private Color highlightLineColor = new Color(215, 215, 148).darker();
    private Color highlightFillColor1 = new Color(250, 250, 235);
    private Color highlightFillColor2 = new Color(235, 235, 180);
    private boolean roundedCorners = true;
    private boolean glossy = true;
    private boolean visualizingPastTime;
    private TimelineObjectPath timelineObjectPath;

    public DefaultTimelineObjectRenderer() {
        this.setOpaque(false);
        this.setLayout(null);
    }

    @Override
    public Component getTimelineObjectRendererComponent(TimelineObjectLayer layer, TimelineObjectPath path, boolean selected, boolean hasFocus, boolean highlighted, int row) {
        this.timelineObjectLayer = layer;
        this.timelineObjectPath = path;
        this.node = path.getLastPathComponent();
        this.model = layer.getModel();
        this.timelineObject = path.getTimelineObject();
        this.event = this.model.getTimeSpan(this.timelineObject).isEvent();
        this.selected = selected;
        this.focus = hasFocus;
        this.highlighted = highlighted;
        this.parent = this.model.isParentTimelineObject(this.timelineObject);
        this.setEnabled(layer.getLayerContainer().isEnabled());
        return this;
    }

    @Override
    public Insets getTimelineObjectRendererInsets(int x2, int y2, int width, int height) {
        int bh = Math.min(this.barHeight, height);
        if (this.event) {
            this.insets.top = (height - 2 * this.diamondSize) / 2;
            this.insets.left = -this.diamondSize - 1;
            this.insets.bottom = (height - 2 * this.diamondSize) / 2;
            this.insets.right = -this.diamondSize;
        } else {
            this.insets.left = 0;
            this.insets.right = 0;
            this.insets.top = (height - bh) / 2;
            this.insets.bottom = (height - bh) / 2;
        }
        return this.insets;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        long timeNow = this.timelineObjectLayer.getGanttChart().getEventline().getTimeNow();
        int x2 = this.timelineObjectLayer.getGanttChart().getDateline().getTimeLocation(timeNow);
        if (this.event) {
            this.paintEvent(g2);
            if (this.isVisualizingPastTime() && x2 > this.getBounds().x) {
                Shape clip = g2.getClip();
                g2.clipRect(0, 0, x2 - this.getBounds().x, this.getHeight());
                Color fill1 = this.getEventFillColor1();
                Color fill2 = this.getEventFillColor2();
                this.setEventLineColor(this.pastLineColor);
                this.setEventFillColor1(this.pastFillColor1);
                this.setEventFillColor2(this.pastFillColor2);
                this.paintEvent(g2);
                this.setEventFillColor1(fill1);
                this.setEventFillColor2(fill2);
                g2.setClip(clip);
            }
        } else if (this.parent) {
            this.paintParent(g2);
        } else {
            this.paintActivityContent(g2);
            if (this.isVisualizingPastTime() && x2 > this.getBounds().x) {
                Shape clip = g2.getClip();
                g2.clipRect(0, 0, x2 - this.getBounds().x, this.getHeight());
                Color fill1 = this.getActivityFillColor1();
                Color fill2 = this.getActivityFillColor2();
                this.setActivityLineColor(this.pastLineColor);
                this.setActivityFillColor1(this.pastFillColor1);
                this.setActivityFillColor2(this.pastFillColor2);
                this.paintActivityContent(g2);
                this.setActivityFillColor1(fill1);
                this.setActivityFillColor2(fill2);
                g2.setClip(clip);
            }
            this.paintActivityBorder(g2);
            if (this.focus) {
                this.paintActivityFocus(g2);
            }
        }
    }

    protected void paintParent(Graphics g2) {
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        int[] xx = new int[]{0, w2 - 1, w2 - 1, w2 - 1 - 5, 5, 0, 0};
        int[] yy = new int[]{0, 0, h2 - 1, h2 - 1 - 5, h2 - 1 - 5, h2 - 1, 0};
        Graphics2D g2d = (Graphics2D)g2;
        if (this.highlighted) {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.highlightFillColor1, 0.0f, h2 / 2, this.highlightFillColor2));
        } else if (this.selected) {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.selectionFillColor1, 0.0f, h2 / 2, this.selectionFillColor2));
        } else {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.parentFillColor1, 0.0f, h2 / 2, this.parentFillColor2));
        }
        g2d.fillPolygon(xx, yy, 7);
        if (this.highlighted) {
            g2d.setColor(this.highlightLineColor);
        } else if (this.focus) {
            g2d.setColor(this.focusLineColor);
        } else if (this.selected) {
            g2d.setColor(this.selectionLineColor);
        } else {
            g2d.setColor(this.parentLineColor);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawPolygon(xx, yy, 7);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    protected void paintActivityFocus(Graphics g2) {
        g2.setColor(this.resizeHandleColor);
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        if (this.isDurationChangeable()) {
            int x2;
            int i2;
            for (i2 = 0; i2 < 3; ++i2) {
                x2 = w2 - 10 + i2 * 2;
                g2.drawLine(x2, 4, x2, h2 - 3);
            }
            if (this.isStartTimeChangeable()) {
                for (i2 = 0; i2 < 3; ++i2) {
                    x2 = 6 + i2 * 2;
                    g2.drawLine(x2, 4, x2, h2 - 3);
                }
            }
        }
    }

    protected void paintEvent(Graphics g2) {
        int w2 = this.getWidth() - 1;
        int h2 = this.getHeight() - 1;
        int mx = w2 / 2;
        int my = h2 / 2;
        int[] xx = new int[]{mx - this.diamondSize, mx, mx + this.diamondSize, mx, mx - this.diamondSize};
        int[] yy = new int[]{my, my - this.diamondSize, my, my + this.diamondSize, my};
        Graphics2D g2d = (Graphics2D)g2;
        if (this.highlighted) {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.highlightFillColor1, 0.0f, h2 / 2, this.highlightFillColor2));
        } else if (this.selected) {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.selectionFillColor1, 0.0f, h2 / 2, this.selectionFillColor2));
        } else {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.eventFillColor1, 0.0f, h2 / 2, this.eventFillColor2));
        }
        g2d.fillPolygon(xx, yy, 5);
        if (this.highlighted) {
            g2d.setColor(this.highlightLineColor);
        } else if (this.focus) {
            g2d.setColor(this.focusLineColor);
        } else if (this.selected) {
            g2d.setColor(this.selectionLineColor);
        } else {
            g2d.setColor(this.eventLineColor);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawPolygon(xx, yy, 5);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    protected void paintActivityContent(Graphics g2) {
        int w2 = this.getWidth() - 1;
        int h2 = this.getHeight() - 1;
        Graphics2D g2d = (Graphics2D)g2;
        if (this.highlighted) {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.highlightFillColor1, 0.0f, h2 / 2, this.highlightFillColor2));
        } else if (this.selected) {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.selectionFillColor1, 0.0f, h2 / 2, this.selectionFillColor2));
        } else {
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.activityFillColor1, 0.0f, h2 / 2, this.activityFillColor2));
        }
        if (this.roundedCorners) {
            g2d.fillRoundRect(1, 2, w2, h2 - 1, 12, 12);
            if (this.glossy) {
                g2d.setColor(new Color(255, 255, 255, 100));
                g2d.fillRoundRect(1, 2, w2, h2 / 2 - 1, 12, 12);
            }
        } else {
            g2d.fillRect(1, 2, w2 - 1, h2 - 2);
            if (this.glossy) {
                g2d.setColor(new Color(255, 255, 255, 100));
                g2d.fillRect(1, 2, w2 - 1, h2 / 2 - 2);
            }
        }
    }

    protected void paintActivityBorder(Graphics g2) {
        int w2 = this.getWidth() - 1;
        int h2 = this.getHeight() - 1;
        Graphics2D g2d = (Graphics2D)g2;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.highlighted) {
            g2d.setColor(this.highlightLineColor);
        } else if (this.focus) {
            g2d.setColor(this.focusLineColor);
        } else if (this.selected) {
            g2d.setColor(this.selectionLineColor);
        } else {
            g2d.setColor(this.activityLineColor);
        }
        if (this.roundedCorners) {
            g2d.drawRoundRect(1, 2, w2 - 1, h2 - 2, 12, 12);
        } else {
            g2d.drawRect(1, 2, w2 - 1, h2 - 2);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    public void setGlossy(boolean glossy) {
        this.glossy = glossy;
    }

    public boolean isGlossy() {
        return this.glossy;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public void setBarHeight(int height) {
        this.barHeight = height;
    }

    public Color getActivityFillColor1() {
        return this.activityFillColor1;
    }

    public void setActivityFillColor1(Color color) {
        this.activityFillColor1 = color;
    }

    public Color getActivityFillColor2() {
        return this.activityFillColor2;
    }

    public void setActivityFillColor2(Color color) {
        this.activityFillColor2 = color;
    }

    public Color getFocusFillColor1() {
        return this.focusFillColor1;
    }

    public void setFocusFillColor1(Color color) {
        this.focusFillColor1 = color;
    }

    public Color getFocusFillColor2() {
        return this.focusFillColor2;
    }

    public void setFocusFillColor2(Color color) {
        this.focusFillColor2 = color;
    }

    public Color getFocusLineColor() {
        return this.focusLineColor;
    }

    public void setFocusLineColor(Color color) {
        this.focusLineColor = color;
    }

    public Color getHighlightFillColor1() {
        return this.highlightFillColor1;
    }

    public void setHighlightFillColor1(Color color) {
        this.highlightFillColor1 = color;
    }

    public Color getHighlightFillColor2() {
        return this.highlightFillColor2;
    }

    public void setHighlightFillColor2(Color color) {
        this.highlightFillColor2 = color;
    }

    public Color getHighlightLineColor() {
        return this.highlightLineColor;
    }

    public void setHighlightLineColor(Color color) {
        this.highlightLineColor = color;
    }

    public Color getActivityLineColor() {
        return this.activityLineColor;
    }

    public void setActivityLineColor(Color color) {
        this.activityLineColor = color;
    }

    public Color getSelectionFillColor1() {
        return this.selectionFillColor1;
    }

    public void setSelectionFillColor1(Color color) {
        this.selectionFillColor1 = color;
    }

    public Color getSelectionFillColor2() {
        return this.selectionFillColor2;
    }

    public void setSelectionFillColor2(Color color) {
        this.selectionFillColor2 = color;
    }

    public Color getSelectionLineColor() {
        return this.selectionLineColor;
    }

    public void setSelectionLineColor(Color color) {
        this.selectionLineColor = color;
    }

    public Color getEventFillColor1() {
        return this.eventFillColor1;
    }

    public void setEventFillColor1(Color color) {
        this.eventFillColor1 = color;
    }

    public Color getEventFillColor2() {
        return this.eventFillColor2;
    }

    public void setEventFillColor2(Color color) {
        this.eventFillColor2 = color;
    }

    public void setEventLineColor(Color color) {
        this.eventLineColor = color;
    }

    public Color getEventLineColor() {
        return this.eventLineColor;
    }

    protected boolean isEvent() {
        return this.event;
    }

    public boolean isParent() {
        return this.parent;
    }

    @Override
    public boolean hasFocus() {
        return this.focus;
    }

    protected TimelineObjectLayer getTimelineObjectLayer() {
        return this.timelineObjectLayer;
    }

    protected IGanttChartModel getModel() {
        return this.model;
    }

    protected Object getNode() {
        return this.node;
    }

    protected Object getTimelineObject() {
        return this.timelineObject;
    }

    protected boolean isSelected() {
        return this.selected;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public boolean isVisualizingPastTime() {
        return this.visualizingPastTime;
    }

    public void setVisualizingPastTime(boolean b2) {
        this.visualizingPastTime = b2;
    }

    public boolean isRoundedCorners() {
        return this.roundedCorners;
    }

    public void setRoundedCorners(boolean b2) {
        this.roundedCorners = b2;
    }

    public Color getResizeHandleColor() {
        return this.resizeHandleColor;
    }

    public void setResizeHandleColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.resizeHandleColor = color;
    }

    public int getDiamondSize() {
        return this.diamondSize;
    }

    public void setDiamondSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("size must be larger than 0");
        }
        this.diamondSize = size;
    }

    public Color getParentFillColor1() {
        return this.parentFillColor1;
    }

    public void setParentFillColor1(Color color) {
        this.parentFillColor1 = color;
    }

    public Color getParentFillColor2() {
        return this.parentFillColor2;
    }

    public void setParentFillColor2(Color color) {
        this.parentFillColor2 = color;
    }

    public Color getParentLineColor() {
        return this.parentLineColor;
    }

    public void setParentLineColor(Color color) {
        this.parentLineColor = color;
    }

    public Color getPastFillColor1() {
        return this.pastFillColor1;
    }

    public void setPastFillColor1(Color color) {
        this.pastFillColor1 = color;
    }

    public Color getPastFillColor2() {
        return this.pastFillColor2;
    }

    public void setPastFillColor2(Color color) {
        this.pastFillColor2 = color;
    }

    protected boolean isStartTimeChangeable() {
        IPolicyProvider pp = this.timelineObjectLayer.getLayerPolicyProvider();
        IEditTimelineObjectPolicy ep = pp.getPolicy(IEditTimelineObjectPolicy.class);
        return ep.isStartTimeChangeable(this.timelineObjectPath, this.model);
    }

    protected boolean isDurationChangeable() {
        IPolicyProvider pp = this.timelineObjectLayer.getLayerPolicyProvider();
        IEditTimelineObjectPolicy ep = pp.getPolicy(IEditTimelineObjectPolicy.class);
        return ep.isDurationChangeable(this.timelineObjectPath, this.model);
    }

    protected TimelineObjectPath getTimelineObjectPath() {
        return this.timelineObjectPath;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(int x2, int y2, int width, int height) {
    }

    @Override
    public void repaint(long tm) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

