/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.ILabelPolicy;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.DragLayer;
import com.dlsc.flexgantt.swing.layer.system.IDragInfoRenderer;
import com.dlsc.flexgantt.swing.util.DropShadowBorder;
import com.dlsc.flexgantt.util.LabelType;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class DefaultDragInfoRenderer
extends JPanel
implements IDragInfoRenderer,
Border {
    private final JLabel titleLabel;
    private final JTextArea textArea;
    private final Insets insets = new Insets(1, 1, 1, 1);
    private DragLayer dragLayer;
    private Color lineColor = new Color(255, 235, 155).darker();
    private Color textColor = Color.BLACK;
    private Color backgroundColor1 = new Color(255, 255, 235);
    private Color backgroundColor2 = new Color(255, 255, 155);

    public DefaultDragInfoRenderer() {
        this.setOpaque(true);
        this.setBorder(new CompoundBorder(new DropShadowBorder(), this));
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.titleLabel = new JLabel("");
        this.titleLabel.setForeground(Color.BLACK);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setBorder(new CompoundBorder(new EmptyBorder(0, 5, 0, 5), new Border(){

            @Override
            public Insets getBorderInsets(Component c2) {
                return new Insets(0, 0, 1, 0);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
                String txt = DefaultDragInfoRenderer.this.titleLabel.getText();
                if (txt != null && !txt.trim().equals("")) {
                    g2.setColor(DefaultDragInfoRenderer.this.lineColor);
                    g2.drawLine(x2, y2 + height - 1, x2 + width, y2 + height - 1);
                }
            }
        }));
        this.titleLabel.setOpaque(false);
        this.add("North", this.titleLabel);
        this.textArea = new JTextArea("");
        this.textArea.setOpaque(false);
        this.textArea.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.textArea.setForeground(Color.BLACK);
        this.add("Center", this.textArea);
        this.textArea.setOpaque(false);
    }

    @Override
    public Component getDragInfoRendererComponent(DragLayer layer, TimelineObjectPath path, Object dragInfo, ITimeSpan span, int dragAction) {
        this.dragLayer = layer;
        LayerContainer lc2 = layer.getLayerContainer();
        IPolicyProvider pp = lc2.getPolicyProvider();
        ILabelPolicy lp = pp.getPolicy(ILabelPolicy.class);
        String title = lp.getLabel(path, layer.getModel(), LabelType.DRAG_INFO_TITLE);
        this.titleLabel.setText(title);
        this.titleLabel.setVisible(title != null && !title.trim().equals(""));
        this.titleLabel.setFont(layer.getLayerContainer().getFont());
        this.textArea.setFont(layer.getLayerContainer().getFont());
        this.textArea.setText(dragInfo.toString());
        return this;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2.create();
        g2d.setComposite(AlphaComposite.getInstance(3, this.dragLayer.getAlpha()));
        super.paintComponent(g2d);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        Graphics2D g2d = (Graphics2D)g2.create();
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.backgroundColor1, 0.0f, height, this.backgroundColor2));
        g2d.fillRect(x2, y2, width - 1, height - 1);
        g2d.setColor(this.lineColor);
        g2d.drawRect(x2, y2, width - 1, height - 1);
        g2d.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        return this.insets;
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public Color getBackgroundColor1() {
        return this.backgroundColor1;
    }

    public void setBackgroundColor1(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.backgroundColor1 = color;
    }

    public Color getBackgroundColor2() {
        return this.backgroundColor2;
    }

    public void setBackgroundColor2(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.backgroundColor2 = color;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.lineColor = color;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.textColor = color;
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(int x2, int y2, int width, int height) {
    }

    @Override
    public void repaint(long tm) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

