/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.layer.ICrosshairPolicy;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class CrosshairLayer
extends AbstractSystemLayer
implements MouseMotionListener,
MouseWheelListener,
MouseListener {
    private Point location = new Point(-1, -1);
    private boolean verticalLineVisible = true;
    private boolean horizontalLineVisible = true;
    private BasicStroke stroke = new BasicStroke(2.0f, 2, 1, 1.0f, null, 0.0f);
    private int circleRadius = 24;
    private Color lineColor = Color.RED;
    private Color textColor = Color.BLACK;
    private Color fillColor = Color.GREEN;

    public CrosshairLayer(LayerContainer lc2) {
        super("Crosshair", lc2);
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.layerContainer.addMouseListener(this);
            this.layerContainer.addMouseMotionListener(this);
            this.layerContainer.addMouseWheelListener(this);
        } else {
            this.layerContainer.removeMouseListener(this);
            this.layerContainer.removeMouseMotionListener(this);
            this.layerContainer.removeMouseWheelListener(this);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        this.move(e2);
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        this.move(e2);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e2) {
        this.move(e2);
    }

    private void move(MouseEvent e2) {
        if (!e2.isConsumed()) {
            this.location = e2.getPoint();
            this.repaint();
        } else {
            Point p2 = new Point(-1, -1);
            if (!this.location.equals(p2)) {
                this.location = p2;
            }
            this.repaint();
        }
    }

    @Override
    protected void paintLayer(Graphics g2) {
        super.paintLayer(g2);
        Rectangle visible = this.layerContainer.getVisibleRect();
        if (visible.contains(this.location)) {
            Graphics2D g2d = (Graphics2D)g2;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(this.lineColor);
            g2d.setStroke(this.stroke);
            if (this.isVerticalLineVisible()) {
                g2.drawLine(this.location.x, visible.y, this.location.x, this.location.y - this.circleRadius);
                g2.drawLine(this.location.x, this.location.y + this.circleRadius, this.location.x, visible.y + visible.height);
            }
            if (this.isHorizontalLineVisible()) {
                g2.drawLine(visible.x, this.location.y, this.location.x - this.circleRadius, this.location.y);
                g2.drawLine(this.location.x + this.circleRadius, this.location.y, visible.x + visible.width, this.location.y);
            }
            Composite comp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.33f));
            g2d.setColor(this.fillColor);
            g2d.fillOval(this.location.x - this.circleRadius, this.location.y - this.circleRadius, 2 * this.circleRadius, 2 * this.circleRadius);
            g2d.setComposite(comp);
            g2d.setColor(this.lineColor);
            g2d.drawOval(this.location.x - this.circleRadius, this.location.y - this.circleRadius, 2 * this.circleRadius, 2 * this.circleRadius);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            ICrosshairPolicy cp = this.getLayerPolicyProvider().getPolicy(ICrosshairPolicy.class);
            long time = this.getTimeAt(this.location.x);
            TreeTable table = this.getTreeTable();
            int row = table.getRowAt(this.location.y);
            if (row != -1) {
                String textLowerRight;
                String textUpperRight;
                String textLowerLeft;
                int textWidth;
                String textUpperLeft;
                Object node = table.getTreeTableNodes().get(row).getModelNode();
                IGanttChartModel model = this.getModel();
                ObjectBounds bounds = this.layerContainer.getObjectBoundsAt(this.location.x, this.location.y);
                TimelineObjectPath path = null;
                if (bounds != null) {
                    path = bounds.getPath();
                }
                FontMetrics fm = g2d.getFontMetrics();
                int ascent = fm.getAscent();
                g2d.setColor(this.textColor);
                if (cp.isLabelVisible(ICrosshairPolicy.LabelPosition.UPPER_LEFT) && (textUpperLeft = cp.getLabel(node, path, model, time, ICrosshairPolicy.LabelPosition.UPPER_LEFT)) != null) {
                    textWidth = fm.stringWidth(textUpperLeft);
                    g2d.drawString(textUpperLeft, this.location.x - this.circleRadius - 2 - textWidth, this.location.y - 4);
                }
                if (cp.isLabelVisible(ICrosshairPolicy.LabelPosition.LOWER_LEFT) && (textLowerLeft = cp.getLabel(node, path, model, time, ICrosshairPolicy.LabelPosition.LOWER_LEFT)) != null) {
                    textWidth = fm.stringWidth(textLowerLeft);
                    g2d.drawString(textLowerLeft, this.location.x - this.circleRadius - 2 - textWidth, this.location.y + 4 + ascent);
                }
                if (cp.isLabelVisible(ICrosshairPolicy.LabelPosition.UPPER_RIGHT) && (textUpperRight = cp.getLabel(node, path, model, time, ICrosshairPolicy.LabelPosition.UPPER_RIGHT)) != null) {
                    g2d.drawString(textUpperRight, this.location.x + this.circleRadius + 2, this.location.y - 4);
                }
                if (cp.isLabelVisible(ICrosshairPolicy.LabelPosition.LOWER_RIGHT) && (textLowerRight = cp.getLabel(node, path, model, time, ICrosshairPolicy.LabelPosition.LOWER_RIGHT)) != null) {
                    g2d.drawString(textLowerRight, this.location.x + this.circleRadius + 2, this.location.y + ascent + 4);
                }
            }
        }
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
    }

    public boolean isHorizontalLineVisible() {
        return this.horizontalLineVisible;
    }

    public void setHorizontalLineVisible(boolean visible) {
        this.horizontalLineVisible = visible;
    }

    public boolean isVerticalLineVisible() {
        return this.verticalLineVisible;
    }

    public void setVerticalLineVisible(boolean visible) {
        this.verticalLineVisible = visible;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.location = new Point(-1, -1);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    public int getCircleRadius() {
        return this.circleRadius;
    }

    public void setCircleRadius(int radius) {
        if (radius < 0) {
            throw new IllegalArgumentException("radius can not be smaller than 0 but was " + radius);
        }
        this.circleRadius = radius;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.fillColor = color;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.lineColor = color;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.textColor = color;
    }
}

