/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer;

import com.dlsc.flexgantt.model.gantt.DefaultResourceNode;
import com.dlsc.flexgantt.swing.AbstractRowHeader;
import com.dlsc.flexgantt.swing.layer.DefaultLayerContainerRowHeaderRenderer;
import com.dlsc.flexgantt.swing.layer.DefaultResourceNodeRowHeaderRenderer;
import com.dlsc.flexgantt.swing.layer.ILayerContainerRowHeaderRenderer;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.GridLayer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;

public class LayerContainerRowHeader
extends AbstractRowHeader<ILayerContainerRowHeaderRenderer> {
    private Point cursorLocation;
    private Color cursorLineColor = Color.GRAY;
    private Color cursorFillColor1 = new Color(255, 255, 235);
    private Color cursorFillColor2 = new Color(255, 255, 155);
    private int cursorSize = 5;
    private boolean cursorVisible = true;
    private LayerContainer layerContainer;

    public LayerContainerRowHeader(LayerContainer lc2) {
        super(lc2.getTreeTable());
        this.layerContainer = lc2;
        this.setName("LayerContainerRowHeader");
        GridLayer gl = lc2.getSystemLayer(GridLayer.class);
        this.setGridColor(gl.getHorizontalLineColor());
        this.setRowHeaderRenderer(Object.class, new DefaultLayerContainerRowHeaderRenderer());
        this.setRowHeaderRenderer(DefaultResourceNode.class, new DefaultResourceNodeRowHeaderRenderer());
        this.layerContainer.addMouseListener(this);
        this.layerContainer.addMouseMotionListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = new Dimension();
        dim.height = this.getTreeTable().getPreferredSize().height;
        dim.width = this.getGanttChart().getLayerContainerRowHeaderWidth();
        return dim;
    }

    public LayerContainer getLayerContainer() {
        return this.layerContainer;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        this.paintCursor(g2, this.cursorLocation);
    }

    @Override
    protected void paintUnusedRow(Graphics g2, int y2, int width, int height, int row) {
        TreeTable table = this.getTreeTable();
        g2.setColor(table.getBackground(row));
        g2.fillRect(0, y2, width, height);
    }

    protected void paintCursor(Graphics g2, Point location) {
        if (this.cursorVisible && location != null) {
            int w2 = this.getWidth();
            Graphics2D g2d = (Graphics2D)g2;
            int[] xx = new int[]{w2 - 2 - this.cursorSize - this.cursorSize, w2 - 2 - this.cursorSize, w2 - 2, w2 - 2 - this.cursorSize, w2 - 2 - this.cursorSize - this.cursorSize, w2 - 2 - this.cursorSize - this.cursorSize};
            int[] yy = new int[]{location.y - this.cursorSize, location.y - this.cursorSize, location.y, location.y + this.cursorSize, location.y + this.cursorSize, location.y - this.cursorSize};
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.cursorFillColor1, 0.0f, this.cursorSize, this.cursorFillColor2));
            g2d.fillPolygon(xx, yy, 6);
            g2d.setColor(this.cursorLineColor);
            g2d.drawPolygon(xx, yy, 6);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        super.mouseMoved(e2);
        if (e2.getSource().equals(this.layerContainer)) {
            this.cursorLocation = e2.getPoint();
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        super.mouseExited(e2);
        if (e2.getSource().equals(this.layerContainer)) {
            this.cursorLocation = null;
            this.repaint();
        }
    }

    public Point getCursorLocation() {
        return this.cursorLocation;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getSource().equals(this.getGanttChart()) && evt.getPropertyName().equals("layerContainerRowHeaderWidth")) {
            this.setSize(this.getPreferredSize());
        }
    }
}

