/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer;

import com.dlsc.flexgantt.command.CommandStackEvent;
import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.ICommandStackListener;
import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.bookmarks.DefaultBookmarkModel;
import com.dlsc.flexgantt.model.bookmarks.IBookmarkModel;
import com.dlsc.flexgantt.model.calendar.CalendarModelEvent;
import com.dlsc.flexgantt.model.calendar.ICalendarModel;
import com.dlsc.flexgantt.model.calendar.ICalendarModelListener;
import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IDatelineModelListener;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.gantt.DefaultActivityObject;
import com.dlsc.flexgantt.model.gantt.DefaultCapacityObject;
import com.dlsc.flexgantt.model.gantt.DefaultEventObject;
import com.dlsc.flexgantt.model.gantt.DefaultTimelineObject;
import com.dlsc.flexgantt.model.gantt.GanttChartModelEvent;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartModelListener;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.model.scheduling.DefaultResolutionProvider;
import com.dlsc.flexgantt.model.scheduling.IResolutionProvider;
import com.dlsc.flexgantt.model.treetable.ITreeTableModelListener;
import com.dlsc.flexgantt.model.treetable.TreeTableModelEvent;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.PolicyProvider;
import com.dlsc.flexgantt.policy.layer.DefaultCrosshairPolicy;
import com.dlsc.flexgantt.policy.layer.DefaultDragAndDropPolicy;
import com.dlsc.flexgantt.policy.layer.DefaultEditActivityObjectPolicy;
import com.dlsc.flexgantt.policy.layer.DefaultEditCapacityObjectPolicy;
import com.dlsc.flexgantt.policy.layer.DefaultEditLayerPolicy;
import com.dlsc.flexgantt.policy.layer.DefaultEditTimelineObjectPolicy;
import com.dlsc.flexgantt.policy.layer.DefaultLabelPolicy;
import com.dlsc.flexgantt.policy.layer.DefaultLinePolicy;
import com.dlsc.flexgantt.policy.layer.DefaultOverviewPolicy;
import com.dlsc.flexgantt.policy.layer.DefaultPopupPolicy;
import com.dlsc.flexgantt.policy.layer.DefaultRelationshipPolicy;
import com.dlsc.flexgantt.policy.layer.DefaultSelectionPolicy;
import com.dlsc.flexgantt.policy.layer.DefaultSpreadsheetEditPolicy;
import com.dlsc.flexgantt.policy.layer.ICrosshairPolicy;
import com.dlsc.flexgantt.policy.layer.IDragAndDropPolicy;
import com.dlsc.flexgantt.policy.layer.IDragInfoPolicy;
import com.dlsc.flexgantt.policy.layer.IEditActivityObjectPolicy;
import com.dlsc.flexgantt.policy.layer.IEditCapacityObjectPolicy;
import com.dlsc.flexgantt.policy.layer.IEditLayerPolicy;
import com.dlsc.flexgantt.policy.layer.IEditTimelineObjectPolicy;
import com.dlsc.flexgantt.policy.layer.IGridLinePolicy;
import com.dlsc.flexgantt.policy.layer.IGridPolicy;
import com.dlsc.flexgantt.policy.layer.ILabelPolicy;
import com.dlsc.flexgantt.policy.layer.ILinePolicy;
import com.dlsc.flexgantt.policy.layer.IOverviewPolicy;
import com.dlsc.flexgantt.policy.layer.IPopupPolicy;
import com.dlsc.flexgantt.policy.layer.IRelationshipPolicy;
import com.dlsc.flexgantt.policy.layer.ISelectionPolicy;
import com.dlsc.flexgantt.policy.layer.ISpreadsheetEditPolicy;
import com.dlsc.flexgantt.policy.layer.TimeGranularityDragInfoPolicy;
import com.dlsc.flexgantt.policy.layer.TimeGranularityGridLinePolicy;
import com.dlsc.flexgantt.policy.layer.TimeGranularityGridPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.IGridComponent;
import com.dlsc.flexgantt.swing.IGridComponentListener;
import com.dlsc.flexgantt.swing.LicenseDialog;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.layer.AbstractCustomLayer;
import com.dlsc.flexgantt.swing.layer.AbstractLayer;
import com.dlsc.flexgantt.swing.layer.DefaultLayerContainerMenuProvider;
import com.dlsc.flexgantt.swing.layer.DefaultLayerContainerSelectionModel;
import com.dlsc.flexgantt.swing.layer.ILayerContainerListener;
import com.dlsc.flexgantt.swing.layer.ILayerContainerMenuProvider;
import com.dlsc.flexgantt.swing.layer.ILayerContainerSelectionModel;
import com.dlsc.flexgantt.swing.layer.ILayerContainerSelectionModelListener;
import com.dlsc.flexgantt.swing.layer.ILayerFactory;
import com.dlsc.flexgantt.swing.layer.LayerContainerEvent;
import com.dlsc.flexgantt.swing.layer.TimeSpanSelectionEvent;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.system.ActionLayer;
import com.dlsc.flexgantt.swing.layer.system.BackgroundLayer;
import com.dlsc.flexgantt.swing.layer.system.CalendarLayer;
import com.dlsc.flexgantt.swing.layer.system.CrosshairLayer;
import com.dlsc.flexgantt.swing.layer.system.DatelineLayer;
import com.dlsc.flexgantt.swing.layer.system.DragLayer;
import com.dlsc.flexgantt.swing.layer.system.DropShadowLayer;
import com.dlsc.flexgantt.swing.layer.system.EditingLayer;
import com.dlsc.flexgantt.swing.layer.system.EventlineLayer;
import com.dlsc.flexgantt.swing.layer.system.GridLayer;
import com.dlsc.flexgantt.swing.layer.system.LabelLayer;
import com.dlsc.flexgantt.swing.layer.system.LassoLayer;
import com.dlsc.flexgantt.swing.layer.system.LinkLayer;
import com.dlsc.flexgantt.swing.layer.system.PopupLayer;
import com.dlsc.flexgantt.swing.layer.system.RelationshipLayer;
import com.dlsc.flexgantt.swing.layer.system.RowLayer;
import com.dlsc.flexgantt.swing.layer.system.SelectionLayer;
import com.dlsc.flexgantt.swing.layer.system.SpreadsheetLayer;
import com.dlsc.flexgantt.swing.layer.system.TimeNowLayer;
import com.dlsc.flexgantt.swing.layer.timeline.DefaultActivityObjectEditor;
import com.dlsc.flexgantt.swing.layer.timeline.DefaultActivityObjectRenderer;
import com.dlsc.flexgantt.swing.layer.timeline.DefaultCapacityObjectRenderer;
import com.dlsc.flexgantt.swing.layer.timeline.DefaultEventObjectRenderer;
import com.dlsc.flexgantt.swing.layer.timeline.DefaultTimelineObjectEditor;
import com.dlsc.flexgantt.swing.layer.timeline.DefaultTimelineObjectRenderer;
import com.dlsc.flexgantt.swing.layer.timeline.DefaultTimelineObjectSelectionModel;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectEditor;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectRenderer;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectSelectionModel;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.swing.treetable.ITreeTableSelectionModel;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import com.dlsc.flexgantt.swing.util.AutoscrollSupport;
import com.dlsc.flexgantt.swing.util.TableUtils;
import com.dlsc.flexgantt.util.GridLineMode;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.Autoscroll;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class LayerContainer
extends JPanel
implements MouseListener,
MouseMotionListener,
PropertyChangeListener,
ICommandStackListener,
IGanttChartModelListener,
ILayerContainerSelectionModelListener,
ICalendarModelListener,
IDatelineModelListener,
ILayerContainerListener,
IGridComponent,
Autoscroll,
ITreeTableModelListener,
TreeSelectionListener,
TreeExpansionListener {
    private static final Logger LOGGER = Logger.getLogger(LayerContainer.class.getName());
    public static final String PROPERTY_DRAGGING_ENABLED = "draggingEnabled";
    public static final String PROPERTY_LINKING_ENABLED = "linkingEnabled";
    public static final String PROPERTY_POLICY_PROVIDER = "policyProvider";
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";
    public static final String PROPERTY_ALTERNATING_BACKGROUND = "alternatingBackground";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_BOOKMARK_MODEL = "bookmarkModel";
    public static final String PROPERTY_GRID_GRANULARITY = "gridGranularity";
    private int startRow;
    private AbstractGanttChart ganttChart;
    private Timeline timeline;
    private TreeTable treeTable;
    private IGanttChartModel model;
    private Map<Class<? extends AbstractSystemLayer>, AbstractSystemLayer> systemLayersMap;
    private Map<ILayer, TimelineObjectLayer> timelineObjectLayerMap;
    private Map<ILayer, AbstractCustomLayer> customLayerMap;
    private ILayer[] layerStack;
    private ILayerFactory layerFactory;
    private IPolicyProvider policyProvider = new PolicyProvider();
    private boolean draggingEnabled = true;
    private boolean linkingEnabled = true;
    private ILayerContainerSelectionModel selectionModel;
    private ILayerContainerMenuProvider menuProvider = new DefaultLayerContainerMenuProvider();
    private JPopupMenu popup;
    private Color alternatingBackground;
    private List<TreeTableNode> clipNodes = new ArrayList<TreeTableNode>();
    private Dateline dateline;
    private Eventline eventline;
    private List<AbstractLayer> layerList = new ArrayList<AbstractLayer>();
    private CellRendererPane rendererPane = new CellRendererPane();
    private EventListenerList listenerList = new EventListenerList();
    private Map<Object, Color> colorMap = new HashMap<Object, Color>();
    private Map<Object, Icon> iconMap = new HashMap<Object, Icon>();
    private Set<TimelineObjectPath> highlightedObjects = new HashSet<TimelineObjectPath>();
    private boolean highlighting;
    private HighlightThread highlightThread;
    private long highlightingDuration = 2000L;
    private long highlightingDelay = 500L;
    private Map<Class, ITimelineObjectRenderer> rendererMap;
    private Map<Class, ITimelineObjectRenderer> rendererCache;
    private Map<Class, ITimelineObjectEditor> editorMap;
    private Map<ILayer, Icon> layerIconMap = new HashMap<ILayer, Icon>(10);
    private Map<ILayer, ITimelineObjectSelectionModel> layerSelectionModels;
    private IBookmarkModel bookmarkModel = new DefaultBookmarkModel();
    private IGranularity gridGranularity;
    private boolean primary = true;
    private boolean gridAutomatic = true;
    private boolean gridControlVisible = true;
    private int clippingExtra = 25;
    private RenderingDirection renderingDirection = RenderingDirection.LEFT_TO_RIGHT;
    private AutoscrollSupport autoscroll;
    private boolean ignoringTreeTableSelection;
    private IResolutionProvider resolutionProvider = new DefaultResolutionProvider();

    public LayerContainer(AbstractGanttChart ganttChart, IGanttChartModel model, TreeTable treeTable, ILayerFactory layerFactory) {
        super(true);
        this.ganttChart = ganttChart;
        this.timeline = ganttChart.getTimeline();
        this.treeTable = treeTable;
        this.dateline = this.timeline.getDateline();
        this.eventline = this.timeline.getEventline();
        this.setLayout(null);
        this.setName("LayerContainer");
        this.setFocusable(false);
        this.add(this.rendererPane);
        this.autoscroll = new AutoscrollSupport(this, new Insets(25, 25, 25, 25));
        this.rendererMap = new HashMap<Class, ITimelineObjectRenderer>(10);
        this.rendererCache = new HashMap<Class, ITimelineObjectRenderer>(10);
        this.editorMap = new HashMap<Class, ITimelineObjectEditor>(10);
        this.layerSelectionModels = new HashMap<ILayer, ITimelineObjectSelectionModel>(4);
        this.setTimelineObjectRenderer(Object.class, new DefaultTimelineObjectRenderer());
        this.setTimelineObjectRenderer(DefaultCapacityObject.class, new DefaultCapacityObjectRenderer());
        this.setTimelineObjectRenderer(DefaultActivityObject.class, new DefaultActivityObjectRenderer());
        this.setTimelineObjectRenderer(DefaultEventObject.class, new DefaultEventObjectRenderer());
        this.setTimelineObjectEditor(DefaultTimelineObject.class, new DefaultTimelineObjectEditor());
        this.setTimelineObjectEditor(DefaultActivityObject.class, new DefaultActivityObjectEditor());
        this.layerFactory = layerFactory;
        this.policyProvider.setPolicy(IDragAndDropPolicy.class, new DefaultDragAndDropPolicy());
        this.policyProvider.setPolicy(IEditTimelineObjectPolicy.class, new DefaultEditTimelineObjectPolicy());
        this.policyProvider.setPolicy(IEditActivityObjectPolicy.class, new DefaultEditActivityObjectPolicy());
        this.policyProvider.setPolicy(IEditCapacityObjectPolicy.class, new DefaultEditCapacityObjectPolicy());
        this.policyProvider.setPolicy(ILabelPolicy.class, new DefaultLabelPolicy());
        this.policyProvider.setPolicy(IRelationshipPolicy.class, new DefaultRelationshipPolicy());
        this.policyProvider.setPolicy(IPopupPolicy.class, new DefaultPopupPolicy());
        this.policyProvider.setPolicy(ISelectionPolicy.class, new DefaultSelectionPolicy());
        this.policyProvider.setPolicy(ICrosshairPolicy.class, new DefaultCrosshairPolicy());
        this.policyProvider.setPolicy(IOverviewPolicy.class, new DefaultOverviewPolicy());
        this.policyProvider.setPolicy(ILinePolicy.class, new DefaultLinePolicy());
        this.policyProvider.setPolicy(IEditLayerPolicy.class, new DefaultEditLayerPolicy());
        this.policyProvider.setPolicy(IGridPolicy.class, new TimeGranularityGridPolicy());
        this.policyProvider.setPolicy(IGridLinePolicy.class, new TimeGranularityGridLinePolicy());
        this.policyProvider.setPolicy(IDragInfoPolicy.class, new TimeGranularityDragInfoPolicy());
        this.policyProvider.setPolicy(ISpreadsheetEditPolicy.class, new DefaultSpreadsheetEditPolicy());
        ganttChart.addPropertyChangeListener(this);
        this.timeline.addPropertyChangeListener(this);
        this.timeline.getEventline().addPropertyChangeListener(this);
        ganttChart.getCommandStack().addCommandStackListener(this);
        treeTable.setLayerContainer(this);
        treeTable.addTreeExpansionListener(this);
        treeTable.addPropertyChangeListener(this);
        treeTable.getSelectionModel().addTreeSelectionListener(this);
        treeTable.getModel().addTreeTableModelListener(this);
        this.addMouseListener(this.timeline);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseMotionListener(this.timeline);
        this.addMouseWheelListener(this.dateline);
        this.addLayerContainerListener(this);
        this.addPropertyChangeListener(this);
        this.setSelectionModel(new DefaultLayerContainerSelectionModel());
        this.timelineObjectLayerMap = new HashMap<ILayer, TimelineObjectLayer>(2);
        this.customLayerMap = new HashMap<ILayer, AbstractCustomLayer>(1);
        this.systemLayersMap = new HashMap<Class<? extends AbstractSystemLayer>, AbstractSystemLayer>();
        List<Class<? extends AbstractSystemLayer>> upper = this.getTypesOfUpperSystemLayers();
        for (Class<? extends AbstractSystemLayer> clazz : upper) {
            this.setSystemLayer(clazz, layerFactory.createSystemLayer(this, clazz));
        }
        List<Class<? extends AbstractSystemLayer>> lower = this.getTypesOfLowerSystemLayers();
        for (Class<? extends AbstractSystemLayer> clazz : lower) {
            this.setSystemLayer(clazz, layerFactory.createSystemLayer(this, clazz));
        }
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setOpaque(true);
        this.setAutoscrolls(true);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                LayerContainer.this.scrollRectToVisible(new Rectangle(e2.getX(), e2.getY(), 1, 1));
            }
        });
        Dateline dateline = this.timeline.getDateline();
        IDatelineModel iDatelineModel = dateline.getModel();
        iDatelineModel.addDatelineModelListener(this);
        dateline.addPropertyChangeListener(this);
        ganttChart.getCalendarModel().addCalendarListener(this);
        DragLayer dragLayer = this.getSystemLayer(DragLayer.class);
        dragLayer.addDragLayerListener(this.eventline);
        LassoLayer lassoLayer = this.getSystemLayer(LassoLayer.class);
        lassoLayer.addLassoLayerListener(this.eventline);
        ganttChart.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                if (e2.getKeyCode() == 10 && e2.isControlDown() && e2.isShiftDown()) {
                    LicenseDialog.showDialog(LayerContainer.this.getGanttChart());
                }
            }
        });
        this.setModel(model);
    }

    @Override
    public void calendarChanged(CalendarModelEvent evt) {
        this.repaint();
    }

    public void setModel(IGanttChartModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        IGanttChartModel oldModel = this.model;
        if (oldModel != null) {
            oldModel.removeGanttChartModelListener(this);
            oldModel.removeTreeTableModelListener(this);
        }
        this.model = model;
        LinkedList<ILayer> temp = new LinkedList<ILayer>();
        Iterator<ILayer> layers = this.model.getLayers();
        while (layers.hasNext()) {
            temp.add(layers.next());
        }
        this.layerStack = new ILayer[temp.size()];
        temp.toArray(this.layerStack);
        if (this.layerStack == null) {
            throw new IllegalArgumentException("missing layer specifications for gantt chart model");
        }
        this.model.addGanttChartModelListener(this);
        this.model.addTreeTableModelListener(this);
        this.createLayerStack(true);
        this.firePropertyChange(PROPERTY_MODEL, oldModel, this.model);
    }

    @Override
    public void ganttChartChanged(final GanttChartModelEvent e2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LOGGER.entering(this.getClass().getName(), "ganttChartChanged");
                LOGGER.fine("gantt chart changed: " + e2);
                switch (e2.getId()) {
                    case LAYER_ADDED: {
                        ILayer newLayer = e2.getLayer();
                        int l2 = LayerContainer.this.layerStack.length;
                        ILayer[] newStack = new ILayer[l2 + 1];
                        newStack[l2] = newLayer;
                        System.arraycopy(LayerContainer.this.layerStack, 0, newStack, 0, l2);
                        LayerContainer.access$102(LayerContainer.this, newStack);
                        LayerContainer.this.createLayerStack(true);
                        LayerContainer.this.fireLayerContainerChanged(new LayerContainerEvent(LayerContainer.this, LayerContainerEvent.ID.LAYER_STACK_CHANGED));
                        break;
                    }
                    case LAYER_REMOVED: {
                        ILayer removedLayer = e2.getLayer();
                        LayerContainer.this.timelineObjectLayerMap.remove(removedLayer);
                        int l3 = LayerContainer.this.layerStack.length;
                        boolean member = false;
                        for (int i2 = 0; i2 < l3; ++i2) {
                            if (!LayerContainer.this.layerStack[i2].equals(removedLayer)) continue;
                            member = true;
                            break;
                        }
                        if (!member) break;
                        ILayer[] newStack = new ILayer[l3 - 1];
                        int counter = 0;
                        for (int i3 = 0; i3 < l3; ++i3) {
                            if (LayerContainer.this.layerStack[i3].equals(removedLayer)) continue;
                            newStack[counter] = LayerContainer.this.layerStack[i3];
                            ++counter;
                        }
                        LayerContainer.access$102(LayerContainer.this, newStack);
                        LayerContainer.this.layerSelectionModels.remove(removedLayer);
                        LayerContainer.this.createLayerStack(true);
                        LayerContainer.this.repaint();
                        LayerContainer.this.fireLayerContainerChanged(new LayerContainerEvent(LayerContainer.this, LayerContainerEvent.ID.LAYER_STACK_CHANGED));
                        break;
                    }
                    case RELATIONSHIP_ADDED: 
                    case RELATIONSHIP_REMOVED: 
                    case RELATIONSHIP_CHANGED: {
                        LayerContainer.this.repaint();
                        break;
                    }
                    case TIMELINE_OBJECT_CHANGED: {
                        LayerContainer.this.repaint();
                        LayerContainer.this.treeTable.repaint();
                        break;
                    }
                    case TIMELINE_OBJECTS_ADDED: {
                        LayerContainer.this.repaint();
                        break;
                    }
                    case TIMELINE_OBJECTS_REMOVED: {
                        ILayer layer = e2.getLayer();
                        TimelineObjectPath[] paths = e2.getTimelineObjectPaths();
                        if (layer != null && paths != null) {
                            ITimelineObjectSelectionModel sm = LayerContainer.this.getSelectionModel(layer);
                            for (TimelineObjectPath path : paths) {
                                sm.removeSelection(path);
                            }
                        }
                        LayerContainer.this.repaint();
                        break;
                    }
                }
                LOGGER.exiting(this.getClass().getName(), "ganttChartChanged");
            }
        });
    }

    public ILayerFactory getLayerFactory() {
        return this.layerFactory;
    }

    /*
     * WARNING - void declaration
     */
    private void createLayerStack(boolean createLayers) {
        void var4_7;
        ArrayList<AbstractLayer> list = new ArrayList<AbstractLayer>(this.layerList);
        for (AbstractLayer abstractLayer : list) {
            this.removeLayer(abstractLayer);
            if (createLayers) {
                abstractLayer.tearDown();
            }
            if (!(abstractLayer instanceof TimelineObjectLayer)) continue;
            TimelineObjectLayer tlo = (TimelineObjectLayer)abstractLayer;
            this.removeMouseListener(tlo);
            this.removeMouseMotionListener(tlo);
        }
        GridLineMode gridLineMode = this.ganttChart.getGridLineMode();
        this.getSystemLayer(CrosshairLayer.class).setVisible(this.ganttChart.isCrosshairVisible());
        this.getSystemLayer(GridLayer.class).setVisible(gridLineMode != GridLineMode.NO_GRID_LINES);
        this.getSystemLayer(PopupLayer.class).setVisible(this.ganttChart.isPopupVisible());
        this.getSystemLayer(TimeNowLayer.class).setVisible(this.ganttChart.isTimeNowVisible());
        this.getSystemLayer(RelationshipLayer.class).setVisible(this.ganttChart.isRelationsVisible());
        this.getSystemLayer(RowLayer.class).setVisible(this.ganttChart.isRowLayerVisible());
        this.getSystemLayer(LabelLayer.class).setVisible(this.ganttChart.isLabelsVisible());
        this.getSystemLayer(CalendarLayer.class).setVisible(this.ganttChart.isCalendarVisible());
        for (Class<? extends AbstractSystemLayer> layerType : this.getTypesOfUpperSystemLayers()) {
            this.addLayer(this.systemLayersMap.get(layerType));
        }
        int n2 = this.layerStack.length - 1;
        while (var4_7 >= 0) {
            if (this.layerStack[var4_7].isCustomLayer()) {
                AbstractCustomLayer customLayer = null;
                if (createLayers) {
                    customLayer = this.layerFactory.createCustomLayer(this, this.layerStack[var4_7]);
                    if (customLayer == null) {
                        throw new IllegalArgumentException("the layer UI for custom layer '" + this.layerStack[var4_7].getName() + "' may not be NULL!");
                    }
                    this.customLayerMap.put(this.layerStack[var4_7], customLayer);
                } else {
                    customLayer = this.customLayerMap.get(this.layerStack[var4_7]);
                }
                this.addLayer(customLayer);
            } else {
                TimelineObjectLayer objectLayer = null;
                if (createLayers) {
                    objectLayer = this.layerFactory.createTimelineLayer(this, this.layerStack[var4_7]);
                    if (objectLayer == null) {
                        throw new IllegalArgumentException("the layer UI for timeline object layer '" + this.layerStack[var4_7].getName() + "' may not be NULL!");
                    }
                    this.timelineObjectLayerMap.put(this.layerStack[var4_7], objectLayer);
                } else {
                    objectLayer = this.timelineObjectLayerMap.get(this.layerStack[var4_7]);
                }
                this.addMouseListener(objectLayer);
                this.addMouseMotionListener(objectLayer);
                this.addLayer(objectLayer);
            }
            --var4_7;
        }
        for (Class<? extends AbstractSystemLayer> layerType : this.getTypesOfLowerSystemLayers()) {
            this.addLayer(this.systemLayersMap.get(layerType));
        }
    }

    protected List<Class<? extends AbstractSystemLayer>> getTypesOfUpperSystemLayers() {
        ArrayList<Class<? extends AbstractSystemLayer>> result = new ArrayList<Class<? extends AbstractSystemLayer>>();
        result.add(DragLayer.class);
        result.add(LassoLayer.class);
        result.add(DatelineLayer.class);
        result.add(EditingLayer.class);
        result.add(CrosshairLayer.class);
        result.add(PopupLayer.class);
        result.add(TimeNowLayer.class);
        result.add(LabelLayer.class);
        if (this.ganttChart.isVerticalLinesOnTop()) {
            result.add(GridLayer.class);
        }
        result.add(ActionLayer.class);
        result.add(SpreadsheetLayer.class);
        result.add(DropShadowLayer.class);
        return result;
    }

    protected List<Class<? extends AbstractSystemLayer>> getTypesOfLowerSystemLayers() {
        ArrayList<Class<? extends AbstractSystemLayer>> result = new ArrayList<Class<? extends AbstractSystemLayer>>();
        result.add(RelationshipLayer.class);
        result.add(LinkLayer.class);
        if (!this.ganttChart.isVerticalLinesOnTop()) {
            result.add(GridLayer.class);
        }
        result.add(EventlineLayer.class);
        result.add(SelectionLayer.class);
        result.add(RowLayer.class);
        result.add(CalendarLayer.class);
        result.add(BackgroundLayer.class);
        return result;
    }

    private void addLayer(AbstractLayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        this.layerList.add(0, layer);
        layer.addPropertyChangeListener(this);
    }

    private void removeLayer(AbstractLayer layer) {
        layer.removePropertyChangeListener(this);
        this.layerList.remove(layer);
    }

    public int getLayerIndex(AbstractLayer layer) {
        return this.layerList.size() - 1 - this.layerList.indexOf(layer);
    }

    public <T extends AbstractSystemLayer> T getSystemLayer(Class<T> layerType) {
        AbstractSystemLayer layer = this.systemLayersMap.get(layerType);
        if (layer == null) {
            throw new IllegalArgumentException("No system layer found for type " + layerType);
        }
        return (T)layer;
    }

    private <T extends AbstractSystemLayer> void setSystemLayer(Class<? extends T> layerType, T layer) {
        this.systemLayersMap.put(layerType, layer);
    }

    public ObjectBounds getObjectBoundsAt(int x2, int y2) {
        ILayer[] visibleLayers = this.getVisibleLayers();
        if (visibleLayers != null) {
            for (int i2 = visibleLayers.length - 1; i2 >= 0; --i2) {
                TimelineObjectLayer tl = this.getTimelineObjectLayer(visibleLayers[i2]);
                ObjectBounds bounds = tl.getObjectBoundsAt(x2, y2);
                if (bounds == null) continue;
                return bounds;
            }
        }
        return null;
    }

    public ObjectBounds getObjectBoundsAt(int x2, int y2, int proximity) {
        ILayer[] visibleLayers = this.getVisibleLayers();
        if (visibleLayers != null) {
            for (int i2 = visibleLayers.length - 1; i2 >= 0; --i2) {
                TimelineObjectLayer tl = this.getTimelineObjectLayer(visibleLayers[i2]);
                ObjectBounds bounds = tl.getObjectBoundsAt(x2, y2, proximity);
                if (bounds == null) continue;
                return bounds;
            }
        }
        return null;
    }

    public ObjectBounds getObjectBoundsAt(MouseEvent evt) {
        return this.getObjectBoundsAt(evt.getX(), evt.getY());
    }

    public Collection<ObjectBounds> getAllObjectBoundsAt(int x2, int y2) {
        ArrayList<ObjectBounds> result = new ArrayList<ObjectBounds>();
        ILayer[] visibleLayers = this.getVisibleLayers();
        if (visibleLayers != null) {
            for (int i2 = visibleLayers.length - 1; i2 >= 0; --i2) {
                TimelineObjectLayer tl = this.getTimelineObjectLayer(visibleLayers[i2]);
                Collection<ObjectBounds> bounds = tl.getAllObjectBoundsAt(x2, y2);
                if (bounds == null) continue;
                result.addAll(bounds);
            }
        }
        return result;
    }

    public Collection<ObjectBounds> getAllObjectBoundsAt(MouseEvent evt) {
        return this.getAllObjectBoundsAt(evt.getX(), evt.getY());
    }

    public ObjectBounds getObjectBounds(TimelineObjectPath path) {
        ILayer layer = path.getLayer();
        TimelineObjectLayer layerUI = this.getTimelineObjectLayer(layer);
        if (layerUI != null) {
            return layerUI.getObjectBounds(path);
        }
        return null;
    }

    public List<TimelineObjectPath> getSelectedTimelineObjects() {
        ArrayList<TimelineObjectPath> result = new ArrayList<TimelineObjectPath>();
        for (ILayer layer : this.getVisibleLayers()) {
            result.addAll(this.getSelectedTimelineObjects(layer));
        }
        return result;
    }

    public List<TimelineObjectPath> getSelectedTimelineObjects(ILayer layer) {
        ArrayList<TimelineObjectPath> result = new ArrayList<TimelineObjectPath>();
        ITimelineObjectSelectionModel model = this.getSelectionModel(layer);
        Iterator<TimelineObjectPath> iter = model.getSelection();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public TimelineObjectLayer getTimelineObjectLayer(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        return this.timelineObjectLayerMap.get(layer);
    }

    public Collection<TimelineObjectLayer> getTimelineObjectLayers() {
        return this.timelineObjectLayerMap.values();
    }

    public AbstractCustomLayer getCustomLayer(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (!layer.isCustomLayer()) {
            throw new IllegalArgumentException("layer is not a custom layer");
        }
        return this.customLayerMap.get(layer);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.treeTable != null) {
            this.setForeground(this.treeTable.getForeground());
            this.setBackground(this.treeTable.getBackground());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.getDateline().getModel().getDatelineWidth();
        int height = this.getTreeTable().getPreferredSize().height;
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize() {
        int width = this.getTimeline().getMinimumSize().width;
        int height = this.getTreeTable().getMinimumSize().height;
        return new Dimension(width, height);
    }

    public Timeline getTimeline() {
        return this.ganttChart.getTimeline();
    }

    public Dateline getDateline() {
        return this.dateline;
    }

    public Eventline getEventline() {
        return this.eventline;
    }

    public IGanttChartModel getModel() {
        return this.model;
    }

    public AbstractGanttChart getGanttChart() {
        return this.ganttChart;
    }

    public TreeTable getTreeTable() {
        return this.treeTable;
    }

    public Color getBackground(int row) {
        return this.getTreeTable().getBackground(row);
    }

    public int getRowAt(int y2) {
        TreeTable table = this.getTreeTable();
        return table.getRowAt(y2);
    }

    public ITimeSpan getTimeSpanUsed() {
        ITimeSpan usedSpan = TimeSpan.UNDEFINED;
        ArrayList<AbstractLayer> list = new ArrayList<AbstractLayer>();
        for (ILayer layer : this.getVisibleLayers()) {
            TimelineObjectLayer ui = this.getTimelineObjectLayer(layer);
            if (!ui.isVisible()) continue;
            list.add(ui);
        }
        list.addAll(this.customLayerMap.values());
        for (AbstractLayer al : list) {
            ITimeSpan span = al.getTimeSpanUsed();
            if (span == null || span.isUndefined()) continue;
            if (usedSpan.isUndefined()) {
                usedSpan = span;
                continue;
            }
            usedSpan = usedSpan.union(span);
        }
        return usedSpan;
    }

    public int getStartRow() {
        return this.startRow;
    }

    @Override
    public void paintComponent(Graphics g2) {
        List<TreeTableNode> nodes;
        super.paintComponent(g2);
        Rectangle bounds = g2.getClipBounds();
        this.clipNodes.clear();
        this.startRow = this.treeTable.getRowAt(Math.max(0, bounds.y));
        if (this.startRow != -1 && (nodes = this.treeTable.getTreeTableNodes()) != null && nodes.size() > 0) {
            int length = nodes.size();
            TreeTableNode node = nodes.get(this.startRow);
            int y2 = node.getY();
            int animationHeight = 0;
            TreeTableNode animatedNode = this.treeTable.getAnimationNode();
            if (animatedNode != null) {
                double animationPercentage = this.treeTable.getAnimationPercentage();
                animationHeight = (int)((double)animatedNode.getTotalChildrenHeight() * (1.0 - animationPercentage));
            }
            for (int i2 = this.startRow; i2 < length; ++i2) {
                node = nodes.get(i2);
                int rowHeight = node.getHeight();
                this.clipNodes.add(node);
                if ((y2 += rowHeight) > bounds.y + bounds.height + animationHeight) break;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("visible span = " + this.getDateline().getVisibleTimeSpan());
            LOGGER.fine("clip bounds = " + bounds);
            LOGGER.fine("start row = " + this.startRow);
            LOGGER.fine("number of affected tree table nodes = " + this.clipNodes.size());
        }
        for (AbstractLayer layer : this.layerList) {
            if (!layer.isVisible()) continue;
            layer.paintLayer(g2);
        }
    }

    @Override
    public void commandStackChanged(CommandStackEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LayerContainer.this.repaint();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String p2 = evt.getPropertyName();
        if (evt.getSource().equals(this.ganttChart)) {
            if (p2.equals("popupVisible")) {
                this.getSystemLayer(PopupLayer.class).setVisible((Boolean)evt.getNewValue());
            } else if (p2.equals("timeNowVisible")) {
                this.getSystemLayer(TimeNowLayer.class).setVisible((Boolean)evt.getNewValue());
            } else if (p2.equals("relationsVisible")) {
                this.getSystemLayer(RelationshipLayer.class).setVisible((Boolean)evt.getNewValue());
            } else if (p2.equals("crosshairVisible")) {
                this.getSystemLayer(CrosshairLayer.class).setVisible((Boolean)evt.getNewValue());
            } else if (p2.equals("labelsVisible")) {
                this.getSystemLayer(LabelLayer.class).setVisible((Boolean)evt.getNewValue());
            } else if (p2.equals("calendarVisible")) {
                this.getSystemLayer(CalendarLayer.class).setVisible((Boolean)evt.getNewValue());
            } else if (p2.equals("verticalLinesOnTop")) {
                this.createLayerStack(false);
            } else if (p2.equals("gridLineMode")) {
                this.repaint();
            } else if (p2.equals("calendarModel")) {
                ICalendarModel oldModel = (ICalendarModel)evt.getOldValue();
                ICalendarModel newModel = (ICalendarModel)evt.getNewValue();
                oldModel.removeCalendarListener(this);
                newModel.addCalendarListener(this);
            }
        } else if (evt.getSource().equals(this.treeTable)) {
            if (p2.equals("alternatingBackgroundColor")) {
                this.repaint();
            } else if (p2.equals("background")) {
                this.repaint();
            } else if (p2.equals("treeTableSelectionModel")) {
                ITreeTableSelectionModel oldModel = (ITreeTableSelectionModel)evt.getOldValue();
                ITreeTableSelectionModel newModel = (ITreeTableSelectionModel)evt.getNewValue();
                oldModel.removeTreeSelectionListener(this);
                newModel.addTreeSelectionListener(this);
            }
        } else if (evt.getSource().equals(this.dateline)) {
            if (p2.equals("datelineModel")) {
                IDatelineModel oldModel = (IDatelineModel)evt.getOldValue();
                oldModel.removeDatelineModelListener(this);
                IDatelineModel newModel = (IDatelineModel)evt.getNewValue();
                newModel.addDatelineModelListener(this);
                this.repaint();
            }
        } else if (evt.getSource() instanceof AbstractLayer) {
            if (p2.equals("alpha")) {
                this.repaint();
            } else if (p2.equals("visible")) {
                this.repaint();
            }
        } else if (evt.getSource().equals(this)) {
            this.repaint();
        }
    }

    public ILayer[] getLayers() {
        return this.layerStack;
    }

    public ILayer[] getVisibleLayers() {
        ArrayList<ILayer> list = new ArrayList<ILayer>();
        for (ILayer layer : this.layerStack) {
            if (!this.isLayerVisible(layer)) continue;
            list.add(layer);
        }
        ILayer[] result = new ILayer[list.size()];
        list.toArray(result);
        return result;
    }

    public boolean isLayerVisible(ILayer layer) {
        TimelineObjectLayer layerUI = this.getTimelineObjectLayer(layer);
        if (layerUI != null) {
            return layerUI.isVisible();
        }
        return false;
    }

    public void moveToBack(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        int s2 = this.layerStack.length;
        ILayer[] temp = new ILayer[s2];
        temp[0] = layer;
        int counter = 1;
        for (int i2 = 0; i2 < s2; ++i2) {
            if (this.layerStack[i2] == layer) continue;
            temp[counter] = this.layerStack[i2];
            ++counter;
        }
        this.layerStack = temp;
        this.createLayerStack(false);
        this.fireLayerContainerChanged(new LayerContainerEvent(this, LayerContainerEvent.ID.LAYER_STACK_CHANGED));
    }

    public void moveToFront(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        int s2 = this.layerStack.length;
        ILayer[] temp = new ILayer[s2];
        int counter = 0;
        for (int i2 = 0; i2 < s2; ++i2) {
            if (this.layerStack[i2] == layer) continue;
            temp[counter] = this.layerStack[i2];
            ++counter;
        }
        temp[counter] = layer;
        this.layerStack = temp;
        this.createLayerStack(false);
        this.fireLayerContainerChanged(new LayerContainerEvent(this, LayerContainerEvent.ID.LAYER_STACK_CHANGED));
    }

    public void moveBack(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        int oldIndex = this.getLayerIndex(layer);
        if (oldIndex > 0) {
            int newIndex = oldIndex - 1;
            ILayer temp = this.layerStack[newIndex];
            this.layerStack[newIndex] = layer;
            this.layerStack[oldIndex] = temp;
        }
        this.createLayerStack(false);
        this.fireLayerContainerChanged(new LayerContainerEvent(this, LayerContainerEvent.ID.LAYER_STACK_CHANGED));
    }

    public void moveForward(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        int s2 = this.layerStack.length;
        int oldIndex = this.getLayerIndex(layer);
        if (oldIndex != -1 && oldIndex < s2 - 1) {
            int newIndex = oldIndex + 1;
            ILayer temp = this.layerStack[newIndex];
            this.layerStack[newIndex] = layer;
            this.layerStack[oldIndex] = temp;
        }
        this.createLayerStack(false);
        this.fireLayerContainerChanged(new LayerContainerEvent(this, LayerContainerEvent.ID.LAYER_STACK_CHANGED));
    }

    public int getLayerIndex(ILayer layer) {
        int s2 = this.layerStack.length;
        for (int i2 = 0; i2 < s2; ++i2) {
            if (!this.layerStack[i2].equals(layer)) continue;
            return i2;
        }
        return -1;
    }

    public void showLayer(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        AbstractLayer layerUI = null;
        layerUI = layer.isCustomLayer() ? this.getCustomLayer(layer) : this.getTimelineObjectLayer(layer);
        if (layerUI == null) {
            throw new IllegalArgumentException("layer is not a member of this layer container");
        }
        layerUI.setVisible(true);
        this.fireLayerContainerChanged(new LayerContainerEvent(this, LayerContainerEvent.ID.LAYER_STACK_CHANGED));
    }

    public void showAllLayers() {
        for (ILayer layer : this.getLayers()) {
            this.showLayer(layer);
        }
    }

    public void hideLayer(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        AbstractLayer layerUI = null;
        layerUI = layer.isCustomLayer() ? this.getCustomLayer(layer) : this.getTimelineObjectLayer(layer);
        if (layerUI == null) {
            throw new IllegalArgumentException("layer is not a member of this layer container");
        }
        layerUI.setVisible(false);
        this.fireLayerContainerChanged(new LayerContainerEvent(this, LayerContainerEvent.ID.LAYER_STACK_CHANGED));
    }

    public void hideAllLayers() {
        for (ILayer layer : this.getVisibleLayers()) {
            this.hideLayer(layer);
        }
    }

    public void alignStartTimes() {
        this.alignTimes(true);
    }

    public void alignEndTimes() {
        this.alignTimes(false);
    }

    private void alignTimes(boolean startTimes) {
        IGanttChartModel model = this.getModel();
        ILayer[] layers = this.getVisibleLayers();
        long time = Long.MAX_VALUE;
        if (!startTimes) {
            time = Long.MIN_VALUE;
        }
        LOGGER.fine("pass 1");
        for (ILayer iLayer : layers) {
            LOGGER.fine("layer = " + iLayer);
            ITimelineObjectSelectionModel sm = this.getSelectionModel(iLayer);
            Iterator<TreePath> nodes = sm.getSelectionPaths();
            while (nodes.hasNext()) {
                TreePath node = nodes.next();
                LOGGER.fine("tree node = " + node);
                Iterator<TimelineObjectPath> objects = sm.getSelection(node);
                while (objects.hasNext()) {
                    TimelineObjectPath tlop = objects.next();
                    Object timelineObject = tlop.getTimelineObject();
                    LOGGER.fine("timeline object = " + timelineObject);
                    IEditTimelineObjectPolicy ep = this.policyProvider.getPolicy(IEditTimelineObjectPolicy.class);
                    if (ep.isStartTimeChangeable(tlop, model)) {
                        ITimeSpan span = model.getTimeSpan(timelineObject);
                        if (startTimes) {
                            LOGGER.fine("earliest start time before current object = " + time);
                            time = Math.min(time, span.getStartTime());
                            LOGGER.fine("earliest start time after current object= " + time);
                            continue;
                        }
                        LOGGER.fine("latest end time before current object = " + time);
                        time = Math.max(time, span.getEndTime());
                        LOGGER.fine("latest end time after current object= " + time);
                        continue;
                    }
                    LOGGER.fine("time span of object may not be changed");
                }
            }
        }
        LOGGER.fine("pass 2");
        if (startTimes && time != Long.MAX_VALUE || !startTimes && time != Long.MIN_VALUE) {
            IEditTimelineObjectPolicy ep = this.policyProvider.getPolicy(IEditTimelineObjectPolicy.class);
            LinkedList<TimelineObjectPath> timelineObjects = new LinkedList<TimelineObjectPath>();
            LinkedList<ITimeSpan> timeSpans = new LinkedList<ITimeSpan>();
            for (ILayer layer : layers) {
                LOGGER.fine("layer = " + layer);
                ITimelineObjectSelectionModel sm = this.getSelectionModel(layer);
                Iterator<TreePath> nodes = sm.getSelectionPaths();
                while (nodes.hasNext()) {
                    TreePath node = nodes.next();
                    LOGGER.fine("node = " + node);
                    Iterator<TimelineObjectPath> objects = sm.getSelection(node);
                    while (objects.hasNext()) {
                        TimelineObjectPath tlop = objects.next();
                        LOGGER.fine("timeline object path = " + tlop);
                        if (ep.isStartTimeChangeable(tlop, model)) {
                            Object timelineObject = tlop.getTimelineObject();
                            ITimeSpan span = model.getTimeSpan(timelineObject);
                            LOGGER.fine("old span = " + span);
                            span = startTimes ? new TimeSpan(time, time + span.getDuration()) : new TimeSpan(time - span.getDuration(), time);
                            LOGGER.fine("new span = " + span);
                            timelineObjects.add(tlop);
                            timeSpans.add(span);
                            continue;
                        }
                        LOGGER.fine("time span of object may not be changed");
                    }
                }
            }
            if (timelineObjects.size() > 0) {
                ICommand iCommand = ep.getChangeTimeSpansCommand(model, timelineObjects, timeSpans, 2);
                this.ganttChart.commandExecute(iCommand);
            }
        } else {
            LOGGER.fine("time span still equal to Long.MAX_VALUE, no objects changed");
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        this.maybeShowPopup(evt);
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        Collection<ObjectBounds> bounds;
        this.treeTable.getCellFocusManager().looseFocus();
        if (!(this.maybeShowPopup(evt) || evt.isConsumed() || evt.isShiftDown() || (evt.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0 || !SwingUtilities.isLeftMouseButton(evt) || evt.getClickCount() != 1 || (bounds = this.getAllObjectBoundsAt(evt)) != null && bounds.size() != 0)) {
            this.clearTimelineObjectSelection();
            this.clearTimeSpanSelection();
        }
        this.ganttChart.requestFocus();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.maybeShowPopup(evt);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    private boolean maybeShowPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            ISelectionPolicy sp;
            this.popup = null;
            ObjectBounds bounds = this.getObjectBoundsAt(evt.getX(), evt.getY());
            if (bounds != null) {
                ILayer layer = bounds.getLayer();
                TimelineObjectPath path = bounds.getPath();
                ITimelineObjectSelectionModel selectionModel = this.getSelectionModel(layer);
                if (!evt.isShiftDown() && (evt.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0 && !selectionModel.isSelected(path)) {
                    this.clearTimelineObjectSelection();
                }
                if (!this.isIgnoringTreeTableSelection()) {
                    this.treeTable.clearSelection();
                }
                if ((sp = this.policyProvider.getPolicy(ISelectionPolicy.class)).isSelectable(bounds.getPath(), this.model)) {
                    selectionModel.addSelection(path);
                }
            }
            RelationshipLayer relLayer = this.getSystemLayer(RelationshipLayer.class);
            List<IRelationship> relationships = relLayer.getRelationshipsAt(evt.getX(), evt.getY());
            IRelationship clickedRelationship = null;
            if (!relationships.isEmpty()) {
                clickedRelationship = relationships.get(0);
                if (!evt.isShiftDown() && (evt.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0) {
                    relLayer.getSelectionModel().clearSelection();
                }
                if (!this.isIgnoringTreeTableSelection()) {
                    this.treeTable.clearSelection();
                }
                if ((sp = this.policyProvider.getPolicy(ISelectionPolicy.class)).isSelectable(clickedRelationship, this.model)) {
                    ArrayList<IRelationship> list = new ArrayList<IRelationship>();
                    list.add(clickedRelationship);
                    relLayer.getSelectionModel().addSelection(list);
                }
            }
            this.popup = this.menuProvider != null ? this.retrievePopupFromManager(evt) : this.getComponentPopupMenu();
            if (this.popup != null) {
                this.popup.show(this, evt.getX(), evt.getY());
                return true;
            }
        }
        return false;
    }

    private JPopupMenu retrievePopupFromManager(MouseEvent evt) {
        if (this.menuProvider != null) {
            int row = this.treeTable.getRowAt(evt.getY());
            TreePath tp = null;
            if (row >= 0 && row < this.treeTable.getTreeTableNodes().size()) {
                tp = this.treeTable.getTreePath(row);
            }
            if (this.ganttChart.getActiveSpreadsheet() != null) {
                ITimeSpan timeSpan = this.dateline.getTimeSpanAt(evt.getX(), false);
                return this.menuProvider.getPopupMenu(this, evt, timeSpan, tp, this.ganttChart.getActiveSpreadsheet());
            }
            Collection<ObjectBounds> bounds = this.getAllObjectBoundsAt(evt.getX(), evt.getY());
            ArrayList<TimelineObjectPath> result = new ArrayList<TimelineObjectPath>();
            for (ObjectBounds b2 : bounds) {
                result.add(b2.getPath());
            }
            int s2 = result.size();
            TimelineObjectPath[] toPaths = new TimelineObjectPath[s2];
            result.toArray(toPaths);
            long time = this.dateline.getTimeAt(evt.getX());
            RelationshipLayer rl = this.getSystemLayer(RelationshipLayer.class);
            List<IRelationship> relationships = rl.getRelationshipsAt(evt.getX(), evt.getY());
            return this.menuProvider.getPopupMenu(this, evt, time, tp, toPaths, relationships.toArray(new IRelationship[0]));
        }
        return null;
    }

    public IPolicyProvider getPolicyProvider() {
        return this.policyProvider;
    }

    public void setPolicyProvider(IPolicyProvider provider) {
        IPolicyProvider oldProvider = this.policyProvider;
        this.policyProvider = provider;
        this.firePropertyChange(PROPERTY_POLICY_PROVIDER, oldProvider, provider);
    }

    public void setDraggingEnabled(boolean enabled) {
        boolean oldValue = this.draggingEnabled;
        this.draggingEnabled = enabled;
        this.firePropertyChange(PROPERTY_DRAGGING_ENABLED, oldValue, enabled);
    }

    public boolean isDraggingEnabled() {
        return this.draggingEnabled;
    }

    public void setLinkingEnabled(boolean enabled) {
        boolean oldValue = this.linkingEnabled;
        this.linkingEnabled = enabled;
        this.firePropertyChange(PROPERTY_LINKING_ENABLED, oldValue, enabled);
    }

    public boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public ILayerContainerSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ILayerContainerSelectionModel model) {
        ILayerContainerSelectionModel oldModel = this.selectionModel;
        if (oldModel != null) {
            oldModel.removeLayerContainerSelectionModelListener(this);
        }
        this.selectionModel = model;
        this.firePropertyChange(PROPERTY_SELECTION_MODEL, oldModel, this.selectionModel);
        this.selectionModel.addLayerContainerSelectionModelListener(this);
    }

    @Override
    public void timeSpansAdded(TimeSpanSelectionEvent evt) {
        this.repaint();
    }

    @Override
    public void timeSpansRemoved(TimeSpanSelectionEvent evt) {
        this.repaint();
    }

    public ILayerContainerMenuProvider getMenuProvider() {
        return this.menuProvider;
    }

    public void setMenuProvider(ILayerContainerMenuProvider provider) {
        this.menuProvider = provider;
    }

    public Color getAlternatingBackground() {
        return this.alternatingBackground;
    }

    public void setAlternatingBackground(Color color) {
        Color oldColor = this.alternatingBackground;
        this.alternatingBackground = color;
        this.firePropertyChange(PROPERTY_ALTERNATING_BACKGROUND, oldColor, color);
        this.repaint();
    }

    public List<TreeTableNode> getClipNodes() {
        return this.clipNodes;
    }

    public boolean hasClipNodes() {
        return this.clipNodes.size() > 0;
    }

    public void setTimelineObjectStatusColor(Object status, Color color) {
        if (status == null) {
            throw new IllegalArgumentException("status object can not be NULL");
        }
        this.colorMap.put(status, color);
    }

    public Color getTimelineObjectStatusColor(Object status) {
        if (status == null) {
            throw new IllegalArgumentException("status object can not be NULL");
        }
        return this.colorMap.get(status);
    }

    public void setTimelineObjectStatusIcon(Object status, Icon icon) {
        if (status == null) {
            throw new IllegalArgumentException("status object can not be NULL");
        }
        this.iconMap.put(status, icon);
    }

    public Icon getTimelineObjectStatusIcon(Object status) {
        if (status == null) {
            throw new IllegalArgumentException("status object can not be NULL");
        }
        return this.iconMap.get(status);
    }

    @Override
    public void datelineModelWillChange(DatelineModelEvent evt) {
    }

    @Override
    public void datelineModelChanged(DatelineModelEvent evt) {
        this.repaint();
    }

    public CellRendererPane getRendererPane() {
        return this.rendererPane;
    }

    public void addLayerContainerListener(ILayerContainerListener l2) {
        this.listenerList.add(ILayerContainerListener.class, l2);
    }

    public void removeLayerContainerListener(ILayerContainerListener l2) {
        this.listenerList.remove(ILayerContainerListener.class, l2);
    }

    protected void fireLayerContainerChanged(LayerContainerEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ILayerContainerListener.class) continue;
            ((ILayerContainerListener)listeners[i2 + 1]).layerContainerChanged(evt);
        }
    }

    @Override
    public void layerContainerChanged(LayerContainerEvent evt) {
        switch (evt.getId()) {
            case LAYER_STACK_CHANGED: {
                this.repaint();
            }
        }
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public boolean isPopupShowing() {
        return this.popup != null && this.popup.isVisible();
    }

    public void addHighlightedObject(TimelineObjectPath path) {
        if (path == null) {
            throw new IllegalArgumentException("path can not be NULL");
        }
        this.highlightedObjects.add(path);
        this.updateHighlightThread();
    }

    public void addHighlightedObjects(Collection<TimelineObjectPath> paths) {
        if (paths == null) {
            throw new IllegalArgumentException("paths can not be NULL");
        }
        for (TimelineObjectPath path : paths) {
            if (path == null || this.highlightedObjects.contains(path)) continue;
            this.highlightedObjects.add(path);
        }
        this.updateHighlightThread();
    }

    public void removeHighlightedObjects(Collection<TimelineObjectPath> paths) {
        if (paths == null) {
            throw new IllegalArgumentException("paths can not be NULL");
        }
        this.highlightedObjects.removeAll(paths);
        this.updateHighlightThread();
    }

    public void clearHighlightedObjects() {
        this.highlightedObjects.clear();
        this.updateHighlightThread();
    }

    public boolean isHighlighted(TimelineObjectPath path) {
        return this.highlightedObjects.contains(path);
    }

    private synchronized void updateHighlightThread() {
        boolean required;
        boolean bl = required = this.highlightedObjects.size() > 0;
        if (!required && this.highlightThread != null) {
            this.highlightThread.stopRunning();
            this.highlightThread = null;
        } else if (required && this.highlightThread == null) {
            this.highlightThread = new HighlightThread();
            this.highlightThread.start();
        }
    }

    public void setHighlighting(boolean b2) {
        this.highlighting = b2;
        this.repaint();
    }

    public boolean isHighlighting() {
        return this.highlighting;
    }

    public long getHighlightingDelay() {
        return this.highlightingDelay;
    }

    public void setHighlightingDelay(long delay) {
        this.highlightingDelay = delay;
    }

    public long getHighlightingDuration() {
        return this.highlightingDuration;
    }

    public void setHighlightingDuration(long duration) {
        this.highlightingDuration = duration;
    }

    public void setTimelineObjectRenderer(Class objectType, ITimelineObjectRenderer renderer) {
        if (objectType == null) {
            throw new IllegalArgumentException("the timeline object type can not be NULL");
        }
        this.rendererCache.clear();
        this.rendererMap.put(objectType, renderer);
    }

    public void setTimelineObjectEditor(Class objectType, ITimelineObjectEditor editor) {
        if (objectType == null) {
            throw new IllegalArgumentException("the timeline object type can not be NULL");
        }
        if (editor == null) {
            throw new IllegalArgumentException("the timeline object editor can not be NULL");
        }
        this.editorMap.put(objectType, editor);
    }

    public ITimelineObjectRenderer getTimelineObjectRenderer(Class cl) {
        if (cl == null) {
            return null;
        }
        ITimelineObjectRenderer renderer = this.rendererCache.get(cl);
        if (renderer != null) {
            return renderer;
        }
        renderer = this.rendererMap.get(cl);
        if (renderer != null) {
            this.rendererCache.put(cl, renderer);
            return renderer;
        }
        renderer = this.getTimelineObjectRenderer(cl.getSuperclass());
        this.rendererCache.put(cl, renderer);
        return renderer;
    }

    public ITimelineObjectEditor getTimelineObjectEditor(Class cl) {
        if (cl == null) {
            return null;
        }
        ITimelineObjectEditor renderer = this.editorMap.get(cl);
        if (renderer != null) {
            return renderer;
        }
        return this.getTimelineObjectEditor(cl.getSuperclass());
    }

    public void setLayerIcon(ILayer layer, Icon icon) {
        this.layerIconMap.put(layer, icon);
    }

    public Icon getLayerIcon(ILayer layer) {
        Icon icon = this.layerIconMap.get(layer);
        if (icon != null) {
            return icon;
        }
        return IconRegistry.getIcon(IconId.LAYER);
    }

    public ITimelineObjectSelectionModel getSelectionModel(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be null");
        }
        ITimelineObjectSelectionModel model = this.layerSelectionModels.get(layer);
        if (model == null) {
            model = new DefaultTimelineObjectSelectionModel(layer);
            this.setSelectionModel(layer, model);
        }
        return model;
    }

    public void setSelectionModel(ILayer layer, ITimelineObjectSelectionModel model) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("model can not be null");
        }
        this.layerSelectionModels.put(layer, model);
    }

    public Map<Class, ITimelineObjectRenderer> getRendererMap() {
        return this.rendererMap;
    }

    public void setRendererMap(Map<Class, ITimelineObjectRenderer> map) {
        if (map == null) {
            throw new IllegalArgumentException("renderer map can not be NULL");
        }
        this.rendererMap = map;
    }

    public IBookmarkModel getBookmarkModel() {
        return this.bookmarkModel;
    }

    public void setBookmarkModel(IBookmarkModel model) {
        if (model == null) {
            throw new IllegalArgumentException("bookmark model can not be NULL");
        }
        IBookmarkModel oldModel = this.bookmarkModel;
        this.bookmarkModel = model;
        this.firePropertyChange(PROPERTY_BOOKMARK_MODEL, oldModel, this.bookmarkModel);
    }

    @Override
    public IGranularity getGridGranularity() {
        return this.gridGranularity;
    }

    @Override
    public void setGridGranularity(IGranularity granularity) {
        this.gridGranularity = granularity;
        this.fireGridChanged();
    }

    @Override
    public void setGridAutomatic(boolean auto) {
        this.gridAutomatic = auto;
        this.fireGridChanged();
    }

    @Override
    public boolean isGridAutomatic() {
        return this.gridAutomatic;
    }

    public void setGridControlVisible(boolean b2) {
        this.gridControlVisible = b2;
        this.fireGridChanged();
    }

    @Override
    public boolean isGridControlVisible() {
        return this.gridControlVisible;
    }

    @Override
    public String getGridComponentName() {
        if (!this.primary) {
            return Messages.getString("LayerContainer.GRID_COMPONENT_NAME_SECONDARY");
        }
        return Messages.getString("LayerContainer.GRID_COMPONENT_NAME_PRIMARY");
    }

    @Override
    public IGridPolicy getGridPolicy() {
        return this.policyProvider.getPolicy(IGridPolicy.class);
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public void showEarliestObjects() {
        ITimeSpan span = this.getTimeSpanUsed();
        long time = span.getStartTime();
        this.ganttChart.showTime(time, true);
    }

    public void showLatestObjects() {
        ITimeSpan span = this.getTimeSpanUsed();
        long time = span.getEndTime();
        this.ganttChart.showTime(time, true);
    }

    public void showAllObjects() {
        ITimeSpan span = this.getTimeSpanUsed();
        if (!span.isUndefined()) {
            this.getDateline().requestVisibleTimeSpan(this.dateline.getTimeSpan().intersection(span));
        }
    }

    public void selectAllTimelineObjects() {
        ITimeSpan span = this.dateline.getTimeSpan();
        List<TreeTableNode> nodes = this.treeTable.getTreeTableNodes();
        Iterator<ILayer> layers = this.model.getLayers();
        while (layers.hasNext()) {
            ILayer layer = layers.next();
            ITimelineObjectSelectionModel selectionModel = this.getSelectionModel(layer);
            selectionModel.clearSelection();
            for (TreeTableNode node : nodes) {
                Object modelNode = node.getModelNode();
                TreePath treePath = node.getPath();
                Iterator iter = this.model.getTimelineObjectsIterator(modelNode, layer, span);
                ArrayList<TimelineObjectPath> selection = new ArrayList<TimelineObjectPath>();
                while (iter.hasNext()) {
                    TimelineObjectPath tloPath = new TimelineObjectPath(treePath, iter.next(), layer);
                    selection.add(tloPath);
                }
                selectionModel.addSelection(selection);
            }
        }
    }

    public void clearTimelineObjectSelection() {
        Iterator<ILayer> layers = this.model.getLayers();
        while (layers.hasNext()) {
            ILayer layer = layers.next();
            ITimelineObjectSelectionModel selectionModel = this.getSelectionModel(layer);
            selectionModel.clearSelection();
        }
    }

    public void clearTimeSpanSelection() {
        this.selectionModel.clearSelectedTimeSpans();
    }

    public void deleteSelectedTimelineObjects() {
        List<TimelineObjectPath> selection = this.getSelectedTimelineObjects();
        if (selection != null && selection.size() > 0) {
            IPolicyProvider pp = this.getPolicyProvider();
            IEditTimelineObjectPolicy ep = pp.getPolicy(IEditTimelineObjectPolicy.class);
            IGanttChartModel model = this.getModel();
            LinkedList<TimelineObjectPath> deletedObjects = new LinkedList<TimelineObjectPath>();
            for (TimelineObjectPath path : selection) {
                if (!ep.isDeletable(path, model)) continue;
                deletedObjects.add(path);
            }
            if (deletedObjects.size() > 0) {
                ICommand cmd = ep.getDeleteCommand(model, deletedObjects);
                this.ganttChart.commandExecute(cmd);
            }
        }
    }

    public void deleteSelectedRelationships() {
        RelationshipLayer rl = this.getSystemLayer(RelationshipLayer.class);
        rl.deleteSelectedRelationships();
    }

    public void repaintRow(int row) {
        List<TreeTableNode> nodes = this.treeTable.getTreeTableNodes();
        if (row >= 0 && row < nodes.size()) {
            TreeTableNode node = nodes.get(row);
            int y2 = node.getY();
            int h2 = node.getHeight();
            this.repaint(0, y2, this.getWidth(), h2);
        }
    }

    @Override
    public void addGridComponentListener(IGridComponentListener l2) {
        this.listenerList.add(IGridComponentListener.class, l2);
    }

    @Override
    public void removeGridComponentListener(IGridComponentListener l2) {
        this.listenerList.remove(IGridComponentListener.class, l2);
    }

    protected void fireGridChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != IGridComponentListener.class) continue;
            ((IGridComponentListener)listeners[i2 + 1]).gridComponentChanged();
        }
    }

    public void setClippingExtra(int extra) {
        if (this.clippingExtra < 0) {
            throw new IllegalArgumentException("clipping extra pixels must be larger than or equal to 0 but was " + this.clippingExtra);
        }
        this.clippingExtra = extra;
    }

    public int getClippingExtra() {
        return this.clippingExtra;
    }

    public void setRenderingDirection(RenderingDirection direction) {
        if (direction == null) {
            throw new IllegalArgumentException("direction can not be NULL");
        }
        this.renderingDirection = direction;
    }

    public RenderingDirection getRenderingDirection() {
        return this.renderingDirection;
    }

    @Override
    public void autoscroll(Point cursorLocn) {
        this.autoscroll.autoscroll(cursorLocn);
    }

    @Override
    public Insets getAutoscrollInsets() {
        return this.autoscroll.getAutoscrollInsets();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.doTreeExpandCollapse();
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.doTreeExpandCollapse();
    }

    private void doTreeExpandCollapse() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LayerContainer.this.setSize(LayerContainer.this.getPreferredSize());
                LayerContainer.this.revalidate();
            }
        });
    }

    @Override
    public void treeNodeKeyChanged(TreeTableModelEvent evt) {
    }

    @Override
    public void treeNodeValueChanged(TreeTableModelEvent evt) {
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e2) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LayerContainer.this.clearTimelineObjectSelection();
            }
        });
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LayerContainer.this.clearTimelineObjectSelection();
            }
        });
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LayerContainer.this.clearTimelineObjectSelection();
            }
        });
    }

    public boolean isIgnoringTreeTableSelection() {
        return this.ignoringTreeTableSelection;
    }

    public void setIgnoringTreeTableSelection(boolean ignore) {
        this.ignoringTreeTableSelection = ignore;
    }

    public void tearDown() {
        LinkedList<AbstractLayer> allLayers = new LinkedList<AbstractLayer>();
        allLayers.addAll(this.timelineObjectLayerMap.values());
        allLayers.addAll(this.customLayerMap.values());
        allLayers.addAll(this.systemLayersMap.values());
        for (AbstractLayer layer : allLayers) {
            layer.tearDown();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e2) {
        TableUtils.repaintAfterValueChanged(this, this.treeTable, e2);
    }

    public IResolutionProvider getResolutionProvider() {
        return this.resolutionProvider;
    }

    public void setResolutionProvider(IResolutionProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("resolution provider can not be NULL");
        }
        this.resolutionProvider = provider;
    }

    static /* synthetic */ ILayer[] access$102(LayerContainer x0, ILayer[] x1) {
        x0.layerStack = x1;
        return x1;
    }

    class HighlightThread
    extends Thread {
        private final Logger LOGGER;
        private boolean running;

        public HighlightThread() {
            super("FlexGanttHighlightThread");
            this.LOGGER = Logger.getLogger(HighlightThread.class.getName());
            this.running = true;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            long startTime = Calendar.getInstance().getTimeInMillis();
            while (this.running && (LayerContainer.this.highlightingDuration == -1L || Calendar.getInstance().getTimeInMillis() - startTime < LayerContainer.this.highlightingDuration)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LayerContainer.this.setHighlighting(!LayerContainer.this.isHighlighting());
                    }
                });
                try {
                    HighlightThread.sleep(LayerContainer.this.highlightingDelay);
                }
                catch (InterruptedException e2) {
                    this.LOGGER.throwing(this.getClass().getName(), "run()", e2);
                }
            }
        }

        public void stopRunning() {
            this.running = false;
            LayerContainer.this.setHighlighting(false);
        }
    }

    public static enum RenderingDirection {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }
}

