/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.paging.IPagingModel;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.PagingControlPanel;
import com.dlsc.flexgantt.swing.PagingControlType;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import com.dlsc.flexgantt.swing.util.Simple3DBorder;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class PagingControl
extends JLabel {
    private PagingControlType type;
    private PagingControlPanel pagingControlPanel;
    private AbstractGanttChart ganttChart;

    public PagingControl(PagingControlPanel controlPanel, PagingControlType type) {
        super("");
        this.pagingControlPanel = controlPanel;
        this.ganttChart = controlPanel.getGanttChart();
        this.type = type;
        this.setPreferredSize(new Dimension(15, 15));
        this.setOpaque(true);
        switch (type) {
            case BEGINNING: {
                this.setIcon(IconRegistry.getIcon(IconId.PAGE_BEGINNING));
                this.setDisabledIcon(IconRegistry.getIcon(IconId.PAGE_BEGINNING));
                this.setName("PageBeginningControl");
                this.setToolTipText(Messages.getString("PagingControl.TOOLTIP_FIRST_PAGE"));
                break;
            }
            case EARLIER: {
                this.setIcon(IconRegistry.getIcon(IconId.PAGE_EARLIER));
                this.setDisabledIcon(IconRegistry.getIcon(IconId.PAGE_EARLIER));
                this.setName("PageEarlierControl");
                this.setToolTipText(Messages.getString("PagingControl.TOOLTIP_EARLIER_PAGE"));
                break;
            }
            case CUSTOM: {
                this.setIcon(IconRegistry.getIcon(IconId.PAGE_SELECTION));
                this.setDisabledIcon(IconRegistry.getIcon(IconId.PAGE_SELECTION));
                this.setName("PageSelectionControl");
                this.setToolTipText(Messages.getString("PagingControl.TOOLTIP_SELECT_A_PAGE"));
                break;
            }
            case LATER: {
                this.setIcon(IconRegistry.getIcon(IconId.PAGE_LATER));
                this.setDisabledIcon(IconRegistry.getIcon(IconId.PAGE_LATER));
                this.setName("PageLaterControl");
                this.setToolTipText(Messages.getString("PagingControl.TOOLTIP_LATER_PAGE"));
                break;
            }
            case END: {
                this.setIcon(IconRegistry.getIcon(IconId.PAGE_END));
                this.setDisabledIcon(IconRegistry.getIcon(IconId.PAGE_END));
                this.setName("PageEndControl");
                this.setToolTipText(Messages.getString("PagingControl.TOOLTIP_LAST_PAGE"));
            }
        }
        this.setBorder(new Simple3DBorder());
        this.setHorizontalAlignment(0);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){
            private Color fgColor;
            private Color bgColor;

            @Override
            public void mouseClicked(MouseEvent e2) {
                PagingControl.this.requestFocus();
                AbstractGanttChart gc2 = PagingControl.this.getGanttChart();
                IPagingModel model = gc2.getPagingModel();
                if (model != null) {
                    switch (PagingControl.this.type) {
                        case BEGINNING: {
                            model.firstPage();
                            break;
                        }
                        case EARLIER: {
                            model.earlierPage();
                            break;
                        }
                        case CUSTOM: {
                            PagingControl.this.pagingControlPanel.openPageSelection();
                            break;
                        }
                        case LATER: {
                            model.laterPage();
                            break;
                        }
                        case END: {
                            model.lastPage();
                        }
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
                this.fgColor = PagingControl.this.getForeground();
                this.bgColor = PagingControl.this.getBackground();
                PagingControl.this.setForeground(ColorUtil.getSelectionForeground());
                PagingControl.this.setBackground(ColorUtil.getSelectionBackground());
                PagingControl.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e2) {
                if (this.bgColor != null) {
                    PagingControl.this.setForeground(this.fgColor);
                    PagingControl.this.setBackground(this.bgColor);
                }
            }
        });
    }

    public PagingControlPanel getNavigationControlPanel() {
        return this.pagingControlPanel;
    }

    public AbstractGanttChart getGanttChart() {
        return this.ganttChart;
    }
}

