/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.MessageTable;
import com.dlsc.flexgantt.swing.MessageTableModel;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JScrollPane;

public class MessageDialog
extends JDialog {
    private MessageTable table;
    private AbstractGanttChart ganttChart;

    public MessageDialog(Frame owner, AbstractGanttChart gc2) {
        super(owner, Messages.getString("MessageDialog.TITLE"));
        this.setGanttChart(gc2);
    }

    public MessageDialog(Dialog owner, AbstractGanttChart gc2) {
        super(owner, Messages.getString("MessageDialog.TITLE"));
        this.setGanttChart(gc2);
    }

    private void setGanttChart(AbstractGanttChart gc2) {
        if (gc2 == null) {
            throw new IllegalArgumentException("gantt chart can not be NULL");
        }
        this.ganttChart = gc2;
        this.setModal(false);
        this.setLayout(new BorderLayout());
        this.table = new MessageTable(gc2, new MessageTableModel(gc2));
        this.table.setAutoResizeMode(3);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.getViewport().setBackground(Color.WHITE);
        this.add((Component)scroll, "Center");
        this.pack();
    }

    public AbstractGanttChart getGanttChart() {
        return this.ganttChart;
    }

    public MessageTable getTable() {
        return this.table;
    }
}

