/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.treetable.DefaultColumnModel;
import com.dlsc.flexgantt.model.treetable.IColumnModel;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.DefaultComponentFactory;
import com.dlsc.flexgantt.swing.DualGanttChartActionMap;
import com.dlsc.flexgantt.swing.DualGanttChartInputMap;
import com.dlsc.flexgantt.swing.IComponentFactory;
import com.dlsc.flexgantt.swing.IGridComponent;
import com.dlsc.flexgantt.swing.MessageTypeId;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.LayerContainerRowHeader;
import com.dlsc.flexgantt.swing.layer.LayerContainerScrollPane;
import com.dlsc.flexgantt.swing.print.IPrintManager;
import com.dlsc.flexgantt.swing.print.PrintContext;
import com.dlsc.flexgantt.swing.print.PrintGanttChart;
import com.dlsc.flexgantt.swing.print.PrintSetup;
import com.dlsc.flexgantt.swing.print.TimeGranularityPrintManager;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableRowHeader;
import com.dlsc.flexgantt.swing.treetable.TreeTableScrollPane;
import com.dlsc.flexgantt.swing.util.RollOverLabel;
import com.dlsc.flexgantt.swing.util.Simple3DBorder;
import com.dlsc.flexgantt.util.FlexGanttLicenseManager;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class DualGanttChart
extends AbstractGanttChart {
    private static final Logger LOGGER = Logger.getLogger(DualGanttChart.class.getName());
    public static final String PROPERTY_SECONDARY_MODEL = "secondaryModel";
    public static final String PROPERTY_SECONDARY_VISIBLE = "secondaryVisible";
    public static final String PROPERTY_PRIMARY_PRINT_MANAGER = "primaryPrintManager";
    public static final String PROPERTY_SECONDARY_PRINT_MANAGER = "secondaryPrintManager";
    public static final String PROPERTY_VERTICAL_SPLITTER_LOCATION = "verticalSplitterLocation";
    public static final String PROPERTY_HORIZONTAL_SPLITTER_LOCATION = "horizontalSplitterLocation";
    private int splitterSize = 6;
    private IGanttChartModel secondaryModel;
    private TreeTableScrollPane primaryTreeTableScrollPane;
    private TreeTableScrollPane secondaryTreeTableScrollPane;
    private LayerContainerScrollPane primaryLayerContainerScrollPane;
    private LayerContainerScrollPane secondaryLayerContainerScrollPane;
    private TreeTable primaryTreeTable;
    private TreeTableRowHeader primaryTreeTableRowHeader;
    private TreeTable secondaryTreeTable;
    private TreeTableRowHeader secondaryTreeTableRowHeader;
    private LayerContainer primaryLayerContainer;
    private LayerContainer secondaryLayerContainer;
    private JPanel verticalSplitter;
    private JPanel horizontalSplitter;
    private boolean secondaryVisible;
    private boolean secondaryInitialized;
    private double secondaryWeight = 0.33;
    private int horizontalSplitterLocation;
    private int verticalSplitterLocation = 250;
    private int lastGoodHorizontalDividerLocation = -1;
    private IPrintManager primaryPrintManager = new TimeGranularityPrintManager();
    private IPrintManager secondaryPrintManager = new TimeGranularityPrintManager();
    private PrintContext primaryPrintContext;
    private PrintContext secondaryPrintContext;
    private LayerContainerRowHeader secondaryLayerContainerRowHeader;
    private LayerContainerRowHeader primaryLayerContainerRowHeader;
    private AbstractGanttChart.Banner banner;
    private JScrollBar horizontalLayerContainerScrollBar;
    private JScrollBar horizontalTreeTableScrollBar;
    private PrintSetup secondaryPrintSetup;

    public DualGanttChart(IGanttChartModel primaryModel, IGanttChartModel secondaryModel, IColumnModel columnModel, IComponentFactory compFactory) {
        super(primaryModel, columnModel, compFactory);
        this.setName("DualGanttChart");
        this.secondaryModel = secondaryModel;
        this.setBackground(Color.BLACK);
        this.setOpaque(true);
        this.setLayout(new DualGanttChartLayout());
        this.horizontalLayerContainerScrollBar = new JScrollBar(0);
        this.horizontalTreeTableScrollBar = new JScrollBar(0);
        this.primaryTreeTable = compFactory.createTreeTable(this, primaryModel);
        this.primaryTreeTable.setName("PrimaryTreeTable");
        this.secondaryTreeTable = compFactory.createTreeTable(this, secondaryModel);
        this.secondaryTreeTable.setName("SecondaryTreeTable");
        this.primaryLayerContainer = compFactory.createLayerContainer(this, this.primaryTreeTable, primaryModel);
        this.primaryLayerContainer.setName("PrimaryLayerContainer");
        this.secondaryLayerContainer = compFactory.createLayerContainer(this, this.secondaryTreeTable, secondaryModel);
        this.secondaryLayerContainer.setName("SecondaryLayerContainer");
        this.primaryTreeTableScrollPane = this.createTreeTableScrollPane(true, primaryModel, this.primaryTreeTable);
        this.primaryTreeTableScrollPane.setHorizontalScrollBar(this.horizontalTreeTableScrollBar);
        this.primaryTreeTableScrollPane.setName("PrimaryTreeTableScrollPane");
        this.add(this.primaryTreeTableScrollPane);
        this.secondaryTreeTableScrollPane = this.createTreeTableScrollPane(false, secondaryModel, this.secondaryTreeTable);
        this.secondaryTreeTableScrollPane.setName("SecondaryTreeTableScrollPane");
        this.add(this.secondaryTreeTableScrollPane);
        this.primaryLayerContainerScrollPane = this.createLayerContainerScrollPane(true, this.primaryTreeTableScrollPane, this.primaryLayerContainer);
        this.primaryLayerContainerScrollPane.setName("PrimaryLayerContainerScrollPane");
        this.primaryLayerContainerScrollPane.setHorizontalScrollBar(this.horizontalLayerContainerScrollBar);
        this.add(this.primaryLayerContainerScrollPane);
        this.secondaryLayerContainerScrollPane = this.createLayerContainerScrollPane(false, this.secondaryTreeTableScrollPane, this.secondaryLayerContainer);
        this.secondaryLayerContainerScrollPane.setName("SecondaryLayerContainerScrollPane");
        this.add(this.secondaryLayerContainerScrollPane);
        this.primaryTreeTable = this.primaryTreeTableScrollPane.getTreeTable();
        this.primaryTreeTable.setName("PrimaryTreeTable");
        this.primaryTreeTableRowHeader = this.primaryTreeTableScrollPane.getTreeTableRowHeader();
        this.primaryTreeTableRowHeader.setName("PrimaryRowHeader");
        this.secondaryTreeTable = this.secondaryTreeTableScrollPane.getTreeTable();
        this.secondaryTreeTable.setName("SecondaryTreeTable");
        this.secondaryTreeTableRowHeader = this.secondaryTreeTableScrollPane.getTreeTableRowHeader();
        this.secondaryTreeTableRowHeader.setName("SecondaryRowHeader");
        this.primaryLayerContainer = this.primaryLayerContainerScrollPane.getLayerContainer();
        this.primaryLayerContainerRowHeader = this.primaryLayerContainerScrollPane.getLayerContainerRowHeader();
        this.primaryLayerContainerRowHeader.setName("PrimaryLayerContainerRowHeader");
        this.secondaryLayerContainer = this.secondaryLayerContainerScrollPane.getLayerContainer();
        this.secondaryLayerContainerRowHeader = this.secondaryLayerContainerScrollPane.getLayerContainerRowHeader();
        this.secondaryLayerContainerRowHeader.setName("SecondaryLayerContainerRowHeader");
        this.verticalSplitter = new JPanel();
        this.verticalSplitter.setName("VerticalSplitter");
        this.verticalSplitter.setFocusable(false);
        this.verticalSplitter.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                DualGanttChart.this.requestFocusInWindow();
            }
        });
        this.horizontalSplitter = new JPanel();
        this.horizontalSplitter.setName("HorizontalSplitter");
        this.horizontalSplitter.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                DualGanttChart.this.requestFocusInWindow();
            }
        });
        this.horizontalSplitter.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e2) {
                DualGanttChart.this.setHorizontalSplitterLocation(((DualGanttChart)DualGanttChart.this).horizontalSplitter.getLocation().y);
            }
        });
        this.add(this.verticalSplitter);
        this.add(this.horizontalSplitter);
        this.verticalSplitter.setBorder(new Simple3DBorder());
        this.horizontalSplitter.setBorder(new Simple3DBorder());
        this.verticalSplitter.setCursor(Cursor.getPredefinedCursor(11));
        this.horizontalSplitter.setCursor(Cursor.getPredefinedCursor(9));
        this.verticalSplitter.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() == 2) {
                    int width = ((DualGanttChart)DualGanttChart.this).primaryTreeTableScrollPane.getMinimumSize().width;
                    if (DualGanttChart.this.getVerticalSplitterLocation() == width) {
                        DualGanttChart.this.setVerticalSplitterLocation(DualGanttChart.this.getTreeTableHeader().getPreferredSize().width + ((DualGanttChart)DualGanttChart.this).primaryTreeTableScrollPane.getRowHeader().getPreferredSize().width);
                    } else {
                        DualGanttChart.this.setVerticalSplitterLocation(width);
                    }
                }
            }
        });
        this.updateDividers();
        this.resetToPreferredSizes();
        SplitterListener vListener = new SplitterListener(true);
        SplitterListener hListener = new SplitterListener(false);
        this.verticalSplitter.addMouseListener(vListener);
        this.verticalSplitter.addMouseMotionListener(vListener);
        this.verticalSplitter.setBorder(new SplitterBorder(true));
        this.horizontalSplitter.addMouseListener(hListener);
        this.horizontalSplitter.addMouseMotionListener(hListener);
        this.horizontalSplitter.setBorder(new SplitterBorder(false));
        this.banner = new AbstractGanttChart.Banner(this);
        this.banner.setVisible(false);
        this.add(this.banner);
        if (FlexGanttLicenseManager.isDevelopmentLicense()) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            5.sleep(14400000L);
                        }
                        catch (InterruptedException ex) {
                            LOGGER.throwing(AbstractGanttChart.class.getName(), "Thread.run()", ex);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DualGanttChart.this.banner.setVisible(true);
                            }
                        });
                    }
                }
            };
            thread.setName("DevelopmentLicenseThread");
            thread.start();
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                DualGanttChart.this.showOrHideSecondary(DualGanttChart.this.isSecondaryVisible());
            }
        });
        this.setActionMap(new DualGanttChartActionMap<DualGanttChart>(this));
        this.setInputMap(0, new DualGanttChartInputMap<DualGanttChart>(this));
        this.secondaryPrintSetup = new PrintSetup();
    }

    public DualGanttChart(IGanttChartModel primaryModel, IGanttChartModel secondaryModel, IColumnModel columnModel) {
        this(primaryModel, secondaryModel, columnModel, DefaultComponentFactory.getInstance());
    }

    public DualGanttChart(IGanttChartModel primaryModel, IGanttChartModel secondaryModel, IComponentFactory compFactory) {
        this(primaryModel, secondaryModel, new DefaultColumnModel(), compFactory);
    }

    public DualGanttChart(IGanttChartModel primaryModel, IGanttChartModel secondaryModel) {
        this(primaryModel, secondaryModel, new DefaultColumnModel(), DefaultComponentFactory.getInstance());
    }

    public DualGanttChart(IGanttChartModel model) {
        this(model, model, new DefaultColumnModel(), DefaultComponentFactory.getInstance());
    }

    public DualGanttChart(IColumnModel columnModel) {
        this(new DefaultGanttChartModel(new DefaultGanttChartNode()), new DefaultGanttChartModel(new DefaultGanttChartNode()), columnModel, DefaultComponentFactory.getInstance());
    }

    public DualGanttChart(IComponentFactory compFactory) {
        this(new DefaultGanttChartModel(new DefaultGanttChartNode()), new DefaultGanttChartModel(new DefaultGanttChartNode()), new DefaultColumnModel(), compFactory);
    }

    public DualGanttChart() {
        this(new DefaultGanttChartModel(new DefaultGanttChartNode()), new DefaultGanttChartModel(new DefaultGanttChartNode()));
    }

    public IGanttChartModel getSecondaryModel() {
        return this.secondaryModel;
    }

    public void setSecondaryModel(IGanttChartModel model) {
        if (model == null) {
            throw new IllegalArgumentException("secondary Gantt chart model can not be NULL");
        }
        IGanttChartModel oldModel = this.secondaryModel;
        this.secondaryModel = model;
        this.firePropertyChange(PROPERTY_SECONDARY_MODEL, oldModel, model);
        this.secondaryTreeTable.setModel(model);
        this.secondaryLayerContainer.setModel(model);
    }

    public boolean isSecondaryVisible() {
        return this.secondaryVisible;
    }

    public void setSecondaryVisible(boolean visible) {
        boolean oldValue = this.secondaryVisible;
        this.secondaryVisible = visible;
        this.firePropertyChange(PROPERTY_SECONDARY_VISIBLE, oldValue, this.secondaryVisible);
    }

    private void showOrHideSecondary(boolean visible) {
        if (visible) {
            this.secondaryTreeTableScrollPane.setHorizontalScrollBar(this.horizontalTreeTableScrollBar);
            Point p2 = this.primaryLayerContainerScrollPane.getViewport().getViewPosition();
            this.secondaryLayerContainerScrollPane.getViewport().setViewPosition(new Point(p2.x, 0));
            this.secondaryLayerContainerScrollPane.setHorizontalScrollBar(this.horizontalLayerContainerScrollBar);
            if (!this.secondaryInitialized) {
                int height = this.getSize().height;
                this.setHorizontalSplitterLocation((int)((double)height - this.secondaryWeight * (double)height));
                this.secondaryInitialized = true;
            } else if (this.lastGoodHorizontalDividerLocation != -1) {
                this.setHorizontalSplitterLocation(this.lastGoodHorizontalDividerLocation);
                this.lastGoodHorizontalDividerLocation = -1;
            }
        } else {
            this.primaryTreeTableScrollPane.setHorizontalScrollBarPolicy(32);
            this.primaryTreeTableScrollPane.setHorizontalScrollBar(this.horizontalTreeTableScrollBar);
            this.primaryLayerContainerScrollPane.setHorizontalScrollBarPolicy(32);
            this.primaryLayerContainerScrollPane.setHorizontalScrollBar(this.horizontalLayerContainerScrollBar);
        }
        this.primaryLayerContainerScrollPane.invalidate();
        this.secondaryTreeTableScrollPane.setVisible(visible);
        this.secondaryLayerContainerScrollPane.setVisible(visible);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public double getSecondaryWeight() {
        return this.secondaryWeight;
    }

    public void setSecondaryWeight(double weight) {
        if (weight < 0.0) {
            throw new IllegalArgumentException("weight can not be smaller than 0");
        }
        if (weight > 1.0) {
            throw new IllegalArgumentException("weight can not be larger than 1");
        }
        this.secondaryWeight = weight;
    }

    @Override
    public TreeTable[] getTreeTables() {
        return new TreeTable[]{this.primaryTreeTable, this.secondaryTreeTable};
    }

    @Override
    public LayerContainer[] getLayerContainers() {
        return new LayerContainer[]{this.primaryLayerContainer, this.secondaryLayerContainer};
    }

    public LayerContainer getPrimaryLayerContainer() {
        return this.primaryLayerContainer;
    }

    public LayerContainerRowHeader getPrimaryLayerContainerRowHeader() {
        return this.primaryLayerContainerRowHeader;
    }

    public LayerContainerScrollPane getPrimaryLayerContainerScrollPane() {
        return this.primaryLayerContainerScrollPane;
    }

    public TreeTable getPrimaryTreeTable() {
        return this.primaryTreeTable;
    }

    public TreeTableScrollPane getPrimaryTreeTableScrollPane() {
        return this.primaryTreeTableScrollPane;
    }

    public TreeTableRowHeader getPrimaryTreeTableRowHeader() {
        return this.primaryTreeTableRowHeader;
    }

    public LayerContainer getSecondaryLayerContainer() {
        return this.secondaryLayerContainer;
    }

    public LayerContainerRowHeader getSecondaryLayerContainerRowHeader() {
        return this.secondaryLayerContainerRowHeader;
    }

    public LayerContainerScrollPane getSecondaryLayerContainerScrollPane() {
        return this.secondaryLayerContainerScrollPane;
    }

    public TreeTable getSecondaryTreeTable() {
        return this.secondaryTreeTable;
    }

    public TreeTableScrollPane getSecondaryTreeTableScrollPane() {
        return this.secondaryTreeTableScrollPane;
    }

    public TreeTableRowHeader getSecondaryTreeTableRowHeader() {
        return this.secondaryTreeTableRowHeader;
    }

    protected TreeTableScrollPane createTreeTableScrollPane(boolean primary, IGanttChartModel model, TreeTable table) {
        TreeTableRowHeader treeTableRowHeader = this.getComponentFactory().createTreeTableRowHeader(table);
        TreeTableScrollPane sp = this.getComponentFactory().createTreeTableScrollPane(table, treeTableRowHeader, this.getTreeTableHeader(), primary);
        return sp;
    }

    protected LayerContainerScrollPane createLayerContainerScrollPane(boolean primary, TreeTableScrollPane tableScrollPane, LayerContainer lc2) {
        lc2.setPrimary(primary);
        LayerContainerRowHeader rowHeader = this.getComponentFactory().createLayerContainerRowHeader(lc2);
        LayerContainerScrollPane sp = this.getComponentFactory().createLayerContainerScrollPane(lc2, rowHeader, this.getTimeline(), primary);
        sp.getVerticalScrollBar().setModel(tableScrollPane.getVerticalScrollBar().getModel());
        if (primary) {
            sp.setCorner("LOWER_RIGHT_CORNER", new SplitterButton(true));
        } else {
            sp.setCorner("LOWER_RIGHT_CORNER", new SplitterButton(false));
        }
        return sp;
    }

    public int getVerticalSplitterLocation() {
        return this.verticalSplitterLocation;
    }

    public void setVerticalSplitterLocation(int location) {
        location = Math.max(location, this.primaryTreeTableScrollPane.getMinimumSize().width);
        int oldLocation = this.verticalSplitterLocation;
        this.verticalSplitterLocation = location;
        this.verticalSplitter.invalidate();
        this.validate();
        this.firePropertyChange(PROPERTY_VERTICAL_SPLITTER_LOCATION, oldLocation, location);
    }

    public int getHorizontalSplitterLocation() {
        return this.horizontalSplitterLocation;
    }

    public void setHorizontalSplitterLocation(int location) {
        location = Math.max(location, this.primaryLayerContainerScrollPane.getMinimumSize().height);
        int oldLocation = this.horizontalSplitterLocation;
        this.horizontalSplitter.invalidate();
        this.horizontalSplitterLocation = location;
        this.validate();
        this.firePropertyChange(PROPERTY_HORIZONTAL_SPLITTER_LOCATION, oldLocation, location);
    }

    @Override
    public void resetToPreferredSizes() {
        this.setVerticalSplitterLocation(Math.max(this.primaryTreeTableScrollPane.getPreferredSize().width, this.secondaryTreeTableScrollPane.getPreferredSize().width));
    }

    public int getSplitterSize() {
        return this.splitterSize;
    }

    public void setSplitterSize(int size) {
        this.splitterSize = size;
        this.updateDividers();
    }

    private void updateDividers() {
        this.verticalSplitter.setPreferredSize(new Dimension(this.splitterSize, 10));
        this.horizontalSplitter.setPreferredSize(new Dimension(10, this.splitterSize));
        this.invalidate();
        this.validate();
    }

    public JComponent getVerticalSplitter() {
        return this.verticalSplitter;
    }

    public JComponent getHorizontalSplitter() {
        return this.horizontalSplitter;
    }

    @Override
    public PrintContext[] getPrintContexts() {
        if (this.primaryPrintContext == null) {
            this.primaryPrintContext = new PrintContext();
            this.primaryPrintContext.setGanttChart(this);
            this.primaryPrintContext.setLayerContainer(this.primaryLayerContainer);
            this.primaryPrintContext.setTreeTable(this.primaryTreeTable);
            this.primaryPrintContext.setTreeTableHeader(this.getTreeTableHeader());
            this.primaryPrintContext.setRowHeader(this.primaryTreeTableRowHeader);
            this.primaryPrintContext.setTimeline(this.getTimeline());
            this.primaryPrintContext.setTimeSpan(this.getTimeSpan());
            this.primaryPrintContext.setPrintSetup(this.getPrintSetup());
        }
        if (this.secondaryPrintContext == null) {
            this.secondaryPrintContext = new PrintContext();
            this.secondaryPrintContext.setGanttChart(this);
            this.secondaryPrintContext.setLayerContainer(this.secondaryLayerContainer);
            this.secondaryPrintContext.setTreeTable(this.secondaryTreeTable);
            this.secondaryPrintContext.setTreeTableHeader(this.getTreeTableHeader());
            this.secondaryPrintContext.setRowHeader(this.secondaryTreeTableRowHeader);
            this.secondaryPrintContext.setTimeline(this.getTimeline());
            this.secondaryPrintContext.setTimeSpan(this.getTimeSpan());
            this.secondaryPrintContext.setPrintSetup(this.getSecondaryPrintSetup());
        }
        return new PrintContext[]{this.primaryPrintContext, this.secondaryPrintContext};
    }

    @Override
    public void print(boolean preview) {
        if (this.primaryPrintContext != null) {
            this.print(preview, this.primaryPrintContext.getTimeSpan());
        } else {
            super.print(preview);
        }
    }

    @Override
    public void print(boolean preview, ITimeSpan span) {
        if (this.primaryPrintContext == null || !span.equals(this.primaryPrintContext.getTimeSpan())) {
            this.primaryPrintContext = new PrintContext();
            this.primaryPrintContext.setGanttChart(this);
            this.primaryPrintContext.setLayerContainer(this.primaryLayerContainer);
            this.primaryPrintContext.setTreeTable(this.primaryTreeTable);
            this.primaryPrintContext.setTreeTableHeader(this.getTreeTableHeader());
            this.primaryPrintContext.setRowHeader(this.primaryTreeTableRowHeader);
            this.primaryPrintContext.setTimeline(this.getTimeline());
            this.primaryPrintContext.setTimeSpan(span);
            this.primaryPrintContext.setPrintSetup(this.getPrintSetup());
        }
        try {
            this.primaryPrintManager.print(this, this.primaryPrintContext, preview);
        }
        catch (Exception ex) {
            LOGGER.throwing(this.getClass().getName(), "print(boolean, ITimeSpan)", ex);
            this.showMessage(Messages.getString("DualGanttChart.PRINT_REQUEST_FAILED"), MessageTypeId.ERROR, ex);
        }
    }

    public void printSecondaryModel(boolean preview) {
        if (this.secondaryPrintContext != null) {
            this.printSecondaryModel(preview, this.secondaryPrintContext.getTimeSpan());
        } else {
            this.printSecondaryModel(preview, this.getTimeSpan());
        }
    }

    public void printSecondaryModel(boolean preview, ITimeSpan span) {
        if (this.secondaryPrintContext == null || !span.equals(this.secondaryPrintContext.getTimeSpan())) {
            this.secondaryPrintContext = new PrintContext();
            this.secondaryPrintContext.setGanttChart(this);
            this.secondaryPrintContext.setLayerContainer(this.secondaryLayerContainer);
            this.secondaryPrintContext.setTreeTable(this.secondaryTreeTable);
            this.secondaryPrintContext.setTreeTableHeader(this.getTreeTableHeader());
            this.secondaryPrintContext.setRowHeader(this.secondaryTreeTableRowHeader);
            this.secondaryPrintContext.setTimeline(this.getTimeline());
            this.secondaryPrintContext.setTimeSpan(span);
            this.secondaryPrintContext.setPrintSetup(this.getSecondaryPrintSetup());
        }
        try {
            this.secondaryPrintManager.print(this, this.secondaryPrintContext, preview);
        }
        catch (Exception ex) {
            LOGGER.throwing(this.getClass().getName(), "print(boolean, ITimeSpan)", ex);
            this.showMessage(Messages.getString("DualGanttChart.PRINT_REQUEST_FAILED"), MessageTypeId.ERROR, ex);
        }
    }

    protected int getFixedHorizonalSplitterLocation(int location) {
        int topGap = this.primaryLayerContainerScrollPane.getMinimumSize().height;
        if (this.banner.isVisible()) {
            topGap += this.banner.getPreferredSize().height;
        }
        int result = Math.max(topGap, location);
        result = Math.min(this.getSize().height - this.splitterSize - this.secondaryLayerContainerScrollPane.getMinimumSize().height, result);
        return result;
    }

    protected int getFixedVerticalSplitterLocation(int location) {
        int result = Math.max(this.primaryTreeTableScrollPane.getMinimumSize().width, location);
        result = Math.min(this.getSize().width - this.splitterSize - this.primaryLayerContainerScrollPane.getMinimumSize().width, result);
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getSource().equals(this)) {
            if (evt.getPropertyName().equals(PROPERTY_SECONDARY_MODEL)) {
                try {
                    this.getDatelineModel().setTimeSpan(this.getTimeSpan());
                }
                catch (DatelineModelException ex) {
                    LOGGER.throwing(this.getClass().getName(), "propertyChanged()", ex);
                }
            } else if (evt.getPropertyName().equals(PROPERTY_SECONDARY_VISIBLE) && this.isShowing()) {
                this.showOrHideSecondary(this.isSecondaryVisible());
            }
        }
    }

    public IPrintManager getPrimaryPrintManager() {
        return this.primaryPrintManager;
    }

    public void setPrimaryPrintManager(IPrintManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("print manager can not be NULL");
        }
        IPrintManager oldManager = this.primaryPrintManager;
        this.primaryPrintManager = manager;
        this.firePropertyChange(PROPERTY_PRIMARY_PRINT_MANAGER, oldManager, this.primaryPrintManager);
    }

    public IPrintManager getSecondaryPrintManager() {
        return this.secondaryPrintManager;
    }

    public void setSecondaryPrintManager(IPrintManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("print manager can not be NULL");
        }
        IPrintManager oldManager = this.secondaryPrintManager;
        this.secondaryPrintManager = manager;
        this.firePropertyChange(PROPERTY_SECONDARY_PRINT_MANAGER, oldManager, this.secondaryPrintManager);
    }

    @Override
    public LayerContainerScrollPane[] getLayerContainerScrollPanes() {
        return new LayerContainerScrollPane[]{this.primaryLayerContainerScrollPane, this.secondaryLayerContainerScrollPane};
    }

    @Override
    public IGridComponent[] getGridComponents() {
        return new IGridComponent[]{this.primaryLayerContainer, this.secondaryLayerContainer, this.getEventline()};
    }

    @Override
    public TreeTableScrollPane[] getTreeTableScrollPanes() {
        return new TreeTableScrollPane[]{this.primaryTreeTableScrollPane, this.secondaryTreeTableScrollPane};
    }

    @Override
    public void setModel(IGanttChartModel model) {
        super.setModel(model);
        if (this.primaryTreeTable != null) {
            this.primaryTreeTable.setModel(model);
            this.primaryLayerContainer.setModel(model);
        }
    }

    public JScrollBar getHorizontalLayerContainerScrollBar() {
        return this.horizontalLayerContainerScrollBar;
    }

    public JScrollBar getHorizontalTreeTableScrollBar() {
        return this.horizontalTreeTableScrollBar;
    }

    public void setSecondaryPrintSetup(PrintSetup ps) {
        this.secondaryPrintSetup = ps;
    }

    public PrintSetup getSecondaryPrintSetup() {
        return this.secondaryPrintSetup;
    }

    @Override
    public void tearDown() {
        PrintGanttChart gc2;
        IPrintManager mgr = this.getPrimaryPrintManager();
        if (mgr != null && (gc2 = mgr.getPrintGanttChart()) != null) {
            gc2.tearDown();
        }
        if ((mgr = this.getSecondaryPrintManager()) != null && (gc2 = mgr.getPrintGanttChart()) != null) {
            gc2.tearDown();
        }
        super.tearDown();
    }

    class SplitterButton
    extends RollOverLabel {
        public SplitterButton(final boolean split) {
            super("");
            if (split) {
                this.setIcon(IconRegistry.getIcon(IconId.SPLIT_GANTT_CHART_SMALL));
            } else {
                this.setIcon(IconRegistry.getIcon(IconId.UNSPLIT_GANTT_CHART_SMALL));
            }
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    DualGanttChart.this.setSecondaryVisible(split);
                }
            });
            this.setBorder(new Simple3DBorder());
        }
    }

    class SplitterBorder
    implements Border {
        private final Insets INSETS = new Insets(1, 1, 1, 1);
        private boolean vertical;

        public SplitterBorder(boolean vertical) {
            this.vertical = vertical;
        }

        @Override
        public Insets getBorderInsets(Component c2) {
            return this.INSETS;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            if (this.vertical) {
                int hy = DualGanttChart.this.getHorizontalSplitterLocation();
                int gap = 0;
                if (DualGanttChart.this.isSecondaryVisible()) {
                    gap = DualGanttChart.this.splitterSize;
                }
                g2.setColor(c2.getBackground().brighter());
                g2.drawLine(x2, y2, x2, hy);
                g2.drawLine(x2, hy + gap, x2, y2 + height - 1);
                g2.setColor(c2.getBackground().darker());
                g2.drawLine(x2 + width - 1, y2, x2 + width - 1, hy);
                g2.drawLine(x2 + width - 1, hy + gap, x2 + width - 1, y2 + height - 1);
            } else {
                g2.setColor(c2.getBackground().brighter());
                g2.drawLine(x2, y2, x2 + width - 1, y2);
                g2.setColor(c2.getBackground().darker());
                g2.drawLine(x2, y2 + height - 1, x2 + width - 1, y2 + height - 1);
            }
        }
    }

    class SplitterListener
    extends MouseInputAdapter {
        private boolean vertical;
        private int start;

        protected SplitterListener(boolean vertical) {
            this.vertical = vertical;
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (this.vertical) {
                this.start = e2.getX();
            } else {
                this.start = e2.getY();
                if (!this.isTopPosition()) {
                    DualGanttChart.this.lastGoodHorizontalDividerLocation = DualGanttChart.this.horizontalSplitterLocation;
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (!this.vertical && e2.getClickCount() == 2) {
                if (this.isTopPosition()) {
                    DualGanttChart.this.setHorizontalSplitterLocation(DualGanttChart.this.getFixedHorizonalSplitterLocation(DualGanttChart.this.lastGoodHorizontalDividerLocation));
                } else {
                    DualGanttChart.this.lastGoodHorizontalDividerLocation = DualGanttChart.this.horizontalSplitterLocation;
                    DualGanttChart.this.setHorizontalSplitterLocation(DualGanttChart.this.getFixedHorizonalSplitterLocation(0));
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            if (this.vertical) {
                int delta = e2.getX() - this.start;
                LOGGER.fine("start = " + this.start + " x = " + e2.getX() + " delta = " + delta);
                int newLocation = DualGanttChart.this.getVerticalSplitterLocation() + delta;
                newLocation = DualGanttChart.this.getFixedVerticalSplitterLocation(newLocation);
                DualGanttChart.this.setVerticalSplitterLocation(newLocation);
            } else {
                int delta = e2.getY() - this.start;
                LOGGER.fine("start = " + this.start + " y = " + e2.getY() + " delta = " + delta);
                int newLocation = DualGanttChart.this.getHorizontalSplitterLocation() + delta;
                newLocation = DualGanttChart.this.getFixedHorizonalSplitterLocation(newLocation);
                DualGanttChart.this.setHorizontalSplitterLocation(newLocation);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (!this.vertical) {
                if (this.isBottomPosition()) {
                    DualGanttChart.this.setSecondaryVisible(false);
                } else if (!this.isTopPosition()) {
                    DualGanttChart.this.lastGoodHorizontalDividerLocation = -1;
                }
            }
        }

        private boolean isTopPosition() {
            int min;
            int loc = DualGanttChart.this.getHorizontalSplitterLocation();
            return loc == (min = ((DualGanttChart)DualGanttChart.this).primaryLayerContainerScrollPane.getMinimumSize().height);
        }

        private boolean isBottomPosition() {
            int min;
            int loc = DualGanttChart.this.getHorizontalSplitterLocation();
            return loc == (min = DualGanttChart.this.getHeight() - ((DualGanttChart)DualGanttChart.this).secondaryLayerContainerScrollPane.getMinimumSize().height - DualGanttChart.this.splitterSize);
        }
    }

    class DualGanttChartLayout
    implements LayoutManager {
        DualGanttChartLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension priDimT = DualGanttChart.this.primaryTreeTableScrollPane.getPreferredSize();
            Dimension secDimT = DualGanttChart.this.secondaryTreeTableScrollPane.getPreferredSize();
            Dimension priDimL = DualGanttChart.this.primaryLayerContainerScrollPane.getPreferredSize();
            Dimension secDimL = DualGanttChart.this.secondaryLayerContainerScrollPane.getPreferredSize();
            int width = priDimT.width + DualGanttChart.this.splitterSize + priDimL.width;
            int height = priDimT.height;
            if (DualGanttChart.this.secondaryVisible) {
                width = Math.max(width, secDimT.width + DualGanttChart.this.splitterSize + secDimL.width);
                height += DualGanttChart.this.splitterSize + secDimT.height;
            }
            if (DualGanttChart.this.banner.isVisible()) {
                height += ((DualGanttChart)DualGanttChart.this).banner.getPreferredSize().height;
            }
            return new Dimension(width, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension priDimT = DualGanttChart.this.primaryTreeTableScrollPane.getMinimumSize();
            Dimension secDimT = DualGanttChart.this.secondaryTreeTableScrollPane.getMinimumSize();
            Dimension priDimL = DualGanttChart.this.primaryLayerContainerScrollPane.getMinimumSize();
            Dimension secDimL = DualGanttChart.this.secondaryLayerContainerScrollPane.getMinimumSize();
            int width = priDimT.width + DualGanttChart.this.splitterSize + priDimL.width;
            int height = priDimT.height;
            if (DualGanttChart.this.secondaryVisible) {
                width = Math.max(width, secDimT.width + DualGanttChart.this.splitterSize + secDimL.width);
                height += DualGanttChart.this.splitterSize + secDimT.height;
            }
            if (DualGanttChart.this.banner.isVisible()) {
                height += ((DualGanttChart)DualGanttChart.this).banner.getMinimumSize().height;
            }
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container parent) {
            int hdl = DualGanttChart.this.getHorizontalSplitterLocation();
            int vdl = DualGanttChart.this.getVerticalSplitterLocation();
            int horizontalDividerLocation = DualGanttChart.this.getFixedHorizonalSplitterLocation(hdl);
            int verticalDividerLocation = DualGanttChart.this.getFixedVerticalSplitterLocation(vdl);
            int parentWidth = parent.getWidth();
            Insets insets = parent.getInsets();
            if (DualGanttChart.this.banner.isVisible()) {
                Dimension bannerDim = DualGanttChart.this.banner.getPreferredSize();
                DualGanttChart.this.banner.setBounds(insets.left, insets.top, parentWidth - insets.left - insets.right, bannerDim.height);
                insets.top += bannerDim.height;
            }
            int height = horizontalDividerLocation - insets.top;
            int parentHeight = parent.getHeight();
            if (!DualGanttChart.this.secondaryVisible) {
                height = parentHeight - insets.top - insets.bottom;
            }
            DualGanttChart.this.primaryTreeTableScrollPane.setBounds(insets.left, insets.top, verticalDividerLocation - insets.left, height);
            DualGanttChart.this.primaryLayerContainerScrollPane.setBounds(verticalDividerLocation + DualGanttChart.this.splitterSize, insets.top, parentWidth - (verticalDividerLocation + DualGanttChart.this.splitterSize) - insets.right, height);
            DualGanttChart.this.verticalSplitter.setBounds(verticalDividerLocation, insets.top, DualGanttChart.this.splitterSize, parentHeight - insets.top - insets.bottom);
            if (DualGanttChart.this.secondaryVisible) {
                DualGanttChart.this.horizontalSplitter.setBounds(insets.left, horizontalDividerLocation, parentWidth - insets.left - insets.right, DualGanttChart.this.splitterSize);
                DualGanttChart.this.secondaryTreeTableScrollPane.setBounds(insets.left, horizontalDividerLocation + DualGanttChart.this.splitterSize, verticalDividerLocation - insets.left, parentHeight - horizontalDividerLocation - DualGanttChart.this.splitterSize - insets.bottom);
                DualGanttChart.this.secondaryLayerContainerScrollPane.setBounds(verticalDividerLocation + DualGanttChart.this.splitterSize, horizontalDividerLocation + DualGanttChart.this.splitterSize, parentWidth - (verticalDividerLocation + DualGanttChart.this.splitterSize) - insets.right, parentHeight - horizontalDividerLocation - DualGanttChart.this.splitterSize - insets.bottom);
            }
        }
    }
}

