/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.util;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.calendar.TimeGranularityCalendarModel;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.model.eventline.DefaultEventlineModel;
import com.dlsc.flexgantt.model.eventline.IEventlineModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.Layer;
import com.dlsc.flexgantt.model.treetable.DefaultColumnModel;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.showcase.util.TimeSpanDialog;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.Message;
import com.dlsc.flexgantt.swing.MessageTypeId;
import com.dlsc.flexgantt.swing.action.gantt.RedoActionLabeled;
import com.dlsc.flexgantt.swing.action.gantt.UndoActionLabeled;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.LayerContainerScrollPane;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;

public abstract class AbstractTestMenuBar<T extends AbstractGanttChart>
extends JMenuBar {
    protected T ganttChart;
    private TimeSpanDialog timeSpanDialog;

    public AbstractTestMenuBar(T ganttChart) {
        this.ganttChart = ganttChart;
        JMenu fileMenu = new JMenu("File");
        JMenu editMenu = new JMenu("Edit");
        JMenu ganttModelMenu = new JMenu("Gantt");
        JMenu treeTableModelMenu = new JMenu("Table");
        JMenu columnModelMenu = new JMenu("Columns");
        JMenu datelineModelMenu = new JMenu("Dateline");
        JMenu eventlineModelMenu = new JMenu("Eventline");
        JMenu calendarModelMenu = new JMenu("Calendar");
        JMenu lafMenu = new JMenu("View");
        JMenu perfMenu = new JMenu("Performance");
        JMenu modelMenu = new JMenu("Models");
        modelMenu.add(ganttModelMenu);
        modelMenu.add(treeTableModelMenu);
        modelMenu.add(columnModelMenu);
        modelMenu.add(datelineModelMenu);
        modelMenu.add(eventlineModelMenu);
        modelMenu.add(calendarModelMenu);
        JMenu debugMenu = new JMenu("Debug");
        JMenu timelineMenu = new JMenu("Timeline");
        JMenu tableMenu = new JMenu("Table");
        JMenu ganttMenu = new JMenu("Gantt");
        JMenu layersMenu = new JMenu("Layers");
        this.fillFileMenu(fileMenu);
        this.fillEditMenu(editMenu);
        this.fillGanttModelMenu(ganttModelMenu);
        this.fillTreeTableModelMenu(treeTableModelMenu);
        this.fillColumnModelMenu(columnModelMenu);
        this.fillEventlineModelMenu(datelineModelMenu, ((AbstractGanttChart)ganttChart).getTimeline().getEventline().getModel());
        this.fillCalendarModelMenu(calendarModelMenu);
        this.fillTableMenu(tableMenu);
        this.fillTimelineMenu(timelineMenu, ((AbstractGanttChart)ganttChart).getTimeline());
        this.fillGanttMenu(ganttMenu);
        this.fillLayersMenu(layersMenu);
        this.fillDebugMenu(debugMenu);
        this.fillLookAndFeelMenu(lafMenu);
        this.fillPerformanceMenu(perfMenu);
        this.fillEventlineModelMenu(eventlineModelMenu);
        this.add(fileMenu);
        this.add(editMenu);
        this.add(modelMenu);
        this.add(tableMenu);
        this.add(timelineMenu);
        this.add(ganttMenu);
        this.add(layersMenu);
        this.add(lafMenu);
        this.add(debugMenu);
        this.add(perfMenu);
    }

    public T getGanttChart() {
        return this.ganttChart;
    }

    protected abstract TreeTable getTreeTable();

    protected abstract TreeTableScrollPane getTreeTableScrollPane();

    protected abstract LayerContainer getLayerContainer();

    protected abstract LayerContainerScrollPane getLayerContainerScrollPane();

    protected abstract DefaultGanttChartModel getModel();

    protected abstract void setGrid(TimeGranularity var1);

    protected JMenuItem[] getFileMenuItems() {
        return null;
    }

    private void fillColumnModelMenu(JMenu columnModelMenu) {
        JMenuItem addColumn = new JMenuItem("Add Column");
        columnModelMenu.add(addColumn);
        addColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String name = JOptionPane.showInputDialog(AbstractTestMenuBar.this.ganttChart, "Enter Name", "Add Column", -1);
                TreeTableColumn column = new TreeTableColumn(name, String.class);
                column.setWidth(30);
                ((DefaultColumnModel)((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).getColumnModel()).addColumn(column);
            }
        });
        JMenuItem removeColumn = new JMenuItem("Remove Column");
        columnModelMenu.add(removeColumn);
        removeColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DefaultColumnModel model = (DefaultColumnModel)((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).getColumnModel();
                int count = model.getColumnCount();
                Object[] columns = new TreeTableColumn[count];
                for (int i2 = 0; i2 < count; ++i2) {
                    columns[i2] = model.getColumn(i2);
                }
                TreeTableColumn initialValue = columns[0];
                Object selection = JOptionPane.showInputDialog(AbstractTestMenuBar.this.ganttChart, "Select column to remove", "Remove Column", 3, null, columns, initialValue);
                if (selection != null) {
                    model.removeColumn((TreeTableColumn)selection);
                }
            }
        });
    }

    private void fillCalendarModelMenu(JMenu calendarModelMenu) {
        JMenuItem weekendDays = new JMenuItem("Set Weekend Days");
        calendarModelMenu.add(weekendDays);
        weekendDays.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractTestMenuBar.this.setWeekendDays();
            }
        });
    }

    private void fillDebugMenu(JMenu debugMenu) {
        String[] props = new String[]{"com.dlsc.flexgantt.debug.columnbounds", "com.dlsc.flexgantt.debug.objectbounds", "com.dlsc.flexgantt.debug.objectinsets", "com.dlsc.flexgantt.debug.relationshipbounds", "com.dlsc.flexgantt.debug.rowrenderer", "com.dlsc.flexgantt.debug.layernames"};
        final LinkedList<JCheckBoxMenuItem> propsItems = new LinkedList<JCheckBoxMenuItem>();
        JMenuItem all = new JMenuItem("All Debug Properties On");
        all.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                for (JCheckBoxMenuItem ci : propsItems) {
                    if (ci.isSelected()) continue;
                    ci.doClick();
                }
            }
        });
        debugMenu.add(all);
        JMenuItem none = new JMenuItem("All Debug Properties Off");
        none.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                for (JCheckBoxMenuItem ci : propsItems) {
                    if (!ci.isSelected()) continue;
                    ci.doClick();
                }
            }
        });
        debugMenu.add(none);
        SecurityManager sm = System.getSecurityManager();
        try {
            if (sm != null) {
                sm.checkPropertyAccess("swing.aatext");
            }
            debugMenu.addSeparator();
            for (int i2 = 0; i2 < props.length; ++i2) {
                final String p2 = props[i2];
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(p2);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        System.setProperty(p2, Boolean.toString(!Boolean.getBoolean(p2)));
                        ((Component)AbstractTestMenuBar.this.ganttChart).repaint();
                    }
                });
                item.setSelected(Boolean.getBoolean(p2));
                propsItems.add(item);
                debugMenu.add(item);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private void fillEditMenu(JMenu editMenu) {
        UndoActionLabeled<T> undoAction = new UndoActionLabeled<T>(this.ganttChart);
        undoAction.setGanttChart(this.ganttChart);
        RedoActionLabeled<T> redoAction = new RedoActionLabeled<T>(this.ganttChart);
        redoAction.setGanttChart(this.ganttChart);
        JMenuItem undo = new JMenuItem(undoAction);
        editMenu.add(undo);
        JMenuItem redo = new JMenuItem(redoAction);
        editMenu.add(redo);
        editMenu.addSeparator();
        JMenu gridMenu = new JMenu("Grid", true);
        ButtonGroup group = new ButtonGroup();
        for (TimeGranularity tg : TimeGranularity.values()) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(tg.name());
            group.add(item);
            gridMenu.add(item);
            final TimeGranularity ftg = tg;
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    AbstractTestMenuBar.this.setGrid(ftg);
                }
            });
        }
        editMenu.add(gridMenu);
    }

    private void fillEventlineModelMenu(JMenu datelineModel, IEventlineModel model) {
    }

    private void fillFileMenu(JMenu fileMenu) {
        JMenuItem[] items = this.getFileMenuItems();
        if (items != null) {
            for (JMenuItem item : items) {
                fileMenu.add(item);
            }
            fileMenu.addSeparator();
        }
        JMenuItem quit = new JMenuItem("Quit");
        fileMenu.add(quit);
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                System.exit(0);
            }
        });
        quit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
    }

    private void fillLayersMenu(JMenu layersMenu) {
        JMenu relationshipMenu = new JMenu("Relationship");
        layersMenu.add(relationshipMenu);
        layersMenu.addSeparator();
        Iterator<ILayer> iter = ((AbstractGanttChart)this.ganttChart).getModel().getLayers();
        final LayerContainer lc2 = this.getLayerContainer();
        while (iter.hasNext()) {
            ILayer l2 = iter.next();
            if (l2 == null) continue;
            final JCheckBoxMenuItem showSpreadsheet = new JCheckBoxMenuItem(l2.getName());
            showSpreadsheet.setSelected(lc2.getTimelineObjectLayer(l2).isVisible());
            layersMenu.add(showSpreadsheet);
            final ILayer fs = l2;
            showSpreadsheet.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    lc2.getTimelineObjectLayer(fs).setVisible(!lc2.getTimelineObjectLayer(fs).isVisible());
                    showSpreadsheet.setSelected(lc2.getTimelineObjectLayer(fs).isVisible());
                }
            });
        }
    }

    private void fillPerformanceMenu(JMenu perfMenu) {
        int count = 100;
        JMenuItem repaintTimeline = new JMenuItem("Repaint Timeline 100 times");
        perfMenu.add(repaintTimeline);
        repaintTimeline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        Timeline timeline = ((AbstractGanttChart)AbstractTestMenuBar.this.getGanttChart()).getTimeline();
                        Rectangle rect = timeline.getBounds();
                        long millis = System.currentTimeMillis();
                        for (int i2 = 0; i2 < 100; ++i2) {
                            if (i2 % 10 == 0 && i2 != 0) {
                                System.out.println("count = " + i2);
                            }
                            timeline.paintImmediately(rect);
                            try {
                                1.sleep(100L);
                                continue;
                            }
                            catch (InterruptedException e2) {
                                e2.printStackTrace();
                            }
                        }
                        System.out.println("duration = " + (System.currentTimeMillis() - millis));
                    }
                };
                thread.start();
            }
        });
        JMenu scrollMenu = new JMenu("Scroll Mode");
        final JCheckBoxMenuItem scrollSimple = new JCheckBoxMenuItem("SIMPLE_SCROLL_MODE", this.getLayerContainerScrollPane().getViewport().getScrollMode() == 0);
        scrollMenu.add(scrollSimple);
        scrollSimple.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractTestMenuBar.this.getLayerContainerScrollPane().getViewport().setScrollMode(0);
                scrollSimple.setSelected(AbstractTestMenuBar.this.getLayerContainerScrollPane().getViewport().getScrollMode() == 0);
            }
        });
        final JCheckBoxMenuItem scrollBackingstore = new JCheckBoxMenuItem("BACKINGSTORE_SCROLL_MODE", this.getLayerContainerScrollPane().getViewport().getScrollMode() == 2);
        scrollMenu.add(scrollBackingstore);
        scrollBackingstore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractTestMenuBar.this.getLayerContainerScrollPane().getViewport().setScrollMode(2);
                scrollBackingstore.setSelected(AbstractTestMenuBar.this.getLayerContainerScrollPane().getViewport().getScrollMode() == 2);
            }
        });
        final JCheckBoxMenuItem scrollBlit = new JCheckBoxMenuItem("BLIT_SCROLL_MODE", this.getLayerContainerScrollPane().getViewport().getScrollMode() == 1);
        scrollMenu.add(scrollBlit);
        scrollBlit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractTestMenuBar.this.getLayerContainerScrollPane().getViewport().setScrollMode(1);
                scrollBlit.setSelected(AbstractTestMenuBar.this.getLayerContainerScrollPane().getViewport().getScrollMode() == 1);
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(scrollSimple);
        group.add(scrollBackingstore);
        group.add(scrollBlit);
        perfMenu.add(scrollMenu);
    }

    private void fillGanttMenu(JMenu ganttMenu) {
        JMenuItem reset = new JMenuItem("Reset to Preferred Sizes");
        ganttMenu.add(reset);
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).resetToPreferredSizes();
            }
        });
        ganttMenu.addSeparator();
        JMenuItem logInfoMessage = new JMenuItem("Log Info Message");
        ganttMenu.add(logInfoMessage);
        logInfoMessage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).addMessage(new Message("Just a plain text error message"));
            }
        });
        JMenuItem logInfoException = new JMenuItem("Log Info Exception");
        ganttMenu.add(logInfoException);
        logInfoException.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).addMessage(new Message(MessageTypeId.INFORMATION, "Exception message", new IllegalArgumentException("ERROR: you shouldn't have done this :-)")));
            }
        });
        JMenuItem logErrorMessage = new JMenuItem("Log Error Message");
        ganttMenu.add(logErrorMessage);
        logErrorMessage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).addMessage(new Message(MessageTypeId.ERROR, "Just a plain text error message"));
            }
        });
        JMenuItem logErrorException = new JMenuItem("Log Error Exception");
        ganttMenu.add(logErrorException);
        logErrorException.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).addMessage(new Message("Exception message", new IllegalArgumentException("ERROR: you shouldn't have done this :-)")));
            }
        });
        JMenuItem logWarningMessage = new JMenuItem("Log Warning Message");
        ganttMenu.add(logWarningMessage);
        logWarningMessage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).addMessage(new Message(MessageTypeId.WARNING, "Just a plain text warning message"));
            }
        });
        JMenuItem logWarningException = new JMenuItem("Log Warning Exception");
        ganttMenu.add(logWarningException);
        logWarningException.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).addMessage(new Message(MessageTypeId.WARNING, "Warning Exception", new IllegalArgumentException("WARNING: you shouldn't have done this :-)")));
            }
        });
        ganttMenu.addSeparator();
        JMenuItem logTreePathMessage = new JMenuItem("Log Tree Path Message");
        ganttMenu.add(logTreePathMessage);
        logTreePathMessage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                System.out.println("Not implemented");
            }
        });
        ganttMenu.addSeparator();
        JMenuItem showLog = new JMenuItem("Show Log");
        ganttMenu.add(showLog);
        showLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).showMessages();
            }
        });
        JMenuItem clearLog = new JMenuItem("Clear Log");
        ganttMenu.add(clearLog);
        clearLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).clearMessages();
            }
        });
        ganttMenu.addSeparator();
        JMenuItem controlsFgColor = new JMenuItem("Controls Foreground");
        ganttMenu.add(controlsFgColor);
        controlsFgColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Color initialColor = ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).getControlsForeground();
                Color newColor = JColorChooser.showDialog(AbstractTestMenuBar.this.ganttChart, "Controls Foreground Color", initialColor);
                ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).setControlsForeground(newColor);
            }
        });
        JMenuItem controlsBgColor = new JMenuItem("Controls Background");
        ganttMenu.add(controlsBgColor);
        controlsBgColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Color initialColor = ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).getControlsBackground();
                Color newColor = JColorChooser.showDialog(AbstractTestMenuBar.this.ganttChart, "Controls Background Color", initialColor);
                ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).setControlsBackground(newColor);
            }
        });
        ganttMenu.addSeparator();
        JMenuItem bgColor = new JMenuItem("Background Color");
        ganttMenu.add(bgColor);
        bgColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Color initialColor = AbstractTestMenuBar.this.getTreeTable().getBackground();
                Color newColor = JColorChooser.showDialog(AbstractTestMenuBar.this.ganttChart, "Background Color", initialColor);
                AbstractTestMenuBar.this.getTreeTable().setBackground(newColor);
            }
        });
        JMenuItem altBgColor = new JMenuItem("Alternating Color");
        ganttMenu.add(altBgColor);
        altBgColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Color initialColor = AbstractTestMenuBar.this.getTreeTable().getAlternatingBackground();
                Color newColor = JColorChooser.showDialog(AbstractTestMenuBar.this.ganttChart, "Background Color", initialColor);
                AbstractTestMenuBar.this.getTreeTable().setAlternatingBackground(newColor);
            }
        });
    }

    private void fillLookAndFeelMenu(JMenu lookAndFeelMenu) {
        SecurityManager sm = System.getSecurityManager();
        try {
            if (sm != null) {
                sm.checkPropertyAccess("swing.aatext");
            }
            JCheckBoxMenuItem aaText = new JCheckBoxMenuItem("Antialiased Text", Boolean.getBoolean("swing.aatext"));
            aaText.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    System.setProperty("swing.aatext", Boolean.toString(!Boolean.getBoolean("swing.aatext")));
                    for (Frame f2 : Frame.getFrames()) {
                        SwingUtilities.updateComponentTreeUI(f2);
                        for (Window w2 : f2.getOwnedWindows()) {
                            SwingUtilities.updateComponentTreeUI(w2);
                        }
                    }
                }
            });
            lookAndFeelMenu.add(aaText);
            lookAndFeelMenu.addSeparator();
        }
        catch (SecurityException aaText) {
            // empty catch block
        }
        ButtonGroup group = new ButtonGroup();
        UIManager.LookAndFeelInfo[] laf = UIManager.getInstalledLookAndFeels();
        for (int i2 = 0; i2 < laf.length; ++i2) {
            final String lafClassName = laf[i2].getClassName();
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(laf[i2].getName());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    try {
                        UIManager.setLookAndFeel(lafClassName);
                        for (Frame f2 : Frame.getFrames()) {
                            SwingUtilities.updateComponentTreeUI(f2);
                            for (Window w2 : f2.getOwnedWindows()) {
                                SwingUtilities.updateComponentTreeUI(w2);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            lookAndFeelMenu.add(item);
            group.add(item);
            if (!UIManager.getLookAndFeel().getName().equals(item.getText())) continue;
            item.setSelected(true);
        }
    }

    private void fillTableMenu(JMenu tableMenu) {
        JCheckBoxMenuItem root = new JCheckBoxMenuItem("Root Visible");
        tableMenu.add(root);
        root.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractTestMenuBar.this.getTreeTable().setRootVisible(!AbstractTestMenuBar.this.getTreeTable().isRootVisible());
            }
        });
        root.setSelected(this.getTreeTable().isRootVisible());
        JCheckBoxMenuItem createEnabled = new JCheckBoxMenuItem("Create Enabled", this.getTreeTable().isCreationEnabled());
        tableMenu.add(createEnabled);
        createEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractTestMenuBar.this.getTreeTable().setCreationEnabled(!AbstractTestMenuBar.this.getTreeTable().isCreationEnabled());
            }
        });
        JMenuItem keyColumnPosition = new JMenuItem("Key Column Position");
        tableMenu.add(keyColumnPosition);
        keyColumnPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String result = JOptionPane.showInputDialog(AbstractTestMenuBar.this.ganttChart, "Enter position", Integer.toString(((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).getKeyColumnPosition()));
                if (result != null) {
                    ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).setKeyColumnPosition(Integer.parseInt(result));
                }
            }
        });
        JMenuItem optimizeKey = new JMenuItem("Format Key Column");
        tableMenu.add(optimizeKey);
        optimizeKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).optimizeColumnWidth(-1);
            }
        });
        JMenuItem optimizeKeyEditors = new JMenuItem("Format Key Column (Editors)");
        tableMenu.add(optimizeKeyEditors);
        optimizeKeyEditors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).optimizeColumnWidth(-1, true);
            }
        });
        JMenuItem optimizeAll = new JMenuItem("Format All Columns");
        tableMenu.add(optimizeAll);
        optimizeAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).optimizeColumnWidth();
            }
        });
        JMenuItem optimizeAllEditors = new JMenuItem("Format All Columns (Editors)");
        tableMenu.add(optimizeAllEditors);
        optimizeAllEditors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).optimizeColumnWidth(true);
            }
        });
        tableMenu.addSeparator();
        JCheckBoxMenuItem selectContiguous = new JCheckBoxMenuItem("Select Multipe (Contiguous)");
        selectContiguous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractTestMenuBar.this.getTreeTable().setSelectionMode(2);
            }
        });
        JCheckBoxMenuItem selectDiscontiguous = new JCheckBoxMenuItem("Select Multipe (Discontiguous)");
        selectDiscontiguous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractTestMenuBar.this.getTreeTable().setSelectionMode(4);
            }
        });
        JCheckBoxMenuItem selectSingle = new JCheckBoxMenuItem("Select Single");
        selectSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractTestMenuBar.this.getTreeTable().setSelectionMode(1);
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(selectContiguous);
        group.add(selectDiscontiguous);
        group.add(selectSingle);
        switch (this.getTreeTable().getSelectionMode()) {
            case 2: {
                selectContiguous.setSelected(true);
                break;
            }
            case 4: {
                selectDiscontiguous.setSelected(true);
                break;
            }
            case 1: {
                selectSingle.setSelected(true);
                break;
            }
        }
        JMenu selectionMenu = new JMenu("Selection Mode");
        selectionMenu.add(selectContiguous);
        selectionMenu.add(selectDiscontiguous);
        selectionMenu.add(selectSingle);
        tableMenu.add(selectionMenu);
        JMenuItem selectAll = new JMenuItem("Select All");
        tableMenu.add(selectAll);
        selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractTestMenuBar.this.getTreeTable().selectAll();
            }
        });
        JMenuItem deselectAll = new JMenuItem("Deselect All");
        tableMenu.add(deselectAll);
        deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractTestMenuBar.this.getTreeTable().clearSelection();
            }
        });
        JMenuItem setRangeSelection = new JMenuItem("Set Range Selection");
        tableMenu.add(setRangeSelection);
        setRangeSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String result = JOptionPane.showInputDialog(AbstractTestMenuBar.this.ganttChart, (Object)"Enter row numbers (example: 1-10)");
                if (result != null) {
                    StringTokenizer st = new StringTokenizer(result, "-");
                    String a2 = st.nextToken().trim();
                    String b2 = st.nextToken().trim();
                    AbstractTestMenuBar.this.getTreeTable().setSelectionInterval(Integer.parseInt(a2) - 1, Integer.parseInt(b2) - 1);
                }
            }
        });
        JMenuItem addRangeSelection = new JMenuItem("Add Range Selection");
        tableMenu.add(addRangeSelection);
        addRangeSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String result = JOptionPane.showInputDialog(AbstractTestMenuBar.this.ganttChart, (Object)"Enter row numbers (example: 1-10)");
                if (result != null) {
                    StringTokenizer st = new StringTokenizer(result, "-");
                    String a2 = st.nextToken().trim();
                    String b2 = st.nextToken().trim();
                    AbstractTestMenuBar.this.getTreeTable().addSelectionInterval(Integer.parseInt(a2) - 1, Integer.parseInt(b2) - 1);
                }
            }
        });
        tableMenu.addSeparator();
        JMenuItem expandRow = new JMenuItem("Expand Row");
        tableMenu.add(expandRow);
        expandRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int lastSelectedRow = AbstractTestMenuBar.this.getTreeTable().getSelectionModel().getLeadSelectionRow();
                String result = JOptionPane.showInputDialog(AbstractTestMenuBar.this.ganttChart, "Enter row number", Integer.toString(lastSelectedRow + 1));
                if (result != null) {
                    AbstractTestMenuBar.this.getTreeTable().expandRow(Integer.parseInt(result) - 1);
                }
            }
        });
        JMenuItem collapseRow = new JMenuItem("Collapse Row");
        tableMenu.add(collapseRow);
        collapseRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int lastSelectedRow = AbstractTestMenuBar.this.getTreeTable().getSelectionModel().getLeadSelectionRow();
                String result = JOptionPane.showInputDialog(AbstractTestMenuBar.this.ganttChart, "Enter row number", Integer.toString(lastSelectedRow + 1));
                if (result != null) {
                    AbstractTestMenuBar.this.getTreeTable().collapseRow(Integer.parseInt(result) - 1);
                }
            }
        });
        tableMenu.addSeparator();
        JMenu rowHeaderMenu = new JMenu("Row Header");
        tableMenu.add(rowHeaderMenu);
        JMenuItem rowHeaderWidth = new JMenuItem("Row Header Width");
        rowHeaderMenu.add(rowHeaderWidth);
        rowHeaderWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int lastWidth = ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).getTreeTableRowHeaderWidth();
                String result = JOptionPane.showInputDialog(AbstractTestMenuBar.this.ganttChart, "Enter width", Integer.toString(lastWidth + 1));
                if (result != null) {
                    ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).setTreeTableRowHeaderWidth(Integer.parseInt(result) - 1);
                }
            }
        });
    }

    private void fillTimelineMenu(JMenu timelineMenu, final Timeline timeline) {
        JCheckBoxMenuItem showEventline = new JCheckBoxMenuItem("Eventline Visible");
        showEventline.setSelected(timeline.isVisible());
        timelineMenu.add(showEventline);
        showEventline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                timeline.getEventline().setVisible(!timeline.getEventline().isVisible());
            }
        });
    }

    private void fillTreeTableModelMenu(JMenu treeTableModelMenu) {
        JMenuItem addRootChild = new JMenuItem("Add Child To Root");
        treeTableModelMenu.add(addRootChild);
        addRootChild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                System.out.println("Not implemented yet");
            }
        });
    }

    private void fillGanttModelMenu(JMenu ganttModelMenu) {
        JMenuItem setTimeSpan = new JMenuItem("Set Time Span");
        ganttModelMenu.add(setTimeSpan);
        setTimeSpan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ITimeSpan span = AbstractTestMenuBar.this.openTimeSpanDialog();
                if (span != null) {
                    try {
                        ((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).getDatelineModel().setTimeSpan(span);
                    }
                    catch (DatelineModelException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        JMenuItem addLayer = new JMenuItem("Add Layer");
        ganttModelMenu.add(addLayer);
        addLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String name = JOptionPane.showInputDialog("Enter Layer Name");
                Layer layer = new Layer(name);
                ((DefaultGanttChartModel)((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).getModel()).addLayer(layer);
            }
        });
        JMenu clearMenu = new JMenu("Clear Timeline Objects");
        ganttModelMenu.add(clearMenu);
        JMenuItem clearAll = new JMenuItem("On All Layers & Nodes");
        clearMenu.add(clearAll);
        clearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ((DefaultGanttChartModel)((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).getModel()).clearTimelineObjects();
            }
        });
        JMenuItem clearAllLayer = new JMenuItem("On Selected Layers");
        clearMenu.add(clearAllLayer);
        clearAllLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Object[] layers = AbstractTestMenuBar.this.getLayers(AbstractTestMenuBar.this.getModel());
                ILayer layer = (ILayer)JOptionPane.showInputDialog(AbstractTestMenuBar.this.ganttChart, "Select Layer", "Select...", 3, null, layers, layers[0]);
                if (layer != null) {
                    ((DefaultGanttChartModel)((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).getModel()).clearTimelineObjects(layer);
                }
            }
        });
        JMenuItem clearAllNode = new JMenuItem("On Selected Nodes");
        clearMenu.add(clearAllNode);
        clearAllNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TreePath[] paths = AbstractTestMenuBar.this.getTreeTable().getSelectionPaths();
                if (paths == null || paths.length == 0) {
                    JOptionPane.showMessageDialog(AbstractTestMenuBar.this.ganttChart, "Missing tree node selection", "Error", 0);
                    return;
                }
                for (TreePath path : paths) {
                    Object node = path.getLastPathComponent();
                    ((DefaultGanttChartModel)((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).getModel()).clearTimelineObjects((IGanttChartNode)node);
                }
            }
        });
        JMenuItem clearSingle = new JMenuItem("On Selected Layers & Nodes");
        clearMenu.add(clearSingle);
        clearSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Object[] layers = AbstractTestMenuBar.this.getLayers(AbstractTestMenuBar.this.getModel());
                ILayer layer = (ILayer)JOptionPane.showInputDialog(AbstractTestMenuBar.this.ganttChart, "Select Layer", "Select...", 3, null, layers, layers[0]);
                if (layer != null) {
                    TreePath[] paths = AbstractTestMenuBar.this.getTreeTable().getSelectionPaths();
                    if (paths == null || paths.length == 0) {
                        JOptionPane.showMessageDialog(AbstractTestMenuBar.this.ganttChart, "Missing tree node selection", "Error", 0);
                        return;
                    }
                    for (TreePath path : paths) {
                        Object node = path.getLastPathComponent();
                        ((DefaultGanttChartModel)((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).getModel()).clearTimelineObjects((IGanttChartNode)node, layer);
                    }
                }
            }
        });
    }

    private ILayer[] getLayers(IGanttChartModel model) {
        LinkedList<ILayer> result = new LinkedList<ILayer>();
        Iterator<ILayer> iter = model.getLayers();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        int s2 = result.size();
        ILayer[] layer = new ILayer[s2];
        result.toArray(layer);
        return layer;
    }

    private void fillEventlineModelMenu(JMenu eventlineModelMenu) {
        JMenuItem clearAll = new JMenuItem("Clear Eventline Objects");
        eventlineModelMenu.add(clearAll);
        clearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ((DefaultEventlineModel)((AbstractGanttChart)AbstractTestMenuBar.this.ganttChart).getEventline().getModel()).clearEventlineObjects();
            }
        });
    }

    private ITimeSpan openTimeSpanDialog() {
        if (this.timeSpanDialog == null) {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window instanceof Frame) {
                this.timeSpanDialog = new TimeSpanDialog((Frame)window);
            } else if (window instanceof Dialog) {
                this.timeSpanDialog = new TimeSpanDialog((Dialog)window);
            }
        }
        if (this.timeSpanDialog != null) {
            ITimeSpan span = this.timeSpanDialog.open();
            return span;
        }
        return null;
    }

    private void setWeekendDays() {
        JList list = new JList();
        list.setSelectionMode(2);
        DefaultListModel<WeekendDay> model = new DefaultListModel<WeekendDay>();
        model.addElement(new WeekendDay("Monday", 2));
        model.addElement(new WeekendDay("Tuesday", 3));
        model.addElement(new WeekendDay("Wednesday", 4));
        model.addElement(new WeekendDay("Thursday", 5));
        model.addElement(new WeekendDay("Friday", 6));
        model.addElement(new WeekendDay("Saturday", 7));
        model.addElement(new WeekendDay("Sunday", 1));
        list.setModel(model);
        list.setPreferredSize(new Dimension(200, 150));
        JDialog dialog = new JDialog();
        Window window = SwingUtilities.windowForComponent(this.ganttChart);
        dialog = window instanceof JDialog ? new JDialog((JDialog)window) : new JDialog((JFrame)window);
        dialog.add("Center", list);
        dialog.setResizable(true);
        dialog.setTitle("Select Weekend Days");
        dialog.pack();
        dialog.setModal(true);
        dialog.setVisible(true);
        Object[] selection = list.getSelectedValues();
        TimeGranularityCalendarModel calModel = (TimeGranularityCalendarModel)((AbstractGanttChart)this.ganttChart).getCalendarModel();
        if (selection != null && selection.length > 0) {
            int s2 = selection.length;
            int[] days = new int[s2];
            for (int i2 = 0; i2 < s2; ++i2) {
                days[i2] = ((WeekendDay)selection[i2]).value;
            }
            calModel.setWeekendDays(days);
        } else {
            calModel.setWeekendDays(null);
        }
    }

    class WeekendDay {
        String name;
        int value;

        public WeekendDay(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name;
        }
    }
}

