/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.spreadsheet;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.ISpreadsheet;
import com.dlsc.flexgantt.showcase.demo.spreadsheet.SpreadsheetValues;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.layer.system.DefaultSpreadsheetCellEditor;
import com.dlsc.flexgantt.swing.layer.system.ISpreadsheetCellEditor;
import com.dlsc.flexgantt.swing.layer.system.SpreadsheetLayer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;

public class SpreadsheetValuesEditor
extends DefaultSpreadsheetCellEditor
implements ISpreadsheetCellEditor {
    private AbstractGanttChart ganttChart;

    public SpreadsheetValuesEditor(AbstractGanttChart gc2) {
        super(new JComboBox(new DefaultComboBoxModel()));
        this.ganttChart = gc2;
    }

    private void updateComboBox(Object value) {
        Enum e2 = (Enum)value;
        Class cl = null;
        if (e2 != null) {
            cl = e2.getDeclaringClass();
        }
        if (cl == null) {
            ISpreadsheet spreadsheet = this.ganttChart.getActiveSpreadsheet();
            cl = spreadsheet.getDefaultValueType();
        }
        E[] obj = cl.getEnumConstants();
        JComboBox box = (JComboBox)this.getComponent();
        box.setMaximumRowCount(obj.length);
        box.setRenderer(new SpreadsheetValuesListCellRenderer());
        DefaultComboBoxModel spreadsheetModel = (DefaultComboBoxModel)box.getModel();
        spreadsheetModel.removeAllElements();
        for (Object o2 : obj) {
            spreadsheetModel.addElement(o2);
        }
    }

    @Override
    public Component getSpreadsheetCellEditorComponent(SpreadsheetLayer spreadsheet, Object value, int row, ITimeSpan span) {
        this.updateComboBox(value);
        return super.getSpreadsheetCellEditorComponent(spreadsheet, value, row, span);
    }

    class SpreadsheetValuesListCellRenderer
    extends DefaultListCellRenderer {
        SpreadsheetValuesListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof SpreadsheetValues) {
                SpreadsheetValues sv = (SpreadsheetValues)((Object)value);
                switch (sv) {
                    case ZERO: {
                        this.setText("Unused");
                        break;
                    }
                    case TEN: {
                        this.setText("10");
                        break;
                    }
                    case TWENTY: {
                        this.setText("20");
                        break;
                    }
                    case THIRTY: {
                        this.setText("30");
                        break;
                    }
                    case FOURTY: {
                        this.setText("40");
                        break;
                    }
                    case FIFTY: {
                        this.setText("50");
                        break;
                    }
                    case SIXTY: {
                        this.setText("60");
                        break;
                    }
                    case SEVENTY: {
                        this.setText("70");
                        break;
                    }
                    case EIGHTY: {
                        this.setText("80");
                        break;
                    }
                    case NINETY: {
                        this.setText("90");
                        break;
                    }
                    case HUNDRED: {
                        this.setText("100");
                        break;
                    }
                    case BROKEN: {
                        this.setText("Broken Machine");
                        break;
                    }
                    default: {
                        this.setText("");
                    }
                }
                this.setOpaque(true);
                Color c2 = sv.getColor();
                this.setBackground(new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), 100));
                if (isSelected) {
                    this.setForeground(Color.RED);
                }
            }
            return label;
        }
    }
}

