/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.resources;

import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.model.gantt.DefaultCapacityObject;
import com.dlsc.flexgantt.model.gantt.DefaultResourceNode;
import com.dlsc.flexgantt.model.gantt.DefaultTimelineObject;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.showcase.demo.resources.Resource;
import com.dlsc.flexgantt.showcase.demo.resources.ResourceModel;
import java.util.Calendar;

public class ResourceNode
extends DefaultResourceNode<Resource, ITimelineObject> {
    private Calendar c1 = Calendar.getInstance();
    private Calendar c2 = Calendar.getInstance();

    public ResourceNode(Resource res) {
        super(res, false);
        this.setRowHeight(100);
        this.setKey(res);
        TimeGranularity.DAY_SHORT.adjustCalendar(this.c1);
        TimeGranularity.DAY_SHORT.adjustCalendar(this.c2);
        int count = 1095;
        ITimelineObject[] tlo = new DefaultCapacityObject[count];
        for (int i2 = 0; i2 < count; ++i2) {
            this.c2.add(6, 1);
            double cap = Math.round(Math.random() * 150.0) - 30L;
            TimeSpan span = new TimeSpan(this.c1, this.c2);
            tlo[i2] = new DefaultCapacityObject(span);
            tlo[i2].setCapacityUsed(cap);
            tlo[i2].setPopupObject(cap + "%", false);
            ((DefaultTimelineObject)tlo[i2]).setPopupObject("Resource: " + res.getName() + "\n" + cap + "%", true);
            this.c1.add(6, 1);
        }
        this.setPopupTitleObject("Resource");
        this.setPopupObject("Name: " + res.getName(), false);
        this.setPopupObject("Name: " + res.getName() + "\nCapacity: " + res.getCapacity() + "\nLocation:" + res.getLocation(), true);
        this.setTimelineObjects(ResourceModel.CAP_LAYER, tlo);
        this.setMaximumCapacity(100.0);
        this.setMinimumCapacity(-50.0);
    }
}

