/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.resources;

import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.policy.layer.ICrosshairPolicy;
import com.dlsc.flexgantt.showcase.demo.resources.Resource;
import com.dlsc.flexgantt.showcase.demo.resources.ResourceCrosshairPolicy;
import com.dlsc.flexgantt.showcase.demo.resources.ResourceModel;
import com.dlsc.flexgantt.showcase.demo.resources.ResourceTreeTableCellRenderer;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.timeline.TimeGranularityDatelineModel;
import java.util.Calendar;

public class ResourceGanttChart
extends GanttChart {
    public ResourceGanttChart() {
        super(new ResourceModel());
        this.getTreeTable().setRootVisible(false);
        this.getColumnModel().getKeyColumn().setWidth(200);
        this.getSplitPane().resetToPreferredSizes();
        try {
            TimeGranularityDatelineModel datelineModel = (TimeGranularityDatelineModel)this.getDatelineModel();
            datelineModel.setGranularity(TimeGranularity.DAY_SHORT);
        }
        catch (DatelineModelException e2) {
            e2.printStackTrace();
        }
        this.setLayerContainerRowHeaderWidth(45);
        this.getTreeTable().setCellRenderer(Resource.class, new ResourceTreeTableCellRenderer());
        this.getLayerContainerScrollPane().getRowHeader().setVisible(true);
        this.setLabelsVisible(false);
        this.getLayerContainer().getPolicyProvider().setPolicy(ICrosshairPolicy.class, new ResourceCrosshairPolicy());
        Calendar sc2 = Calendar.getInstance();
        TimeGranularity.DAY_SHORT.adjustCalendar(sc2);
        Calendar ec2 = Calendar.getInstance();
        ec2.add(1, 10);
        TimeSpan span = new TimeSpan(sc2, ec2);
        this.setTimeSpan(span);
    }
}

