/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.relationships;

import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.gantt.GanttChartModelEvent;
import com.dlsc.flexgantt.model.gantt.IGanttChartModelListener;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.scheduling.DefaultModelValidator;
import com.dlsc.flexgantt.model.scheduling.IConstraint;
import com.dlsc.flexgantt.model.scheduling.IModelValidator;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.DefaultConstraintPolicy;
import com.dlsc.flexgantt.policy.layer.IRelationshipPolicy;
import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.DemoControlsPanel;
import com.dlsc.flexgantt.showcase.demo.relationships.ConstraintViolationMessageComparator;
import com.dlsc.flexgantt.showcase.demo.relationships.RelationshipGanttChartModel;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.GanttChartFrame;
import com.dlsc.flexgantt.swing.IMessage;
import com.dlsc.flexgantt.swing.layer.system.IRelationshipSelectionModelListener;
import com.dlsc.flexgantt.swing.layer.system.RelationshipLayer;
import com.dlsc.flexgantt.swing.layer.system.RelationshipSelectionEvent;
import com.dlsc.flexgantt.swing.scheduling.ConstraintSettingsPanel;
import com.dlsc.flexgantt.swing.scheduling.ConstraintViolationMessageTable;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RelationshipDemo
extends AbstractDemo
implements IRelationshipSelectionModelListener,
IGanttChartModelListener,
ChangeListener {
    private IModelValidator validator = new DefaultModelValidator();
    private ConstraintSettingsPanel settingsPanel;
    private GanttChart gc;
    private JDialog dialog;

    public RelationshipDemo() {
        super("Relationships");
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return new String[]{"RelationshipDemo", "RelationshipGanttChartModel", "ConstraintViolationMessageComparator"};
    }

    @Override
    public void run(boolean embedded) {
        RelationshipGanttChartModel model = new RelationshipGanttChartModel();
        model.addGanttChartModelListener(this);
        this.gc = this.createGanttChart(model);
        IPolicyProvider pp = this.gc.getLayerContainer().getPolicyProvider();
        pp.setPolicy(IRelationshipPolicy.class, new DefaultConstraintPolicy());
        TimeSpan span = new TimeSpan(2008, 0, 1, 2008, 2, 31);
        this.gc.setTimeSpan(span);
        DemoControlsPanel controls = new DemoControlsPanel(this);
        this.settingsPanel = new ConstraintSettingsPanel(this.gc.getLayerContainer());
        this.settingsPanel.addChangeListener(this);
        ((Container)controls).add(this.settingsPanel);
        RelationshipLayer rel = this.gc.getLayerContainer().getSystemLayer(RelationshipLayer.class);
        rel.getSelectionModel().addRelationshipSelectionModelListener(this);
        GanttChartFrame<?> frame = this.createFrame("Relationships / Constraints", this.gc, embedded);
        frame.add("East", controls);
        frame.setSize(1000, 800);
        frame.center();
        frame.setVisible(true);
        this.gc.expandAll();
        this.gc.optimizeColumnWidth();
        this.gc.resetToPreferredSizes();
        ConstraintViolationMessageTable messageTable = new ConstraintViolationMessageTable(this.gc.getLayerContainer());
        JScrollPane scrollPane = new JScrollPane(messageTable);
        this.dialog = new JDialog(frame);
        this.dialog.setLocationRelativeTo(this.settingsPanel);
        this.dialog.setTitle("Constraint Violations");
        this.dialog.add(scrollPane);
        this.dialog.setSize(400, 300);
    }

    private void validateModel() {
        this.gc.clearMessages();
        List<IMessage> messages = this.validator.validate(this.gc.getModel());
        ArrayList conMessages = new ArrayList();
        Collections.sort(conMessages, new ConstraintViolationMessageComparator(this.gc.getTreeTable()));
        for (IMessage m2 : conMessages) {
            this.gc.addMessage(m2);
        }
        if (conMessages.size() > 0) {
            this.dialog.setVisible(true);
        }
    }

    @Override
    public void ganttChartChanged(GanttChartModelEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RelationshipDemo.this.validateModel();
            }
        });
    }

    @Override
    public void valueChanged(RelationshipSelectionEvent evt) {
        IRelationship rel;
        if (evt.getId().equals((Object)RelationshipSelectionEvent.ID.RELATIONSHIPS_ADDED) && (rel = evt.getRelationships().iterator().next()) instanceof IConstraint) {
            this.settingsPanel.setConstraint((IConstraint)rel);
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.validateModel();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new RelationshipDemo());
    }
}

