/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.navigation;

import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.gantt.DefaultActivityObject;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.model.gantt.Layer;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.model.treetable.ITreeTableNode;
import com.dlsc.flexgantt.swing.IMessage;
import com.dlsc.flexgantt.swing.MessageTypeId;
import com.dlsc.flexgantt.swing.TimelineObjectPathMessage;
import com.dlsc.flexgantt.util.LabelType;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;

public class NavigationGanttChartModel
extends DefaultGanttChartModel<DefaultGanttChartNode<String, ITimelineObject>, ITimelineObject> {
    public static final String INFO = "info";
    public static final String WARNING = "warning";
    public static final String ERROR = "error";
    private List<IMessage> messages = new LinkedList<IMessage>();
    private Layer layer = new Layer("Layer");
    private final int ROW_COUNT = 10;
    private DefaultGanttChartNode[] node;

    public NavigationGanttChartModel() {
        super(new DefaultGanttChartNode());
        int j2;
        int i2;
        this.layer.removeFeature(ILayer.Feature.TIMELINE_OBJECT_DESCRIPTIONS);
        this.addLayer(this.layer);
        DefaultGanttChartNode rootNode = (DefaultGanttChartNode)this.getRoot();
        this.node = new DefaultGanttChartNode[10];
        for (i2 = 0; i2 < 10; ++i2) {
            this.node[i2] = new DefaultGanttChartNode(true);
            this.node[i2].setRowLineVisible(false, true);
            this.node[i2].setKey("Node " + i2);
            rootNode.add(this.node[i2]);
            for (j2 = 0; j2 < 3; ++j2) {
                DefaultGanttChartNode subNode = new DefaultGanttChartNode(false);
                subNode.setKey("Sub Node " + j2);
                if (j2 < 2) {
                    subNode.setRowLineVisible(false, false);
                }
                subNode.setColumnValue(Calendar.getInstance().getTime(), 0);
                subNode.setValueEditable(0, true);
                this.node[i2].add(subNode);
            }
        }
        for (i2 = 0; i2 < 10; ++i2) {
            for (j2 = 0; j2 < 3; ++j2) {
                int k2 = 0;
                while ((double)k2 < Math.random() * 500.0) {
                    DefaultActivityObject tlo = new DefaultActivityObject();
                    int offset = (int)(Math.random() * 334.0);
                    Calendar c2 = Calendar.getInstance();
                    c2.add(6, offset);
                    Calendar c22 = Calendar.getInstance();
                    c22.add(6, offset);
                    c22.add(6, Math.max(3, (int)(Math.random() * 10.0)));
                    tlo.setTimeSpan(new TimeSpan(c2, c22));
                    ((DefaultGanttChartNode)this.node[i2].getChildAt(j2)).addTimelineObject(this.layer, tlo);
                    String label = "tlo #" + k2;
                    tlo.setLabel(label, LabelType.DESCRIPTION);
                    if (Math.random() > 0.8) {
                        TimelineObjectPath path = new TimelineObjectPath(new Object[]{this.root, this.node[i2], this.node[i2].getChildAt(j2)}, tlo, (ILayer)this.layer);
                        MessageTypeId messageTypeId = MessageTypeId.INFORMATION;
                        if (Math.random() > 0.7) {
                            messageTypeId = MessageTypeId.WARNING;
                        } else if (Math.random() > 0.4) {
                            messageTypeId = MessageTypeId.ERROR;
                        }
                        TimelineObjectPathMessage msg = new TimelineObjectPathMessage(messageTypeId, this.node[i2].getKey() + " / " + ((ITreeTableNode)this.node[i2].getChildAt(j2)).getKey() + " / " + tlo.getLabel(LabelType.DESCRIPTION), path);
                        this.messages.add(msg);
                    }
                    String nl = System.getProperty("line.separator");
                    StringBuilder sb2 = new StringBuilder();
                    sb2.append("Status: ");
                    if (Math.random() > 0.97) {
                        tlo.setStatus(INFO);
                        sb2.append("Info");
                    }
                    if (Math.random() > 0.98) {
                        tlo.setStatus(WARNING);
                        sb2.append("Warning");
                    }
                    if (Math.random() > 0.98) {
                        tlo.setStatus(ERROR);
                        sb2.append("Error");
                    }
                    if (tlo.getStatus() == null) {
                        sb2.append("None");
                    }
                    sb2.append(nl);
                    sb2.append("Node Changeable: ");
                    if (Math.random() > 0.33) {
                        tlo.setDragActions(0);
                        sb2.append("Yes");
                    } else {
                        sb2.append("No");
                    }
                    sb2.append(nl);
                    sb2.append("Node Changeable: ");
                    if (Math.random() > 0.66) {
                        tlo.setStartTimeChangeable(false);
                        sb2.append("Yes");
                    } else {
                        sb2.append("No");
                    }
                    sb2.append(nl);
                    sb2.append("Duration Changeable: ");
                    if (Math.random() > 0.8) {
                        tlo.setDurationChangeable(false);
                        sb2.append("Yes");
                    } else {
                        sb2.append("No");
                    }
                    sb2.append(nl);
                    tlo.setPopupObject(sb2.toString(), false);
                    ++k2;
                }
            }
        }
    }

    public List<IMessage> getMessages() {
        return this.messages;
    }
}

