/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.multiline;

import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.DefaultTimelineObject;
import com.dlsc.flexgantt.model.gantt.GanttChartModelEvent;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.model.gantt.Layer;
import java.util.Calendar;

public class MultiLineModel
extends DefaultGanttChartModel<DefaultGanttChartNode<String, ITimelineObject>, ITimelineObject> {
    private static final Layer LAYER = new Layer("Default");
    private MyNode node;

    public MultiLineModel() {
        super(new DefaultGanttChartNode(true));
        this.addLayer(LAYER);
        DefaultGanttChartNode rootNode = (DefaultGanttChartNode)this.getRoot();
        this.node = new MyNode();
        rootNode.add(this.node);
        this.node.setKey("Multiline Node");
        this.node.setRowHeight(200);
        this.node.setLineCount(5);
        this.node.setColumnValue(5, 1);
        this.test();
    }

    public DefaultGanttChartNode getNode() {
        return this.node;
    }

    public void clear() {
        this.node.clearTimelineObjects(LAYER);
        this.clearRelationships();
        this.fireGanttChartChanged(new GanttChartModelEvent(this, GanttChartModelEvent.ID.TIMELINE_OBJECTS_REMOVED));
    }

    public void test() {
        this.clear();
        int lineCount = this.node.getLineCount();
        for (int i2 = 0; i2 < lineCount * 3; ++i2) {
            Calendar s2 = Calendar.getInstance();
            Calendar e2 = Calendar.getInstance();
            s2.add(6, (int)(Math.random() * 100.0));
            e2.setTimeInMillis(s2.getTimeInMillis());
            e2.add(6, Math.max(1, (int)(Math.random() * 10.0)));
            DefaultTimelineObject tlo = new DefaultTimelineObject(new TimeSpan(s2, e2));
            tlo.setLineIndex((int)(Math.random() * (double)lineCount));
            this.node.addTimelineObject(LAYER, tlo);
        }
    }

    class MyNode
    extends DefaultGanttChartNode<Object, ITimelineObject> {
        public MyNode() {
            super(false);
        }

        @Override
        public int getLineHeight(int lineIndex, int rowHeight) {
            return super.getLineHeight(lineIndex, rowHeight);
        }

        @Override
        public int getLineLocation(int lineIndex, int rowHeight) {
            return super.getLineLocation(lineIndex, rowHeight);
        }
    }
}

