/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.multiline;

import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.treetable.DefaultColumnModel;
import com.dlsc.flexgantt.model.treetable.SortDirection;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.DemoControlsPanel;
import com.dlsc.flexgantt.showcase.demo.multiline.MultiLineModel;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.GanttChartFrame;
import com.dlsc.flexgantt.swing.layer.system.DefaultRowRenderer;
import com.dlsc.flexgantt.swing.layer.system.RowLayer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;

public class MultiLineDemo
extends AbstractDemo {
    public MultiLineDemo() {
        super("Multi Line");
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return new String[]{"MultiLineDemo", "MultiLineModel"};
    }

    @Override
    public void run(boolean embedded) {
        final MultiLineModel model = new MultiLineModel();
        final GanttChart gc2 = this.createGanttChart(model);
        final DefaultGanttChartNode node = model.getNode();
        TreeTableColumn column = new TreeTableColumn("Count", Integer.class, 1);
        column.setWidth(50);
        column.setSupportedSortDirections(new SortDirection[]{SortDirection.ASCENDING});
        ((DefaultColumnModel)gc2.getColumnModel()).addColumn(column);
        gc2.getKeyColumn().setWidth(150);
        gc2.getTreeTable().setRootVisible(false);
        gc2.resetToPreferredSizes();
        GanttChartFrame<?> frame = this.createFrame("Overlapping Timeline Objects / Inner Lines", gc2, embedded);
        JPanel controls = new JPanel();
        controls.setBorder(this.createTitledBorder("Settings"));
        controls.setLayout(new MigLayout("insets 0 0 0 0, wrap 1, alignx center", "[grow]", "[][][]"));
        final JSlider slider = new JSlider(1, 0, 100, node.getLineCount());
        slider.setMajorTickSpacing(10);
        slider.setMinorTickSpacing(1);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.setPaintTrack(true);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                model.clear();
                node.setLineCount(slider.getValue());
                node.setColumnValue(slider.getValue(), 1);
                gc2.getLayerContainer().repaint();
                ((DefaultGanttChartModel)gc2.getModel()).nodeChanged(node);
            }
        });
        RowLayer layer = gc2.getLayerContainer().getSystemLayer(RowLayer.class);
        final DefaultRowRenderer renderer = (DefaultRowRenderer)layer.getRowRenderer(DefaultGanttChartNode.class);
        final JCheckBox paintLines = new JCheckBox("Paint Lines", renderer.isPaintingLines());
        paintLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                renderer.setPaintingLines(paintLines.isSelected());
                gc2.getLayerContainer().repaint();
            }
        });
        JButton button = new JButton("Test");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                model.test();
            }
        });
        controls.add((Component)paintLines, "grow");
        controls.add((Component)slider, "grow");
        controls.add((Component)button, "grow");
        DemoControlsPanel demoControlsPanel = new DemoControlsPanel(this);
        demoControlsPanel.add(controls);
        frame.add("East", demoControlsPanel);
        frame.center();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new MultiLineDemo());
    }
}

