/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.editing;

import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.treetable.INodeEditPolicy;
import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.DemoControlsPanel;
import com.dlsc.flexgantt.showcase.demo.editing.EditingDemoGanttChartModel;
import com.dlsc.flexgantt.showcase.demo.editing.EditingDemoNodeEditPolicy;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.GanttChartFrame;
import com.dlsc.flexgantt.swing.layer.system.RowLayer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class EditingDemo
extends AbstractDemo {
    public EditingDemo() {
        super("Editing");
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return new String[]{"EditingDemo", "EditingDemoCreateNodeCommand", "EditingDemoInsertNodeCommand", "EditingDemoGanttChartModel", "EditingDemoGanttChartNode", "EditingDemoNodeEditPolicy"};
    }

    @Override
    public void run(boolean embedded) {
        final GanttChart gc2 = this.createGanttChart(new EditingDemoGanttChartModel());
        gc2.getKeyColumn().setWidth(200);
        final TreeTable table = gc2.getTreeTable();
        table.setCreationEnabled(true);
        gc2.getLayerContainer().getSystemLayer(RowLayer.class);
        IPolicyProvider pp = table.getPolicyProvider();
        pp.setPolicy(INodeEditPolicy.class, new EditingDemoNodeEditPolicy());
        TreeTableColumn col0 = new TreeTableColumn("Allows Children", Boolean.class, 0);
        TreeTableColumn col1 = new TreeTableColumn("Number 1", Double.class, 1);
        TreeTableColumn col2 = new TreeTableColumn("Number 2", Double.class, 2);
        gc2.getColumnModel().addColumn(col0);
        gc2.getColumnModel().addColumn(col1);
        gc2.getColumnModel().addColumn(col2);
        gc2.resetToPreferredSizes();
        gc2.getTreeTable().setRootVisible(false);
        JPanel box = new JPanel();
        box.setLayout(new MigLayout("insets 0 0 0 0, wrap 1", "[grow]", "[]"));
        final JCheckBox compEnabled = new JCheckBox("Enable Gantt Chart", gc2.isEnabled());
        compEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                gc2.setEnabled(compEnabled.isSelected());
            }
        });
        box.add(compEnabled);
        final JCheckBox editEnabled = new JCheckBox("Enable Cell Editing", table.isEditingEnabled());
        editEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                table.setEditingEnabled(editEnabled.isSelected());
            }
        });
        box.add(editEnabled);
        final JCheckBox createEnabled = new JCheckBox("Enable Row Creation", table.isCreationEnabled());
        createEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                table.setCreationEnabled(createEnabled.isSelected());
            }
        });
        box.add(createEnabled);
        final JCheckBox deleteEnabled = new JCheckBox("Enable Row Deletion", table.isDeletionEnabled());
        deleteEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                table.setDeletionEnabled(deleteEnabled.isSelected());
            }
        });
        box.add(deleteEnabled);
        final JCheckBox indentEnabled = new JCheckBox("Enable Row Indentation", table.isIndentEnabled());
        indentEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                table.setIndentEnabled(indentEnabled.isSelected());
            }
        });
        box.add(indentEnabled);
        final JCheckBox resizingEnabled = new JCheckBox("Enable Row Resizing", table.isResizingEnabled());
        resizingEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                table.setResizingEnabled(resizingEnabled.isSelected());
            }
        });
        box.add(resizingEnabled);
        final JCheckBox draggingEnabled = new JCheckBox("Enable Tree Table Drag & Drop", table.isDraggingEnabled());
        draggingEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                table.setDraggingEnabled(draggingEnabled.isSelected());
            }
        });
        box.add(draggingEnabled);
        final DefaultGanttChartModel model = (DefaultGanttChartModel)gc2.getModel();
        final JCheckBox asksAllowsChildren = new JCheckBox("Asks 'Allows Children'", model.asksAllowsChildren());
        asksAllowsChildren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                model.setAsksAllowsChildren(asksAllowsChildren.isSelected());
                gc2.repaint();
            }
        });
        box.add(asksAllowsChildren);
        box.setBorder(this.createTitledBorder("Settings"));
        DemoControlsPanel panel = new DemoControlsPanel(this);
        ((Container)panel).setLayout(new BorderLayout());
        ((Container)panel).add("North", box);
        GanttChartFrame<?> frame = this.createFrame("Editing", gc2, embedded);
        frame.add("East", panel);
        frame.setSize(1000, 800);
        frame.center();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new EditingDemo());
    }
}

