/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.commands;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandStackEvent;
import com.dlsc.flexgantt.command.DefaultCommandStack;
import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.ICommandStackListener;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.command.layer.DefaultChangeTimelineObjectTimeSpanCommand;
import com.dlsc.flexgantt.command.layer.DefaultDragAndDropCommand;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.gantt.GanttChartModelEvent;
import com.dlsc.flexgantt.model.gantt.IGanttChartModelListener;
import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.DemoControlsPanel;
import com.dlsc.flexgantt.showcase.demo.commands.CommandsModel;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.GanttChartFrame;
import com.dlsc.flexgantt.swing.ICommandInterceptor;
import com.dlsc.flexgantt.swing.action.gantt.RedoAction;
import com.dlsc.flexgantt.swing.action.gantt.UndoAction;
import com.dlsc.flexgantt.util.GridLineMode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TimeZone;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.miginfocom.swing.MigLayout;

public class CommandsDemo
extends AbstractDemo {
    public CommandsDemo() {
        super("Commands");
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return new String[]{"CommandsDemo", "CommandsModel"};
    }

    @Override
    public void run(boolean embedded) {
        final GanttChart gc2 = this.createGanttChart();
        try {
            gc2.getDatelineModel().setTimeZone(TimeZone.getTimeZone("GMT-8:00"));
        }
        catch (DatelineModelException e2) {
            e2.printStackTrace();
        }
        gc2.setModel(new CommandsModel());
        gc2.resetToPreferredSizes();
        gc2.getTreeTable().setRootVisible(false);
        gc2.setGridLineMode(GridLineMode.COMBINED_GRID_LINES);
        GanttChartFrame<?> frame = this.createFrame("Commands", gc2, embedded);
        JPanel commandStackPanel = new JPanel();
        commandStackPanel.setOpaque(false);
        commandStackPanel.setBorder(this.createTitledBorder("Command Stack"));
        commandStackPanel.setLayout(new MigLayout("insets 0 0 0 0", "[grow][grow]", "[grow][]"));
        final AbstractListModel model = new AbstractListModel(){

            @Override
            public Object getElementAt(int index) {
                DefaultCommandStack stack = (DefaultCommandStack)gc2.getCommandStack();
                return stack.getExecutedCommands().get(index);
            }

            @Override
            public int getSize() {
                DefaultCommandStack stack = (DefaultCommandStack)gc2.getCommandStack();
                return stack.getExecutedCommands().size();
            }
        };
        final JList<Object> list = new JList<Object>(model);
        list.setVisibleRowCount(8);
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setPreferredSize(new Dimension(150, 200));
        gc2.getCommandStack().addCommandStackListener(new ICommandStackListener(){

            @Override
            public void commandStackChanged(CommandStackEvent e2) {
                for (ListDataListener l2 : model.getListDataListeners()) {
                    l2.contentsChanged(new ListDataEvent(list, 0, 0, model.getSize()));
                }
            }
        });
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jl, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)jl, value, index, isSelected, cellHasFocus);
                ICommand cmd = (ICommand)value;
                label.setText(cmd.getName());
                return label;
            }
        });
        JButton undoButton = new JButton(new UndoAction<GanttChart>(gc2));
        JButton redoButton = new JButton(new RedoAction<GanttChart>(gc2));
        commandStackPanel.add((Component)scrollPane, "spanx 2, wrap, grow");
        commandStackPanel.add(undoButton);
        commandStackPanel.add(redoButton);
        final JDialog dialog = new JDialog();
        dialog.setTitle("Commandstack Events Log");
        dialog.setModal(false);
        dialog.setSize(700, 300);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        final JTextArea area = new JTextArea(10, 10);
        area.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e2) {
                if (!dialog.isVisible()) {
                    dialog.setVisible(true);
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                if (!dialog.isVisible()) {
                    dialog.setVisible(true);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
                if (!dialog.isVisible()) {
                    dialog.setVisible(true);
                }
            }
        });
        dialog.add("Center", textPanel);
        textPanel.add("Center", new JScrollPane(area));
        gc2.getCommandStack().addCommandStackListener(new ICommandStackListener(){

            @Override
            public void commandStackChanged(CommandStackEvent e2) {
                area.append(e2.toString());
                area.append("\n");
                area.setCaretPosition(area.getText().length());
            }
        });
        gc2.getModel().addGanttChartModelListener(new IGanttChartModelListener(){

            @Override
            public void ganttChartChanged(final GanttChartModelEvent e2) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        area.append(e2.toString());
                        area.append("\n");
                        area.setCaretPosition(area.getText().length());
                    }
                });
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new MigLayout("insets 2 2 2 2, wrap 1", "[grow]", "[][]"));
        buttonPanel.setBorder(this.createTitledBorder("Actions"));
        JButton button1 = new JButton("Not Undoable Command");
        button1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JOptionPane.showMessageDialog(gc2, "Running a command that is not undoable\nclears the command stack", "Information", 1);
                gc2.commandExecute(new AbstractCommand("Not Undoable"){

                    @Override
                    public void executeCommand(IProgressMonitor monitor) {
                    }

                    @Override
                    public void undoCommand(IProgressMonitor monitor) {
                    }

                    @Override
                    public boolean isUndoable() {
                        return false;
                    }
                });
            }
        });
        buttonPanel.add((Component)button1, "grow");
        JButton button2 = new JButton("Long Running Command");
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                gc2.commandExecute(new AbstractCommand("Long Running"){

                    @Override
                    public void executeCommand(IProgressMonitor monitor) {
                        monitor.beginTask("Command running in separate thread (verify UI is responsive)", 100);
                        for (int i2 = 0; i2 < 100 && !monitor.isCanceled(); ++i2) {
                            monitor.worked(1);
                            monitor.subTask(i2 + " / " + 100);
                            try {
                                Thread.sleep(100L);
                                continue;
                            }
                            catch (InterruptedException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }

                    @Override
                    public void undoCommand(IProgressMonitor monitor) {
                    }
                });
            }
        });
        buttonPanel.add((Component)button2, "grow");
        final JCheckBox button3 = new JCheckBox("Use Command Interceptors");
        button3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (button3.isSelected()) {
                    gc2.setCommandInterceptor(DefaultDragAndDropCommand.class, new ICommandInterceptor(){

                        public boolean intercept(AbstractGanttChart gc2, ICommand cmd) {
                            int answer = JOptionPane.showConfirmDialog(gc2, "Are you sure you want to change the node?", "Drag & Drop", 0);
                            return answer == 0;
                        }
                    });
                    gc2.setCommandInterceptor(DefaultChangeTimelineObjectTimeSpanCommand.class, new ICommandInterceptor(){

                        public boolean intercept(AbstractGanttChart gc2, ICommand cmd) {
                            int answer = JOptionPane.showConfirmDialog(gc2, "Are you sure you want to change the time span?", "Changing time span", 0);
                            return answer == 0;
                        }
                    });
                } else {
                    gc2.setCommandInterceptor(DefaultDragAndDropCommand.class, null);
                    gc2.setCommandInterceptor(DefaultChangeTimelineObjectTimeSpanCommand.class, null);
                }
            }
        });
        buttonPanel.add(button3);
        final JCheckBox button4 = new JCheckBox("Enable Dragging");
        button4.setSelected(gc2.getLayerContainer().isDraggingEnabled());
        button4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                gc2.getLayerContainer().setDraggingEnabled(button4.isSelected());
            }
        });
        buttonPanel.add(button4);
        DemoControlsPanel controls = new DemoControlsPanel(this);
        ((Container)controls).setLayout(new MigLayout("insets 0 0 0 0, wrap 1", "[grow]", "[]"));
        ((Container)controls).add((Component)buttonPanel, "grow");
        ((Container)controls).add((Component)commandStackPanel, "grow");
        frame.add("East", controls);
        frame.center();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new CommandsDemo());
    }
}

