/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.actions;

import com.dlsc.flexgantt.model.gantt.DefaultTimelineObject;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.model.treetable.KeyColumn;
import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.DemoControlsPanel;
import com.dlsc.flexgantt.showcase.demo.actions.ActionsDemoGanttChartModel;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.GanttChartFrame;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.ActionLayer;
import com.dlsc.flexgantt.swing.layer.system.IActionProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ActionsDemo
extends AbstractDemo
implements IActionProvider {
    private GanttChart gc;
    private AbstractAction actionAlignLeft;
    private AbstractAction actionAlignCenter;
    private AbstractAction actionAlignRight;
    private AbstractAction actionAlignJustified;
    private AbstractAction actionFontItalic;
    private AbstractAction actionFontBold;
    private AbstractAction actionEditCut;
    private AbstractAction actionEditCopy;
    private AbstractAction actionEditPaste;
    private AbstractAction actionFontUnderlined;

    public ActionsDemo() {
        super("Actions");
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return new String[]{"ActionsDemo", "ActionsDemoGanttChartModel"};
    }

    @Override
    public void run(boolean embedded) {
        this.gc = this.createGanttChart(new ActionsDemoGanttChartModel());
        this.gc.expandAll();
        KeyColumn key = this.gc.getColumnModel().getKeyColumn();
        key.setWidth(200);
        this.gc.resetToPreferredSizes();
        this.gc.getTreeTable().setRootVisible(false);
        this.createActions();
        ActionLayer actionLayer = this.gc.getLayerContainer().getSystemLayer(ActionLayer.class);
        actionLayer.setActionProvider(this);
        actionLayer.getButtonPanel().setColumns(7);
        actionLayer.getButtonPanel().setBackgroundPaint(new GradientPaint(0.0f, 0.0f, new Color(230, 230, 230), 0.0f, 60.0f, new Color(250, 250, 250)));
        GanttChartFrame<?> frame = this.createFrame("Actions", this.gc, embedded);
        DemoControlsPanel controls = new DemoControlsPanel(this);
        ((Container)controls).setLayout(new BorderLayout());
        frame.add("East", controls);
        frame.center();
        frame.setVisible(true);
    }

    private void createActions() {
        this.actionAlignLeft = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JOptionPane.showMessageDialog(ActionsDemo.this.gc, "Action 1 was clicked!", "Message", 1);
            }
        };
        this.actionAlignCenter = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JOptionPane.showMessageDialog(ActionsDemo.this.gc, "Action 2 was clicked!", "Message", 1);
            }
        };
        this.actionAlignRight = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JOptionPane.showMessageDialog(ActionsDemo.this.gc, "Action 3 was clicked!", "Message", 1);
            }
        };
        this.actionAlignJustified = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JOptionPane.showMessageDialog(ActionsDemo.this.gc, "Action 4 was clicked!", "Message", 1);
            }
        };
        this.actionFontItalic = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JOptionPane.showMessageDialog(ActionsDemo.this.gc, "Action 5 was clicked!", "Message", 1);
            }
        };
        this.actionFontBold = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JOptionPane.showMessageDialog(ActionsDemo.this.gc, "Action 6 was clicked!", "Message", 1);
            }
        };
        this.actionFontUnderlined = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JOptionPane.showMessageDialog(ActionsDemo.this.gc, "Action 7 was clicked!", "Message", 1);
            }
        };
        this.actionEditCut = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JOptionPane.showMessageDialog(ActionsDemo.this.gc, "Action 8 was clicked!", "Message", 1);
            }
        };
        this.actionEditCopy = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JOptionPane.showMessageDialog(ActionsDemo.this.gc, "Action 9 was clicked!", "Message", 1);
            }
        };
        this.actionEditPaste = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JOptionPane.showMessageDialog(ActionsDemo.this.gc, "Action 10 was clicked!", "Message", 1);
            }
        };
        this.actionAlignLeft.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("text_align_left.png")));
        this.actionAlignCenter.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("text_align_center.png")));
        this.actionAlignRight.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("text_align_right.png")));
        this.actionAlignJustified.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("text_align_justified.png")));
        this.actionFontItalic.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("text_italics.png")));
        this.actionFontBold.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("text_bold.png")));
        this.actionFontUnderlined.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("text_underlined.png")));
        this.actionEditCut.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("cut.png")));
        this.actionEditCopy.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("copy.png")));
        this.actionEditPaste.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("paste.png")));
        this.actionAlignLeft.putValue("ShortDescription", "Align object to the left");
        this.actionAlignCenter.putValue("ShortDescription", "Align object in the center");
        this.actionAlignRight.putValue("ShortDescription", "Align object to the right");
        this.actionAlignJustified.putValue("ShortDescription", "Align object justified");
        this.actionFontItalic.putValue("ShortDescription", "Make text italic");
        this.actionFontBold.putValue("ShortDescription", "Make text bold");
        this.actionFontUnderlined.putValue("ShortDescription", "Make text underlined");
        this.actionEditCut.putValue("ShortDescription", "Cut the selection");
        this.actionEditCopy.putValue("ShortDescription", "Copy the selection");
        this.actionEditPaste.putValue("ShortDescription", "Paste the selection");
    }

    @Override
    public List<Action> getTimelineObjectActions(LayerContainer lc2, TimelineObjectPath path) {
        ArrayList<Action> actions = new ArrayList<Action>();
        DefaultTimelineObject tlo = (DefaultTimelineObject)path.getTimelineObject();
        ActionsDemoGanttChartModel.RequestedActions requestedActions = (ActionsDemoGanttChartModel.RequestedActions)((Object)tlo.getUserObject());
        switch (requestedActions) {
            case ALIGNMENT: {
                actions.add(this.actionAlignLeft);
                actions.add(this.actionAlignCenter);
                actions.add(this.actionAlignRight);
                actions.add(this.actionAlignJustified);
                break;
            }
            case CUT_COPY_PASTE: {
                actions.add(this.actionEditCut);
                actions.add(this.actionEditCopy);
                actions.add(this.actionEditPaste);
                break;
            }
            case FONT_STYLE: {
                actions.add(this.actionFontBold);
                actions.add(this.actionFontItalic);
                actions.add(this.actionFontUnderlined);
                break;
            }
            case ALL_ACTIONS: {
                actions.add(this.actionAlignLeft);
                actions.add(this.actionAlignCenter);
                actions.add(this.actionAlignRight);
                actions.add(this.actionAlignJustified);
                actions.add(this.actionEditCut);
                actions.add(this.actionEditCopy);
                actions.add(this.actionEditPaste);
                actions.add(this.actionFontBold);
                actions.add(this.actionFontItalic);
                actions.add(this.actionFontUnderlined);
            }
        }
        return actions;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new ActionsDemo());
    }
}

