/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase;

import com.dlsc.flexgantt.showcase.AbstractPage;
import com.dlsc.flexgantt.showcase.DemoLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class GalleryPanel
extends AbstractPage {
    private List<Snapshot> snapshots;
    private Snapshot currentSnapshot;
    private JLabel imageLabel = new JLabel();
    private JLabel leftLabel;
    private JLabel rightLabel;
    private JLabel pageLabel;

    public GalleryPanel() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.pageLabel = new JLabel("");
        this.pageLabel.setHorizontalAlignment(4);
        this.pageLabel.setForeground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.add("North", this.pageLabel);
        this.imageLabel.setFont(new Font("helvetica", 1, 12));
        this.imageLabel.setForeground(Color.WHITE);
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setVerticalAlignment(0);
        this.imageLabel.setVerticalTextPosition(1);
        this.imageLabel.setHorizontalTextPosition(0);
        this.imageLabel.setFont(new Font("helvetica", 1, 18));
        this.imageLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.imageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                GalleryPanel.this.showFullSize();
            }
        });
        this.add("Center", this.imageLabel);
        final ImageIcon play = new ImageIcon(this.getImage("Play", false));
        final ImageIcon playIn = new ImageIcon(this.getImage("Play", true));
        final JLabel playLabel = new JLabel(play);
        playLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                playLabel.setIcon(play);
                GalleryPanel.this.showFullSize();
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                playLabel.setIcon(playIn);
            }
        });
        final ImageIcon left = new ImageIcon(this.getImage("Left", false));
        final ImageIcon leftIn = new ImageIcon(this.getImage("Left", true));
        this.leftLabel = new JLabel(left);
        this.leftLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                GalleryPanel.this.leftLabel.setIcon(left);
                GalleryPanel.this.previous();
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                GalleryPanel.this.leftLabel.setIcon(leftIn);
            }
        });
        final ImageIcon right = new ImageIcon(this.getImage("Right", false));
        final ImageIcon rightIn = new ImageIcon(this.getImage("Right", true));
        this.rightLabel = new JLabel(right);
        this.rightLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                GalleryPanel.this.rightLabel.setIcon(right);
                GalleryPanel.this.next();
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                GalleryPanel.this.rightLabel.setIcon(rightIn);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1));
        panel.setOpaque(false);
        panel.add(this.leftLabel);
        panel.add(playLabel);
        panel.add(this.rightLabel);
        this.add("South", panel);
        this.snapshots = this.getSnapshots();
        this.display(this.snapshots.get(0));
    }

    private void display(Snapshot snap) {
        this.display(snap, false);
    }

    private void display(Snapshot snap, boolean fullSize) {
        URL url = this.getClass().getResource("gallery/" + snap.file);
        ImageIcon icon = new ImageIcon(url);
        if (fullSize) {
            JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(this);
            JDialog dialog = new JDialog((Frame)frame, snap.title);
            dialog.add("Center", new JLabel(icon));
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        } else {
            Image image = icon.getImage();
            double sf = Math.min(1.0, Math.min(800.0 / (double)image.getWidth(icon.getImageObserver()), 400.0 / (double)image.getHeight(icon.getImageObserver())));
            image = image.getScaledInstance((int)(sf * (double)image.getWidth(icon.getImageObserver())), (int)(sf * (double)image.getHeight(icon.getImageObserver())), 4);
            icon.setImage(image);
            this.imageLabel.setIcon(icon);
            this.imageLabel.setText(snap.title);
            this.currentSnapshot = snap;
            this.pageLabel.setText("Image " + (this.snapshots.indexOf(snap) + 1) + " of " + this.snapshots.size());
        }
    }

    private void previous() {
        int index = this.snapshots.indexOf(this.currentSnapshot);
        if (--index < 0) {
            index = this.snapshots.size() - 1;
        }
        this.display(this.snapshots.get(index));
    }

    private void next() {
        int index = this.snapshots.indexOf(this.currentSnapshot);
        if (++index >= this.snapshots.size()) {
            index = 0;
        }
        this.display(this.snapshots.get(index));
    }

    private void showFullSize() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GalleryPanel.this.display(GalleryPanel.this.currentSnapshot, true);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private Image getImage(String file, boolean pressed) {
        URL url = DemoLauncher.class.getResource(file + ".png");
        if (pressed) {
            url = DemoLauncher.class.getResource(file + "-in.png");
        }
        ImageIcon icon = new ImageIcon(url);
        Image image = icon.getImage();
        int width = (int)((float)image.getWidth(this) * 0.5f);
        int height = (int)((float)image.getHeight(this) * 0.5f);
        image = image.getScaledInstance(width, height, 4);
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 1);
        try {
            tracker.waitForID(1);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        return image;
    }

    private List<Snapshot> getSnapshots() {
        LinkedList<Snapshot> snapshots = new LinkedList<Snapshot>();
        InputStream stream = this.getClass().getResourceAsStream("gallery/snapshots.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            String line = reader.readLine();
            while (line != null) {
                StringTokenizer st = new StringTokenizer(line, ",");
                Snapshot snapshot = new Snapshot();
                snapshot.file = st.nextToken().trim();
                snapshot.title = st.nextToken().trim();
                snapshot.description = st.nextToken().trim();
                snapshots.add(snapshot);
                line = reader.readLine();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return snapshots;
    }

    class Snapshot {
        String file;
        String title;
        String description;

        Snapshot() {
        }
    }
}

