/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase;

import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.AbstractPage;
import com.dlsc.flexgantt.showcase.DemoLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.swingx.painter.AbstractLayoutPainter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.ImagePainter;

public class DemosPanel
extends AbstractPage
implements TimingTarget {
    private JPanel iconPanel = new JPanel();
    private JLabel textArea = new JLabel();
    private List<Component> compList = new LinkedList<Component>();
    private DemoLauncher launcher;
    private ImagePainter imagePainter;
    private int notepadInset;
    private int notepadHeight;
    private boolean animationDone;
    private Animator animator;
    private AbstractDemo animatedDemo;

    public DemosPanel(DemoLauncher launcher) {
        this.launcher = launcher;
        this.setLayout(new MigLayout("wrap 1", "[grow]", "[grow][]"));
        this.textArea.setOpaque(false);
        this.textArea.setForeground(Color.BLACK);
        this.textArea.setPreferredSize(new Dimension(420, 250));
        this.textArea.setVerticalAlignment(1);
        this.textArea.setFont(new Font("arial", 0, 12));
        this.add((Component)this.iconPanel, "grow");
        this.add((Component)this.textArea, "alignx right, pad 0 0 0 -30");
        this.iconPanel.setOpaque(false);
        this.iconPanel.setLayout(new GridLayout(0, 6, 20, 20));
        try {
            this.init();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.fill();
        try {
            BufferedImage image = ImageIO.read(DemosPanel.class.getResource("notepad.png"));
            this.notepadHeight = image.getHeight();
            this.notepadInset = -this.notepadHeight;
            this.imagePainter = new ImagePainter(image);
            this.imagePainter.setHorizontalAlignment(AbstractLayoutPainter.HorizontalAlignment.RIGHT);
            this.imagePainter.setVerticalAlignment(AbstractLayoutPainter.VerticalAlignment.BOTTOM);
            this.imagePainter.setInsets(new Insets(0, 0, this.notepadInset, 30));
            this.imagePainter.setAntialiasing(true);
            this.setBackgroundPainter(new CompoundPainter(this.getBackgroundPainter(), this.imagePainter));
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    private void animateNotepad(AbstractDemo demo) {
        this.animatedDemo = demo;
        this.animator = new Animator(1000, this);
        this.animator.start();
    }

    private void init() throws IOException {
        List<AbstractDemo> demos = this.launcher.getDemos();
        for (final AbstractDemo demo : demos) {
            final Image imageReleased = this.getDemoIcon(demo, false);
            final Image imagePressed = this.getDemoIcon(demo, true);
            final MyLabel button = new MyLabel(new ImageIcon(imageReleased));
            button.setFocused(false);
            button.setHorizontalAlignment(0);
            button.setVerticalTextPosition(3);
            button.setHorizontalTextPosition(0);
            button.setBorder(null);
            button.setOpaque(false);
            button.setBackground(Color.RED.darker());
            button.setText(demo.getName());
            button.setFont(new Font("arial", 0, 12));
            button.setForeground(Color.WHITE);
            button.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.compList.add(button);
            button.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    if (e2.getClickCount() == 1) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                demo.run(true);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e2) {
                    button.setIcon(new ImageIcon(imagePressed));
                }

                @Override
                public void mouseReleased(MouseEvent e2) {
                    button.setIcon(new ImageIcon(imageReleased));
                }

                @Override
                public void mouseEntered(MouseEvent e2) {
                    button.setFocused(true);
                }

                @Override
                public void mouseExited(MouseEvent e2) {
                    button.setFocused(false);
                }
            });
            button.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e2) {
                    if (DemosPanel.this.animationDone) {
                        DemosPanel.this.updateInformation(demo);
                    } else if (DemosPanel.this.animator == null) {
                        DemosPanel.this.animateNotepad(demo);
                    }
                }
            });
        }
    }

    private Image getDemoIcon(AbstractDemo demo, boolean pressed) throws IOException {
        URL url = demo.getDemoIcon();
        if (pressed) {
            url = demo.getDemoInIcon();
        }
        BufferedImage image = ImageIO.read(url);
        return image.getScaledInstance(100, -1, 4);
    }

    public void fill() {
        this.iconPanel.removeAll();
        for (Component comp : this.compList) {
            this.iconPanel.add(comp);
        }
    }

    private void updateInformation(AbstractDemo demo) {
        StringTokenizer st = new StringTokenizer(demo.getDescription(), "\n");
        StringBuilder sb2 = new StringBuilder();
        sb2.append("<html>");
        sb2.append("<b>Feature / Demo Description</b><p><p>");
        while (st.hasMoreTokens()) {
            sb2.append(st.nextToken());
            sb2.append("<br>");
        }
        sb2.append("</html>");
        this.textArea.setText(sb2.toString());
    }

    @Override
    public void timingEvent(float fraction) {
        this.notepadInset = -this.notepadHeight + (int)(fraction * (float)this.notepadHeight) - 50;
        this.imagePainter.setInsets(new Insets(0, 0, this.notepadInset, 30));
        this.repaint();
    }

    @Override
    public void begin() {
    }

    @Override
    public void end() {
        this.animationDone = true;
        this.updateInformation(this.animatedDemo);
    }

    @Override
    public void repeat() {
    }

    class MyLabel
    extends JLabel {
        private boolean focused;

        public MyLabel() {
            this.focused = true;
        }

        public MyLabel(Icon icon) {
            super(icon);
            this.focused = true;
        }

        public void setFocused(boolean focused) {
            this.focused = focused;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g2) {
            if (this.focused) {
                int w2 = this.getWidth();
                int h2 = this.getHeight();
                Graphics2D g2d = (Graphics2D)g2.create();
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setPaint(new Color(255, 255, 255, 100));
                g2d.fillRoundRect(0, 0, w2, h2, 12, 12);
                g2d.setPaint(new Color(255, 255, 255, 150));
                g2d.drawRoundRect(0, 0, w2 - 1, h2 - 1, 12, 12);
                g2d.dispose();
            }
            super.paintComponent(g2);
        }
    }
}

