/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.treetable;

import com.dlsc.flexgantt.model.treetable.ColumnModelEvent;
import com.dlsc.flexgantt.model.treetable.IColumnModel;
import com.dlsc.flexgantt.model.treetable.IColumnModelListener;
import com.dlsc.flexgantt.model.treetable.KeyColumn;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.EventListenerList;

public class DefaultColumnModel
implements IColumnModel {
    private List<TreeTableColumn> columns;
    protected KeyColumn keyColumn = new KeyColumn("Name", String.class);
    private EventListenerList listenerList;

    public DefaultColumnModel() {
        this.columns = new ArrayList<TreeTableColumn>();
        this.listenerList = new EventListenerList();
    }

    public DefaultColumnModel(TreeTableColumn[] cols) {
        this();
        this.setColumns(cols);
    }

    public DefaultColumnModel(String[] cols) {
        this();
        if (cols == null) {
            throw new IllegalArgumentException("array of column names can not be NULL");
        }
        for (int i2 = 0; i2 < cols.length; ++i2) {
            if (cols[i2] == null) {
                throw new IllegalArgumentException("column name can not be NULL");
            }
            TreeTableColumn col = new TreeTableColumn(cols[i2], Object.class, i2);
            this.addColumn(col);
        }
    }

    public DefaultColumnModel(Collection<TreeTableColumn> cols) {
        this();
        this.setColumns(cols);
    }

    @Override
    public void setKeyColumn(KeyColumn column) {
        KeyColumn oldColumn = this.keyColumn;
        this.keyColumn = column;
        if (column == null) {
            this.fireColumnChanged(new ColumnModelEvent(this, oldColumn, ColumnModelEvent.ID.COLUMN_REMOVED));
        } else {
            this.fireColumnChanged(new ColumnModelEvent(this, this.keyColumn, ColumnModelEvent.ID.COLUMN_ADDED));
        }
    }

    @Override
    public KeyColumn getKeyColumn() {
        return this.keyColumn;
    }

    @Override
    public void addColumn(TreeTableColumn col) {
        if (col == null) {
            throw new IllegalArgumentException("column can not be NULL");
        }
        if (col instanceof KeyColumn) {
            throw new IllegalArgumentException("a key column can not be added as a standard column");
        }
        if (this.columns.contains(col)) {
            throw new IllegalArgumentException("column can not be added twice");
        }
        this.columns.add(col);
        this.fireColumnChanged(new ColumnModelEvent(this, col, ColumnModelEvent.ID.COLUMN_ADDED));
    }

    public void insertColumn(TreeTableColumn col, int index) {
        if (col == null) {
            throw new IllegalArgumentException("column can not be NULL");
        }
        if (col instanceof KeyColumn) {
            throw new IllegalArgumentException("key columns can not be inserted into the list of standard columns");
        }
        if (this.columns.contains(col)) {
            throw new IllegalArgumentException("column can not be added twice");
        }
        if (index < 0) {
            throw new IllegalArgumentException("column index can not be smaller than 0");
        }
        int i2 = Math.min(this.columns.size(), index);
        this.columns.add(i2, col);
        this.fireColumnChanged(new ColumnModelEvent(this, col, ColumnModelEvent.ID.COLUMN_INSERTED));
    }

    @Override
    public void moveColumn(int indexFrom, int indexTo) {
        if (indexFrom < 0) {
            throw new IllegalArgumentException("indexFrom can not be < 0 but was " + indexFrom);
        }
        if (indexFrom > this.getColumnCount() - 1) {
            throw new IllegalArgumentException("indexFrom can not be larger than column count - 1 but was " + indexFrom);
        }
        if (indexTo < 0) {
            throw new IllegalArgumentException("indexTo can not be < 0 but was " + indexTo);
        }
        if (indexTo > this.getColumnCount() - 1) {
            throw new IllegalArgumentException("indexTo can not be larger than column count - 1 but was " + indexTo);
        }
        if (indexFrom != indexTo) {
            TreeTableColumn column = this.columns.get(indexFrom);
            this.columns.remove(column);
            this.columns.add(indexTo, column);
            this.fireColumnChanged(new ColumnModelEvent(this, column, ColumnModelEvent.ID.COLUMN_MOVED));
        }
    }

    @Override
    public void removeColumn(TreeTableColumn col) {
        if (col == null) {
            throw new IllegalArgumentException("column can not be NULL");
        }
        if (col instanceof KeyColumn) {
            throw new IllegalArgumentException("a key column can not be removed from the list of value columns");
        }
        this.columns.remove(col);
        this.fireColumnChanged(new ColumnModelEvent(this, col, ColumnModelEvent.ID.COLUMN_REMOVED));
    }

    public void setColumns(Collection<TreeTableColumn> cols) {
        if (cols == null) {
            throw new IllegalArgumentException("colums can not be NULL");
        }
        for (int i2 = this.columns.size() - 1; i2 >= 0; --i2) {
            this.removeColumn(this.columns.get(i2));
        }
        for (TreeTableColumn element : cols) {
            this.addColumn(element);
        }
    }

    public void setColumns(TreeTableColumn[] cols) {
        if (cols == null) {
            throw new IllegalArgumentException("colums can not be NULL");
        }
        ArrayList<TreeTableColumn> list = new ArrayList<TreeTableColumn>();
        for (TreeTableColumn col : cols) {
            list.add(col);
        }
        this.setColumns(list);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public TreeTableColumn getColumn(int index) {
        if (index < this.columns.size()) {
            return this.columns.get(index);
        }
        return null;
    }

    @Override
    public int getColumnIndex(TreeTableColumn column) {
        if (column == null) {
            throw new IllegalArgumentException("column can not be NULL");
        }
        if (column.equals(this.keyColumn)) {
            return -1;
        }
        int index = this.columns.indexOf(column);
        if (index == -1) {
            return Integer.MAX_VALUE;
        }
        return index;
    }

    @Override
    public void addColumnModelListener(IColumnModelListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException("listener can not be NULL");
        }
        this.listenerList.add(IColumnModelListener.class, l2);
    }

    @Override
    public void removeColumnModelListener(IColumnModelListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException("listener can not be NULL");
        }
        this.listenerList.remove(IColumnModelListener.class, l2);
    }

    protected void fireColumnChanged(ColumnModelEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("event can not be NULL");
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            ((IColumnModelListener)listeners[i2 + 1]).columnModelChanged(evt);
        }
    }

    @Override
    public int getTotalColumnWidth() {
        int width = 0;
        if (this.keyColumn != null) {
            width = this.keyColumn.getWidth();
        }
        int count = this.getColumnCount();
        for (int i2 = 0; i2 < count; ++i2) {
            TreeTableColumn column = this.getColumn(i2);
            width += column.getWidth();
        }
        return width;
    }
}

