/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.scheduling;

import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.gantt.DefaultRelationship;
import com.dlsc.flexgantt.model.gantt.RelationshipType;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.model.scheduling.BufferType;
import com.dlsc.flexgantt.model.scheduling.ConstraintType;
import com.dlsc.flexgantt.model.scheduling.IConstraint;
import com.dlsc.flexgantt.model.scheduling.Violation;
import com.dlsc.flexgantt.model.scheduling.ViolationCode;

public abstract class AbstractConstraint<T, S extends IGranularity>
extends DefaultRelationship<T>
implements IConstraint<T, S> {
    private ConstraintType type = ConstraintType.HARD;
    private S bufferGranularity;
    private int bufferDuration;
    private BufferType bufferType = BufferType.MORE_OR_EXACTLY;

    protected AbstractConstraint(TimelineObjectPath<T> sourcePath, TimelineObjectPath<T> targetPath) {
        super(sourcePath, targetPath);
    }

    protected AbstractConstraint(TimelineObjectPath<T> sourcePath, TimelineObjectPath<T> targetPath, RelationshipType type) {
        super(sourcePath, targetPath, type);
    }

    @Override
    public Violation getViolation(long time1, long time2) {
        double delta = this.getDelta(time2, time1, this.getBufferGranularity());
        Violation violation = null;
        switch (this.getBufferType()) {
            case EXACTLY: {
                if (delta < (double)this.getBufferDuration()) {
                    violation = new Violation(ViolationCode.BUFFER_TOO_SMALL, delta);
                    break;
                }
                if (!(delta > (double)this.getBufferDuration())) break;
                violation = new Violation(ViolationCode.BUFFER_TOO_LARGE, delta);
                break;
            }
            case LESS_OR_EXACTLY: {
                if (delta <= (double)this.getBufferDuration()) break;
                violation = new Violation(ViolationCode.BUFFER_TOO_LARGE, delta);
                break;
            }
            case LESS_THAN: {
                if (delta < (double)this.getBufferDuration()) break;
                violation = new Violation(ViolationCode.BUFFER_TOO_LARGE, delta);
                break;
            }
            case MORE_OR_EXACTLY: {
                if (delta >= (double)this.getBufferDuration()) break;
                violation = new Violation(ViolationCode.BUFFER_TOO_SMALL, delta);
                break;
            }
            case MORE_THAN: {
                if (delta > (double)this.getBufferDuration()) break;
                violation = new Violation(ViolationCode.BUFFER_TOO_SMALL, delta);
            }
        }
        return violation;
    }

    protected abstract double getDelta(long var1, long var3, S var5);

    @Override
    public void setBufferType(BufferType type) {
        if (type == null) {
            throw new IllegalArgumentException("buffer type can not be null");
        }
        this.bufferType = type;
    }

    @Override
    public BufferType getBufferType() {
        return this.bufferType;
    }

    @Override
    public void setConstraintType(ConstraintType type) {
        this.type = type;
    }

    @Override
    public ConstraintType getConstraintType() {
        return this.type;
    }

    @Override
    public int getBufferDuration() {
        return this.bufferDuration;
    }

    @Override
    public void setBufferDuration(int bufferDuration) {
        this.bufferDuration = bufferDuration;
    }

    @Override
    public S getBufferGranularity() {
        return this.bufferGranularity;
    }

    @Override
    public void setBufferGranularity(S granularity) {
        if (granularity == null) {
            throw new IllegalArgumentException("granularity can not be null");
        }
        this.bufferGranularity = granularity;
    }

    @Override
    public String toString() {
        return "Constraint: Type = " + (Object)((Object)this.getConstraintType()) + ", " + this.getBufferDuration() + " " + this.getBufferGranularity();
    }
}

