/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.icons;

import com.dlsc.flexgantt.icons.IIconMap;
import com.dlsc.flexgantt.icons.IconId;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class AbstractIconMap
extends HashMap<IconId, Icon>
implements IIconMap {
    private static final Logger LOGGER = Logger.getLogger(AbstractIconMap.class.getName());
    private List<String> fileNames = new ArrayList<String>();
    private Dimension dimension;

    protected AbstractIconMap(int iconWidth, int iconHeight) {
        super(32);
        if (iconWidth <= 0) {
            throw new IllegalArgumentException("icon width must be larger than 0");
        }
        if (iconHeight <= 0) {
            throw new IllegalArgumentException("icon height must be larger than 0");
        }
        this.dimension = new Dimension(iconWidth, iconHeight);
    }

    @Override
    public Icon getIcon(IconId id2) {
        return (Icon)this.get((Object)id2);
    }

    @Override
    public Dimension getIconDimension() {
        return this.dimension;
    }

    @Override
    public Icon getDisabledIcon(IconId id2) {
        Icon icon = (Icon)this.get((Object)id2);
        if (icon instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)icon;
            Image image = imageIcon.getImage();
            image = GrayFilter.createDisabledImage(image);
            imageIcon.setImage(image);
        }
        return icon;
    }

    @Override
    public void setIcon(IconId id2, Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("icon can not be NULL");
        }
        this.put(id2, icon);
    }

    protected Icon loadIcon(Class<? extends AbstractIconMap> iconMap, String fileName) {
        LOGGER.fine("loading icon file: " + fileName + " relative to class " + iconMap);
        this.fileNames.add(fileName);
        URL url = iconMap.getResource(fileName);
        Image img = Toolkit.getDefaultToolkit().getImage(url);
        if (img != null) {
            return new ImageIcon(img);
        }
        return null;
    }

    public List<String> getLoadedFileNames() {
        return this.fileNames;
    }
}

