/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.layer;

import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.command.layer.AbstractDragAndDropCommand;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import java.util.ArrayList;

public class DefaultMultiDragAndDropCommand
extends AbstractDragAndDropCommand {
    private ITimelineObject[] timelineObjects;

    public DefaultMultiDragAndDropCommand(IGanttChartNode owner, ILayer layer, ITimelineObject[] timelineObjects, DefaultGanttChartModel model, IGanttChartNode newOwner, DefaultGanttChartModel newModel, int dropAction) {
        super(owner, layer, model, newOwner, newModel, dropAction);
        if (timelineObjects == null) {
            throw new IllegalArgumentException("timeline objects can not be NULL");
        }
        this.timelineObjects = timelineObjects;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        ArrayList<ITimelineObject> list = new ArrayList<ITimelineObject>();
        for (ITimelineObject tlo : this.timelineObjects) {
            list.add(tlo);
        }
        DefaultGanttChartModel oldModel = this.getOldModel();
        IGanttChartNode oldOwner = this.getOldOwner();
        DefaultGanttChartModel newModel = this.getNewModel();
        IGanttChartNode newOwner = this.getNewOwner();
        ILayer layer = this.getLayer();
        oldModel.removeTimelineObjects(oldOwner, layer, list);
        newModel.addTimelineObjects(newOwner, layer, list);
        for (ITimelineObject tlo : this.timelineObjects) {
            this.fixRelationships(tlo, oldOwner, newOwner, oldModel, newModel);
        }
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        ArrayList<ITimelineObject> list = new ArrayList<ITimelineObject>();
        for (ITimelineObject tlo : this.timelineObjects) {
            list.add(tlo);
        }
        DefaultGanttChartModel oldModel = this.getOldModel();
        IGanttChartNode oldOwner = this.getOldOwner();
        DefaultGanttChartModel newModel = this.getNewModel();
        IGanttChartNode newOwner = this.getNewOwner();
        ILayer layer = this.getLayer();
        newModel.removeTimelineObjects(newOwner, layer, list);
        oldModel.addTimelineObjects(oldOwner, layer, list);
        for (ITimelineObject tlo : this.timelineObjects) {
            this.fixRelationships(tlo, newOwner, oldOwner, newModel, oldModel);
        }
    }

    public ITimelineObject[] getTimelineObjects() {
        return this.timelineObjects;
    }
}

