/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.layer;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.DefaultTimelineObject;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.util.Messages;

public class DefaultCreateTimelineObjectCommand
extends AbstractCommand {
    private DefaultGanttChartNode node;
    private DefaultGanttChartModel model;
    private ILayer layer;
    private ITimeSpan timeSpan;
    private DefaultTimelineObject timelineObject;
    private int lineIndex;

    public DefaultCreateTimelineObjectCommand(DefaultGanttChartNode node, DefaultGanttChartModel model, ILayer layer, ITimeSpan timeSpan, int lineIndex) {
        super(Messages.getString("DefaultCreateTimelineObjectCommand.NAME"));
        if (node == null) {
            throw new IllegalArgumentException("node can not be NULL");
        }
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (timeSpan == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        this.node = node;
        this.model = model;
        this.layer = layer;
        this.timeSpan = timeSpan;
        this.lineIndex = lineIndex;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        if (this.timelineObject == null) {
            this.timelineObject = this.createTimelineObject();
            if (this.timelineObject == null) {
                throw new IllegalArgumentException("the timeline object can not be NULL");
            }
        }
        this.timelineObject.setTimeSpan(this.timeSpan);
        this.timelineObject.setLineIndex(this.lineIndex);
        this.model.addTimelineObject(this.node, this.layer, this.timelineObject);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        this.model.removeTimelineObject(this.node, this.layer, this.timelineObject);
    }

    protected DefaultTimelineObject createTimelineObject() {
        if (this.timelineObject != null) {
            throw new IllegalStateException("the timeline object of the command can only be created once");
        }
        return new DefaultTimelineObject();
    }

    public ILayer getLayer() {
        return this.layer;
    }

    public void setLayer(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        this.layer = layer;
    }

    public ITimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    public void setTimeSpan(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("span can not be NULL");
        }
        this.timeSpan = span;
    }

    public DefaultGanttChartNode getNode() {
        return this.node;
    }

    public void setNode(DefaultGanttChartNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node can not be NULL");
        }
        this.node = node;
    }

    public DefaultGanttChartModel getModel() {
        return this.model;
    }

    public void setModel(DefaultGanttChartModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        this.model = model;
    }

    public DefaultTimelineObject getNewTimelineObject() {
        return this.timelineObject;
    }

    public int getLineIndex() {
        return this.lineIndex;
    }
}

