/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.util;

import com.dlsc.flexgantt.util.INamedObject;
import com.dlsc.flexgantt.util.Messages;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class NamedObject
implements INamedObject {
    public static final String PROPERTY_NAME = "name";
    private PropertyChangeSupport changeSupport;
    private String name;

    public NamedObject(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can not be NULL!");
        }
        this.name = name;
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public NamedObject() {
        this(Messages.getString("NamedObject.NO_NAME"));
    }

    public void setName(String name) {
        if (name == null || name.trim().equals("")) {
            throw new IllegalArgumentException("name can not be null or blank");
        }
        String oldName = this.name;
        this.name = name;
        this.changeSupport.firePropertyChange(PROPERTY_NAME, oldName, name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    protected PropertyChangeSupport getChangeSupport() {
        return this.changeSupport;
    }

    @Override
    public int compareTo(INamedObject o) {
        if (o == null) {
            return -1;
        }
        return this.name.compareTo(o.getName());
    }

    public String toString() {
        return this.getName();
    }
}

