/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import com.dlsc.flexgantt.swing.util.ColorUtil;
import com.dlsc.flexgantt.swing.util.Simple3DBorder;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class RollOverLabel
extends JLabel
implements MouseListener {
    private Color focusForeground = ColorUtil.getFocusForeground();
    private Color focusBackground = ColorUtil.getFocusBackground();
    private Color bgColor;
    private Color fgColor;
    private boolean opaque;
    private boolean showingFocus;

    public RollOverLabel() {
        this.init();
    }

    public void setShowingFocus(boolean showingFocus) {
        this.showingFocus = showingFocus;
    }

    public boolean isShowingFocus() {
        return this.showingFocus;
    }

    public RollOverLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.init();
    }

    public RollOverLabel(Icon image) {
        super(image);
        this.init();
    }

    public RollOverLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.init();
    }

    public RollOverLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.init();
    }

    public RollOverLabel(String text) {
        super(text);
        this.init();
    }

    private void init() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(0);
        this.setBorder(new CompoundBorder(new Simple3DBorder(), new EmptyBorder(0, 5, 0, 5)));
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isShowingFocus()) {
            this.fgColor = this.getForeground();
            this.bgColor = this.getBackground();
            this.opaque = this.isOpaque();
            this.setForeground(this.focusForeground);
            this.setBackground(this.focusBackground);
            this.setOpaque(true);
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.isShowingFocus()) {
            this.setForeground(this.fgColor);
            this.setBackground(this.bgColor);
            this.setOpaque(this.opaque);
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

