/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import java.awt.Color;
import javax.swing.UIManager;

public class ColorUtil {
    private static int defaultAlpha = 200;
    private static Color focusForeground;
    private static Color focusBackground;
    private static Color selectionForeground;
    private static Color selectionBackground;
    private static Color gridColor;
    private static Color focusBorderColor;

    private ColorUtil() {
    }

    public static Color makeTransparent(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), defaultAlpha);
    }

    public static Color makeTransparent(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static int getDefaultAlpha() {
        return defaultAlpha;
    }

    public static void setDefaultAlpha(int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("the alpha value must be in the range of [0, 255] but was " + alpha);
        }
        defaultAlpha = alpha;
    }

    public static Color getFocusForeground() {
        return focusForeground;
    }

    public static void setFocusForeground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("focus foreground color can not be NULL");
        }
        focusForeground = color;
    }

    public static Color getFocusBackground() {
        return focusBackground;
    }

    public static void setFocusBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("focus background color can not be NULL");
        }
        focusBackground = color;
    }

    public static Color getSelectionForeground() {
        return selectionForeground;
    }

    public static void setSelectionForeground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selection foreground color can not be NULL");
        }
        selectionForeground = color;
    }

    public static Color getSelectionBackground() {
        return selectionBackground;
    }

    public static void setSelectionBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selection background color can not be NULL");
        }
        selectionBackground = color;
    }

    public static Color getGridColor() {
        return gridColor;
    }

    public static void setGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("grid color can not be NULL");
        }
        gridColor = color;
    }

    public static Color getFocusBorderColor() {
        return focusBorderColor;
    }

    public static void setFocusBorderColor(Color color) {
        focusBorderColor = color;
    }

    static {
        selectionForeground = UIManager.getColor("Table.selectionForeground");
        selectionBackground = UIManager.getColor("Table.selectionBackground");
        gridColor = Color.GRAY;
        if (selectionBackground == null) {
            selectionBackground = Color.BLUE;
        }
        if (selectionForeground == null) {
            selectionForeground = Color.WHITE;
        }
        focusForeground = selectionForeground;
        focusBorderColor = focusBackground = selectionBackground;
        if (!System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            focusBorderColor = Color.BLUE;
        }
    }
}

