/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class ColorField
extends JPanel {
    public static final String PROPERTY_COLOR = "color";
    private Color color = Color.WHITE;

    public ColorField(Color c) {
        this.setColor(c);
        this.setPreferredSize(new Dimension(32, 16));
        this.setOpaque(true);
    }

    public ColorField() {
        this(Color.WHITE);
    }

    public void setColor(Color c) {
        Color oldColor = this.color;
        this.color = c;
        this.firePropertyChange(PROPERTY_COLOR, oldColor, this.color);
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(this.color);
        g.fillRect(3, 3, w - 6, h - 6);
        g.setColor(this.getForeground());
        g.drawRect(3, 3, w - 6, h - 6);
    }
}

