/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import javax.swing.SwingUtilities;

public abstract class AbstractSwingWorker {
    private Object value;
    private ThreadVar threadVar;

    public AbstractSwingWorker() {
        final Runnable doFinished = new Runnable(){

            @Override
            public void run() {
                AbstractSwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractSwingWorker.this.setValue(AbstractSwingWorker.this.construct());
                }
                finally {
                    AbstractSwingWorker.this.threadVar.clear();
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread t = new Thread(doConstruct);
        t.setName("SwingWorkerThread");
        this.threadVar = new ThreadVar(t);
    }

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object x) {
        this.value = x;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread t;
        while ((t = this.threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public void start() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

