/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.treetable;

import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.GanttChartControl;
import com.dlsc.flexgantt.swing.IComponentFactory;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableRowHeader;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class TreeTableScrollPane
extends JScrollPane {
    private boolean primary;
    private AbstractGanttChart ganttChart;

    public TreeTableScrollPane(TreeTable table, TreeTableRowHeader treeTableRowHeader, GanttChartControl treeTableHeader, boolean primary) {
        String[] corners;
        this.primary = primary;
        this.ganttChart = table.getGanttChart();
        this.setViewportView(table);
        if (primary) {
            this.setColumnHeaderView(treeTableHeader);
        }
        this.setRowHeaderView(treeTableRowHeader);
        this.setHorizontalScrollBarPolicy(32);
        this.setVerticalScrollBarPolicy(21);
        this.setWheelScrollingEnabled(true);
        this.setDoubleBuffered(true);
        this.getViewport().setDoubleBuffered(true);
        IComponentFactory compFactory = this.ganttChart.getComponentFactory();
        for (String str : corners = new String[]{"UPPER_LEFT_CORNER", "UPPER_RIGHT_CORNER", "LOWER_LEFT_CORNER", "LOWER_RIGHT_CORNER"}) {
            this.setCorner(str, compFactory.createTreeTableCorner(table, str));
        }
        this.getViewport().setScrollMode(1);
        if (this.getColumnHeader() != null) {
            this.getColumnHeader().setScrollMode(1);
        }
        this.getRowHeader().setScrollMode(1);
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public TreeTable getTreeTable() {
        return (TreeTable)this.getViewport().getView();
    }

    public GanttChartControl getTreeTableColumnHeader() {
        return (GanttChartControl)this.getColumnHeader().getView();
    }

    public TreeTableRowHeader getTreeTableRowHeader() {
        return (TreeTableRowHeader)this.getRowHeader().getView();
    }

    @Override
    public Dimension getMinimumSize() {
        int width = this.getTreeTableRowHeader().getPreferredSize().width;
        int height = 0;
        height = this.primary ? this.columnHeader.getPreferredSize().height : this.getHorizontalScrollBar().getPreferredSize().height;
        Border border = this.getBorder();
        if (border != null) {
            Insets insets = this.getBorder().getBorderInsets(this);
            width += insets.right + insets.left;
            height += insets.top + insets.bottom;
        }
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension a = this.getTreeTableRowHeader().getPreferredSize();
        Dimension b = this.getTreeTableColumnHeader().getPreferredSize();
        return new Dimension(a.width + b.width, Math.max(a.height, b.height));
    }

    public AbstractGanttChart getGanttChart() {
        return this.ganttChart;
    }
}

