/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.treetable;

import com.dlsc.flexgantt.swing.AbstractRowHeader;
import com.dlsc.flexgantt.swing.treetable.DefaultTreeTableRowHeaderRenderer;
import com.dlsc.flexgantt.swing.treetable.ITreeTableRowHeaderRenderer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class TreeTableRowHeader
extends AbstractRowHeader<ITreeTableRowHeaderRenderer> {
    private static final Cursor CURSOR_TOGGLE = new Cursor(12);

    public TreeTableRowHeader(TreeTable table) {
        super(table);
        table.setRowHeader(this);
        this.setRowHeaderRenderer(Object.class, new DefaultTreeTableRowHeaderRenderer());
        this.setName("TreeTableRowHeader");
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = new Dimension();
        dim.height = this.getTreeTable().getPreferredSize().height;
        dim.width = this.getGanttChart().getTreeTableRowHeaderWidth();
        return dim;
    }

    private boolean isToggleLocation(MouseEvent e, int row) {
        TreeTable table = this.getTreeTable();
        List<TreeTableNode> nodes = table.getTreeTableNodes();
        if (row >= 0 && row < nodes.size()) {
            TreeTableNode node = nodes.get(row);
            Object modelNode = node.getModelNode();
            Object rowHeaderValue = table.getModel().getRowHeaderValue(modelNode);
            ITreeTableRowHeaderRenderer renderer = (ITreeTableRowHeaderRenderer)this.getRowHeaderRenderer(rowHeaderValue.getClass());
            if (!renderer.isDisplayedAsLeaf(table.getModel(), modelNode)) {
                Rectangle rect = renderer.getRowHeaderToggleBounds(this, 0, node.getY(), this.getWidth(), node.getHeight());
                return rect.contains(e.getPoint());
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreeTable table;
        int row;
        if (this.isEnabled() && !this.maybeShowPopup(e) && SwingUtilities.isLeftMouseButton(e) && (row = (table = this.getTreeTable()).getRowAt(e.getY())) != -1) {
            List<TreeTableNode> nodes = table.getTreeTableNodes();
            if (this.getCursor().equals(CURSOR_TOGGLE)) {
                if (this.isToggleLocation(e, row)) {
                    TreeTableNode node = nodes.get(row);
                    TreePath path = node.getPath();
                    if (node.isExpanded()) {
                        table.collapsePathAnimated(path);
                    } else {
                        table.expandPathAnimated(path);
                    }
                }
            } else {
                super.mouseClicked(e);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        TreeTable table = this.getTreeTable();
        int row = table.getRowAt(e.getY());
        if (row != -1 && this.isToggleLocation(e, row)) {
            this.setCursor(CURSOR_TOGGLE);
            return;
        }
        super.mouseMoved(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getSource().equals(this.getGanttChart()) && evt.getPropertyName().equals("treeTableRowHeaderWidth")) {
            this.setSize(this.getPreferredSize());
        }
    }
}

